/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.moladb.model.transform;

import com.baidubce.BceClientException;
import com.baidubce.services.moladb.model.AttributeValue;
import com.baidubce.services.moladb.model.transform.Unmarshaller;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeValueUnmarshaller
implements Unmarshaller<AttributeValue, JsonNode> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public AttributeValue unmarshall(JsonNode jsonObj) throws Exception {
        if (jsonObj.isNull()) {
            this.logger.error("Input json obj is null");
            throw new BceClientException("Input json obj is null");
        }
        if (!jsonObj.isObject() || 0 == jsonObj.size()) {
            this.logger.error("Input json node:" + jsonObj.toString() + " is not a object or size is 0");
            throw new BceClientException("Illegal json:" + jsonObj.toString() + " for AttributeValue");
        }
        AttributeValue value = new AttributeValue();
        Iterator fieldNames = jsonObj.fieldNames();
        String type = (String)fieldNames.next();
        String val = jsonObj.get(type).asText();
        value.setValue(type, val);
        return value;
    }
}

