/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.rocketmq;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bcc.BccClientConfiguration;
import com.baidubce.services.rocketmq.RocketMQConstants;
import com.baidubce.services.rocketmq.model.Message;
import com.baidubce.services.rocketmq.model.request.CreateAclUserConfigRequest;
import com.baidubce.services.rocketmq.model.request.CreateClusterRequest;
import com.baidubce.services.rocketmq.model.request.CreateConsumerGroupRequest;
import com.baidubce.services.rocketmq.model.request.CreateTopicRequest;
import com.baidubce.services.rocketmq.model.request.DeleteAclUserConfigRequest;
import com.baidubce.services.rocketmq.model.request.DeleteClusterRequest;
import com.baidubce.services.rocketmq.model.request.DeleteConsumerGroupRequest;
import com.baidubce.services.rocketmq.model.request.DeleteTopicRequest;
import com.baidubce.services.rocketmq.model.request.ExpandBrokerRequest;
import com.baidubce.services.rocketmq.model.request.GetAclUserRequest;
import com.baidubce.services.rocketmq.model.request.GetClusterAccessEndpointsRequest;
import com.baidubce.services.rocketmq.model.request.GetClusterRequest;
import com.baidubce.services.rocketmq.model.request.GetConsumerGroupRequest;
import com.baidubce.services.rocketmq.model.request.GetTopicRequest;
import com.baidubce.services.rocketmq.model.request.IncreaseStorageSizeRequest;
import com.baidubce.services.rocketmq.model.request.ListActionOperationsRequest;
import com.baidubce.services.rocketmq.model.request.ListClusterAclUserConfigsRequest;
import com.baidubce.services.rocketmq.model.request.ListClusterActionsRequest;
import com.baidubce.services.rocketmq.model.request.ListClusterBrokerNodesRequest;
import com.baidubce.services.rocketmq.model.request.ListClusterConsumerGroupsRequest;
import com.baidubce.services.rocketmq.model.request.ListClusterTopicsRequest;
import com.baidubce.services.rocketmq.model.request.ListClustersRequest;
import com.baidubce.services.rocketmq.model.request.ListConsumeStatesRequest;
import com.baidubce.services.rocketmq.model.request.ListConsumerClientsRequest;
import com.baidubce.services.rocketmq.model.request.ListConsumerGroupSubscriptionsRequest;
import com.baidubce.services.rocketmq.model.request.ListConsumerGroupUsersRequest;
import com.baidubce.services.rocketmq.model.request.ListTopicQueuesRequest;
import com.baidubce.services.rocketmq.model.request.ListTopicSubscriptionsRequest;
import com.baidubce.services.rocketmq.model.request.ListTopicUsersRequest;
import com.baidubce.services.rocketmq.model.request.ModifyBrokerNodeTypeRequest;
import com.baidubce.services.rocketmq.model.request.QueryMessageListRequest;
import com.baidubce.services.rocketmq.model.request.QueryMessageRequest;
import com.baidubce.services.rocketmq.model.request.ResetConsumeOffsetRequest;
import com.baidubce.services.rocketmq.model.request.RestartBrokerNodeRequest;
import com.baidubce.services.rocketmq.model.request.SendMessageRequest;
import com.baidubce.services.rocketmq.model.request.StartClusterRequest;
import com.baidubce.services.rocketmq.model.request.StopClusterRequest;
import com.baidubce.services.rocketmq.model.request.UpdateAclUserConfigRequest;
import com.baidubce.services.rocketmq.model.request.UpdateConsumerGroupRequest;
import com.baidubce.services.rocketmq.model.request.UpdateTopicRequest;
import com.baidubce.services.rocketmq.model.response.CreateAclUserResponse;
import com.baidubce.services.rocketmq.model.response.CreateClusterResponse;
import com.baidubce.services.rocketmq.model.response.CreateConsumerGroupResponse;
import com.baidubce.services.rocketmq.model.response.CreateTopicResponse;
import com.baidubce.services.rocketmq.model.response.DeleteAclUserConfigResponse;
import com.baidubce.services.rocketmq.model.response.DeleteClusterResponse;
import com.baidubce.services.rocketmq.model.response.DeleteConsumerGroupResponse;
import com.baidubce.services.rocketmq.model.response.DeleteTopicResponse;
import com.baidubce.services.rocketmq.model.response.ExpandBrokerResponse;
import com.baidubce.services.rocketmq.model.response.GetAclUserConfigResponse;
import com.baidubce.services.rocketmq.model.response.GetClusterAccessEndpointsResponse;
import com.baidubce.services.rocketmq.model.response.GetClusterResponse;
import com.baidubce.services.rocketmq.model.response.GetConsumerGroupResponse;
import com.baidubce.services.rocketmq.model.response.GetTopicResponse;
import com.baidubce.services.rocketmq.model.response.IncreaseStorageSizeResponse;
import com.baidubce.services.rocketmq.model.response.ListActionOperationsResponse;
import com.baidubce.services.rocketmq.model.response.ListClusterAclUserConfigsResponse;
import com.baidubce.services.rocketmq.model.response.ListClusterActionsResponse;
import com.baidubce.services.rocketmq.model.response.ListClusterBrokerNodesResponse;
import com.baidubce.services.rocketmq.model.response.ListClusterConsumerGroupsResponse;
import com.baidubce.services.rocketmq.model.response.ListClusterTopicsResponse;
import com.baidubce.services.rocketmq.model.response.ListClustersResponse;
import com.baidubce.services.rocketmq.model.response.ListConsumeStatesResponse;
import com.baidubce.services.rocketmq.model.response.ListConsumerClientsResponse;
import com.baidubce.services.rocketmq.model.response.ListConsumerGroupSubscriptionsResponse;
import com.baidubce.services.rocketmq.model.response.ListConsumerGroupUsersResponse;
import com.baidubce.services.rocketmq.model.response.ListTopicQueuesResponse;
import com.baidubce.services.rocketmq.model.response.ListTopicSubscriptionsResponse;
import com.baidubce.services.rocketmq.model.response.ListTopicUsersResponse;
import com.baidubce.services.rocketmq.model.response.ModifyBrokerNodeTypeResponse;
import com.baidubce.services.rocketmq.model.response.QueryMessageListResponse;
import com.baidubce.services.rocketmq.model.response.QueryMessageResponse;
import com.baidubce.services.rocketmq.model.response.ResetConsumeOffsetResponse;
import com.baidubce.services.rocketmq.model.response.RestartBrokerNodeResponse;
import com.baidubce.services.rocketmq.model.response.SendMessageResponse;
import com.baidubce.services.rocketmq.model.response.StartClusterResponse;
import com.baidubce.services.rocketmq.model.response.StopClusterResponse;
import com.baidubce.services.rocketmq.model.response.UpdateAclUserConfigResponse;
import com.baidubce.services.rocketmq.model.response.UpdateConsumerGroupResponse;
import com.baidubce.services.rocketmq.model.response.UpdateTopicResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Base64;

public class RocketMQClient
extends AbstractBceClient {
    public RocketMQClient() {
        this(new BccClientConfiguration());
    }

    public RocketMQClient(BceClientConfiguration configuration) {
        super(configuration, RocketMQConstants.ROCKETMQ_HANDLERS);
    }

    public RocketMQClient(BceClientConfiguration configuration, HttpResponseHandler[] responseHandlers, boolean isHttpAsyncPutEnabled) {
        super(configuration, responseHandlers, isHttpAsyncPutEnabled);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String url) {
        URI uri = HttpUtils.appendUri(this.getEndpoint(), url);
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(RocketMQConstants.HEADERS_TO_SIGN);
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            byte[] requestJson;
            String strJson = JsonUtils.toJsonString(bceRequest);
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ListClustersResponse listClusters(ListClustersRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, "/v1/clusters");
        if (!Strings.isNullOrEmpty((String)request.getMarker())) {
            internalRequest.addParameter("marker", request.getMarker());
        }
        if (request.getMaxKeys() <= 1000 && request.getMaxKeys() > 0) {
            internalRequest.addParameter("maxKeys", String.valueOf(request.getMaxKeys()));
        }
        if (!Strings.isNullOrEmpty((String)request.getClusterName())) {
            internalRequest.addParameter("clusterName", request.getClusterName());
        }
        if (!Strings.isNullOrEmpty((String)request.getState())) {
            internalRequest.addParameter("state", request.getState());
        }
        if (!Strings.isNullOrEmpty((String)request.getArch())) {
            internalRequest.addParameter("mode", request.getArch());
        }
        if (!Strings.isNullOrEmpty((String)request.getRocketmqVersion())) {
            internalRequest.addParameter("rocketmqVersion", request.getRocketmqVersion());
        }
        if (!Strings.isNullOrEmpty((String)request.getPayment())) {
            internalRequest.addParameter("payment", request.getPayment());
        }
        if (!Strings.isNullOrEmpty((String)request.getTagKey())) {
            if (request.getTagValue() == null) throw new IllegalArgumentException("tagValue should not be null or empty.");
            internalRequest.addParameter("tagKey", request.getTagKey());
            internalRequest.addParameter("tagValue", request.getTagValue());
            return this.invokeHttpClient(internalRequest, ListClustersResponse.class);
        } else {
            if (request.getTagValue() == null) return this.invokeHttpClient(internalRequest, ListClustersResponse.class);
            throw new IllegalArgumentException("tagKey should not be null or empty.");
        }
    }

    public CreateClusterResponse createCluster(CreateClusterRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getName(), "clusterName should not be null or empty.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, "/v1/clusters");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateClusterResponse.class);
    }

    public GetClusterResponse getCluster(GetClusterRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, GetClusterResponse.class);
    }

    public DeleteClusterResponse deleteCluster(DeleteClusterRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, url);
        return this.invokeHttpClient(internalRequest, DeleteClusterResponse.class);
    }

    public StopClusterResponse stopCluster(StopClusterRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        internalRequest.addParameter("action", "stopCluster");
        return this.invokeHttpClient(internalRequest, StopClusterResponse.class);
    }

    public StartClusterResponse startCluster(StartClusterRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        internalRequest.addParameter("action", "startCluster");
        return this.invokeHttpClient(internalRequest, StartClusterResponse.class);
    }

    public GetClusterAccessEndpointsResponse getAccessEndpoints(GetClusterAccessEndpointsRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s/access-endpoints", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, GetClusterAccessEndpointsResponse.class);
    }

    public ListClusterBrokerNodesResponse listClusterBrokerNodes(ListClusterBrokerNodesRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s/broker-nodes", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListClusterBrokerNodesResponse.class);
    }

    public ListClusterTopicsResponse listClusterTopics(ListClusterTopicsRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s/topics", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListClusterTopicsResponse.class);
    }

    public ListClusterConsumerGroupsResponse listClusterConsumerGroups(ListClusterConsumerGroupsRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListClusterConsumerGroupsResponse.class);
    }

    public ListClusterAclUserConfigsResponse listClusterAclUsers(ListClusterAclUserConfigsRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s/users", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListClusterAclUserConfigsResponse.class);
    }

    public ListClusterActionsResponse listClusterAclUsers(ListClusterActionsRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s/actions", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListClusterActionsResponse.class);
    }

    public IncreaseStorageSizeResponse increaseStorageSize(IncreaseStorageSizeRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        internalRequest.addParameter("action", "increaseStorageSize");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, IncreaseStorageSizeResponse.class);
    }

    public ExpandBrokerResponse expandBroker(ExpandBrokerRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        internalRequest.addParameter("action", "expandBroker");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ExpandBrokerResponse.class);
    }

    public ModifyBrokerNodeTypeResponse modifyBrokerNodeType(ModifyBrokerNodeTypeRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        internalRequest.addParameter("action", "modifyBrokerNodeType");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ModifyBrokerNodeTypeResponse.class);
    }

    public RestartBrokerNodeResponse restartBrokerNode(RestartBrokerNodeRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        internalRequest.addParameter("action", "restartBrokerNode");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RestartBrokerNodeResponse.class);
    }

    public CreateTopicResponse createTopic(CreateTopicRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        String url = String.format("/v1/clusters/%s/topics/%s", request.getClusterId(), request.getTopicName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, url);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateTopicResponse.class);
    }

    public GetTopicResponse getTopic(GetTopicRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getTopicName(), "topicName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/topics/%s", request.getClusterId(), request.getTopicName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, GetTopicResponse.class);
    }

    public UpdateTopicResponse updateTopic(UpdateTopicRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getTopicName(), "topicName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/topics/%s", request.getClusterId(), request.getTopicName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateTopicResponse.class);
    }

    public DeleteTopicResponse deleteTopic(DeleteTopicRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getTopicName(), "topicName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/topics/%s", request.getClusterId(), request.getTopicName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, url);
        return this.invokeHttpClient(internalRequest, DeleteTopicResponse.class);
    }

    public ListTopicQueuesResponse listTopicQueue(ListTopicQueuesRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getTopicName(), "topicName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/topics/%s/queues", request.getClusterId(), request.getTopicName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListTopicQueuesResponse.class);
    }

    public ListTopicSubscriptionsResponse listTopicSubscription(ListTopicSubscriptionsRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getTopicName(), "topicName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/topics/%s/subscriptions", request.getClusterId(), request.getTopicName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListTopicSubscriptionsResponse.class);
    }

    public QueryMessageListResponse queryMessageList(QueryMessageListRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getTopicName(), "topicName should not be null or empty.");
        if (request.getBeginTime() == null || request.getBeginTime() <= 0L) {
            throw new IllegalArgumentException("message begin timestamp should not be null or invalid.");
        }
        if (request.getEndTime() == null || request.getEndTime() <= 0L) {
            throw new IllegalArgumentException("message end timestamp should not be null or invalid.");
        }
        String url = String.format("/v1/clusters/%s/topics/%s/messages", request.getClusterId(), request.getTopicName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        internalRequest.addParameter("beginTime", request.getBeginTime().toString());
        internalRequest.addParameter("endTime", request.getEndTime().toString());
        if (request.getMessageId() != null) {
            internalRequest.addParameter("messageId", request.getMessageId());
        }
        if (request.getMessageKey() != null) {
            internalRequest.addParameter("messageKey", request.getMessageKey());
        }
        QueryMessageListResponse.QueryMessageListInnerResponse innerResponse = this.invokeHttpClient(internalRequest, QueryMessageListResponse.QueryMessageListInnerResponse.class);
        QueryMessageListResponse response = new QueryMessageListResponse();
        response.setMessages(new ArrayList<Message>());
        response.setMessage(innerResponse.getMessage());
        response.setCode(innerResponse.getCode());
        response.setRequestId(innerResponse.getRequestId());
        response.setMarker(innerResponse.getMarker());
        response.setIsTruncated(innerResponse.getIsTruncated());
        response.setMaxKeys(innerResponse.getMaxKeys());
        response.setNextMarker(innerResponse.getNextMarker());
        innerResponse.getMessages().forEach(messageInner -> {
            Message message = new Message();
            message.setMsgId(messageInner.getMsgId());
            message.setTopicName(messageInner.getTopicName());
            message.setTag(messageInner.getTag());
            message.setKey(messageInner.getKey());
            message.setStoreTime(messageInner.getStoreTime());
            message.setBody(Base64.getDecoder().decode(messageInner.getBase64Body()));
            response.getMessages().add(message);
        });
        return response;
    }

    public ListTopicUsersResponse listTopicUsers(ListTopicUsersRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getTopicName(), "topicName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/topics/%s/users", request.getClusterId(), request.getTopicName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListTopicUsersResponse.class);
    }

    public CreateConsumerGroupResponse createConsumerGroup(CreateConsumerGroupRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getConsumerGroupName(), "consumerGroupName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups/%s", request.getClusterId(), request.getConsumerGroupName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, url);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateConsumerGroupResponse.class);
    }

    public GetConsumerGroupResponse getConsumerGroup(GetConsumerGroupRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getConsumerGroupName(), "consumerGroupName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups/%s", request.getClusterId(), request.getConsumerGroupName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, GetConsumerGroupResponse.class);
    }

    public UpdateConsumerGroupResponse updateConsumerGroup(UpdateConsumerGroupRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getConsumerGroupName(), "consumerGroupName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups/%s", request.getClusterId(), request.getConsumerGroupName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateConsumerGroupResponse.class);
    }

    public DeleteConsumerGroupResponse deleteConsumerGroup(DeleteConsumerGroupRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getConsumerGroupName(), "consumerGroupName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups/%s", request.getClusterId(), request.getConsumerGroupName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, url);
        return this.invokeHttpClient(internalRequest, DeleteConsumerGroupResponse.class);
    }

    public ResetConsumeOffsetResponse resetConsumeOffset(ResetConsumeOffsetRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getConsumerGroupName(), "consumerGroupName should not be null or empty.");
        Validate.checkStringNotEmpty(request.getTopicName(), "topicName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups/%s/offset", request.getClusterId(), request.getConsumerGroupName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ResetConsumeOffsetResponse.class);
    }

    public ListConsumerClientsResponse listConsumerClients(ListConsumerClientsRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getConsumerGroupName(), "consumerGroupName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups/%s/clients", request.getClusterId(), request.getConsumerGroupName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListConsumerClientsResponse.class);
    }

    public ListConsumerGroupSubscriptionsResponse listConsumerGroupSubscriptions(ListConsumerGroupSubscriptionsRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getConsumerGroupName(), "consumerGroupName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups/%s/subscriptions", request.getClusterId(), request.getConsumerGroupName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListConsumerGroupSubscriptionsResponse.class);
    }

    public ListConsumerGroupUsersResponse listConsumerGroupUsers(ListConsumerGroupUsersRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getConsumerGroupName(), "consumerGroupName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups/%s/users", request.getClusterId(), request.getConsumerGroupName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListConsumerGroupUsersResponse.class);
    }

    public ListConsumeStatesResponse listConsumeStates(ListConsumeStatesRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getConsumerGroupName(), "consumerGroupName should not be null or empty.");
        String url = String.format("/v1/clusters/%s/consumer-groups/%s/offset", request.getClusterId(), request.getConsumerGroupName());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        internalRequest.addParameter("topicName", request.getTopicName());
        if (request.getBrokerNames() != null && !request.getBrokerNames().isEmpty()) {
            internalRequest.addParameter("brokerNames", String.join((CharSequence)",", request.getBrokerNames()));
        }
        return this.invokeHttpClient(internalRequest, ListConsumeStatesResponse.class);
    }

    public CreateAclUserResponse createAclUser(CreateAclUserConfigRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getUsername(), "username should not be null or empty.");
        String url = String.format("/v1/clusters/%s/users/%s", request.getClusterId(), request.getUsername());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, url);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateAclUserResponse.class);
    }

    public GetAclUserConfigResponse getAclUser(GetAclUserRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getUsername(), "username should not be null or empty.");
        String url = String.format("/v1/clusters/%s/users/%s", request.getClusterId(), request.getUsername());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, GetAclUserConfigResponse.class);
    }

    public UpdateAclUserConfigResponse updateAclUser(UpdateAclUserConfigRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getUsername(), "username should not be null or empty.");
        String url = String.format("/v1/clusters/%s/users/%s", request.getClusterId(), request.getUsername());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, url);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateAclUserConfigResponse.class);
    }

    public DeleteAclUserConfigResponse deleteAclUser(DeleteAclUserConfigRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getUsername(), "username should not be null or empty.");
        String url = String.format("/v1/clusters/%s/users/%s", request.getClusterId(), request.getUsername());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, url);
        return this.invokeHttpClient(internalRequest, DeleteAclUserConfigResponse.class);
    }

    public SendMessageResponse sendMessage(SendMessageRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getTopicName(), "topicName should not be null or empty.");
        Validate.checkNotNull(request.getBody(), "message body should not be null or empty.");
        String url = String.format("/v1/clusters/%s/messages", request.getClusterId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, url);
        SendMessageRequest.SendMessageInnerRequest innerRequest = new SendMessageRequest.SendMessageInnerRequest();
        innerRequest.setTopicName(request.getTopicName());
        innerRequest.setKey(request.getKey());
        innerRequest.setTag(request.getTag());
        innerRequest.setBase64Body(Base64.getEncoder().encodeToString(request.getBody()));
        this.fillPayload(internalRequest, innerRequest);
        return this.invokeHttpClient(internalRequest, SendMessageResponse.class);
    }

    public QueryMessageResponse queryMessage(QueryMessageRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getMessageId(), "messageId should not be null or empty.");
        String url = String.format("/v1/clusters/%s/messages/%s", request.getClusterId(), request.getMessageId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        if (request.getTopicName() != null) {
            internalRequest.addParameter("topicName", request.getTopicName());
        }
        QueryMessageResponse.QueryMessageInnerResponse innerResponse = this.invokeHttpClient(internalRequest, QueryMessageResponse.QueryMessageInnerResponse.class);
        QueryMessageResponse response = new QueryMessageResponse();
        response.setCode(innerResponse.getCode());
        response.setMessage(innerResponse.getMessage());
        response.setRequestId(innerResponse.getRequestId());
        Message message = new Message();
        message.setMsgId(innerResponse.getMessageDetail().getMsgId());
        message.setTopicName(innerResponse.getMessageDetail().getTopicName());
        message.setTag(innerResponse.getMessageDetail().getTag());
        message.setKey(innerResponse.getMessageDetail().getKey());
        message.setStoreTime(innerResponse.getMessageDetail().getStoreTime());
        message.setBody(Base64.getDecoder().decode(innerResponse.getMessageDetail().getBase64Body()));
        response.setMessageDetail(message);
        return response;
    }

    public ListActionOperationsResponse listActionOperations(ListActionOperationsRequest request) {
        Validate.checkNotNull(request, "request should not be null.");
        Validate.checkStringNotEmpty(request.getClusterId(), "clusterId should not be null or empty.");
        Validate.checkStringNotEmpty(request.getActionId(), "actionId should not be null or empty.");
        String url = String.format("/v1/clusters/%s/actions/%s/operations", request.getClusterId(), request.getActionId());
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, url);
        return this.invokeHttpClient(internalRequest, ListActionOperationsResponse.class);
    }
}

