/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.rocketmq;

import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

class RocketMQConstants {
    static final String ROCKETMQ_BROKER_NAME = "rocketmq-broker";
    static final Set<String> HEADERS_TO_SIGN = new HashSet<String>(Arrays.asList("host", "x-bce-date"));
    static final HttpResponseHandler[] ROCKETMQ_HANDLERS = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};
    static final String API_VERSION_V1 = "v1";
    static final String CLUSTER_CREATE = "/v1/clusters";
    static final String CLUSTER_LIST = "/v1/clusters";
    static final String CLUSTER_GET = "/v1/clusters/%s";
    static final String CLUSTER_DELETE = "/v1/clusters/%s";
    static final String CLUSTER_ACTION = "/v1/clusters/%s";
    static final String CLUSTER_GET_ACCESS_ENDPOINTS = "/v1/clusters/%s/access-endpoints";
    static final String CLUSTER_LIST_BROKER_NODES = "/v1/clusters/%s/broker-nodes";
    static final String CLUSTER_LIST_TOPICS = "/v1/clusters/%s/topics";
    static final String CLUSTER_LIST_CONSUMER_GROUPS = "/v1/clusters/%s/consumer-groups";
    static final String CLUSTER_LIST_ACL_USERS = "/v1/clusters/%s/users";
    static final String CLUSTER_LIST_ACTIONS = "/v1/clusters/%s/actions";
    static final String TOPIC_CREATE = "/v1/clusters/%s/topics/%s";
    static final String TOPIC_GET = "/v1/clusters/%s/topics/%s";
    static final String TOPIC_UPDATE = "/v1/clusters/%s/topics/%s";
    static final String TOPIC_DELETE = "/v1/clusters/%s/topics/%s";
    static final String TOPIC_LIST_QUEUES = "/v1/clusters/%s/topics/%s/queues";
    static final String TOPIC_LIST_SUBSCRIPTIONS = "/v1/clusters/%s/topics/%s/subscriptions";
    static final String CONSUMER_GROUP_CREATE = "/v1/clusters/%s/consumer-groups/%s";
    static final String CONSUMER_GROUP_GET = "/v1/clusters/%s/consumer-groups/%s";
    static final String CONSUMER_GROUP_UPDATE = "/v1/clusters/%s/consumer-groups/%s";
    static final String CONSUMER_GROUP_DELETE = "/v1/clusters/%s/consumer-groups/%s";
    static final String CONSUMER_GROUP_LIST_SUBSCRIPTIONS = "/v1/clusters/%s/consumer-groups/%s/subscriptions";
    static final String CONSUMER_GROUP_LIST_CLIENTS = "/v1/clusters/%s/consumer-groups/%s/clients";
    static final String CONSUMER_GROUP_LIST_CONSUME_STATE = "/v1/clusters/%s/consumer-groups/%s/offset";
    static final String CONSUMER_GROUP_RESET_CONSUME_OFFSET = "/v1/clusters/%s/consumer-groups/%s/offset";
    static final String ACL_USER_CREATE = "/v1/clusters/%s/users/%s";
    static final String ACL_USER_GET = "/v1/clusters/%s/users/%s";
    static final String ACL_USER_UPDATE = "/v1/clusters/%s/users/%s";
    static final String ACL_USER_DELETE = "/v1/clusters/%s/users/%s";
    static final String ACL_LIST_TOPIC_USER = "/v1/clusters/%s/topics/%s/users";
    static final String ACL_LIST_CONSUMER_GROUP_USER = "/v1/clusters/%s/consumer-groups/%s/users";
    static final String MESSAGE_QUERY = "/v1/clusters/%s/messages/%s";
    static final String MESSAGE_QUERY_LIST = "/v1/clusters/%s/topics/%s/messages";
    static final String MESSAGE_SEND = "/v1/clusters/%s/messages";
    static final String ACTION_LIST_OPERATIONS = "/v1/clusters/%s/actions/%s/operations";
    static final String CLUSTER_NAME = "clusterName";
    static final String PAGE_NO = "pageNo";
    static final String PAGE_SIZE = "pageSize";
    static final String MARKER = "marker";
    static final String MAX_KEYS = "maxKeys";
    static final String STATE = "state";
    static final String MODE = "mode";
    static final String NAME = "name";
    static final String ROCKETMQ_VERSION = "rocketmqVersion";
    static final String PAYMENT = "payment";
    static final String TAG_KEY = "tagKey";
    static final String TAG_VALUE = "tagValue";
    static final String BEGIN_TIME = "beginTime";
    static final String END_TIME = "endTime";
    static final String START_OFFSET = "startOffset";
    static final String ACTION = "action";
    static final String ACTION_START = "startCluster";
    static final String ACTION_STOP = "stopCluster";
    static final String ACTION_INCREASE_STORAGE_SIZE = "increaseStorageSize";
    static final String ACTION_EXPAND_BROKER = "expandBroker";
    static final String ACTION_MODIFY_BROKER_NODE_TYPE = "modifyBrokerNodeType";
    static final String ACTION_RESTART_BROKER_NODE = "restartBrokerNode";
    static final String TOPIC_NAME = "topicName";
    static final String BROKER_NAMES = "brokerNames";
    static final String MESSAGE_ID = "messageId";
    static final String MESSAGE_KEY = "messageKey";
    static final String REQUEST_NULL_ERROR = "request should not be null.";
    static final String CLUSTER_NAME_EMPTY_OR_NULL_ERROR = "clusterName should not be null or empty.";
    static final String CLUSTER_ID_EMPTY_OR_NULL_ERROR = "clusterId should not be null or empty.";
    static final String TOPIC_NAME_EMPTY_OR_NULL_ERROR = "topicName should not be null or empty.";
    static final String CONSUMER_GROUP_NAME_EMPTY_OR_NULL_ERROR = "consumerGroupName should not be null or empty.";
    static final String USER_NAME_EMPTY_OR_NULL_ERROR = "username should not be null or empty.";
    static final String MESSAGE_ID_EMPTY_OR_NULL_ERROR = "messageId should not be null or empty.";
    static final String ACTION_ID_EMPTY_OR_NULL_ERROR = "actionId should not be null or empty.";
    static final String TAG_KEY_EMPTY_OR_NULL_ERROR = "tagKey should not be null or empty.";
    static final String TAG_VALUE_EMPTY_OR_NULL_ERROR = "tagValue should not be null or empty.";
    static final String MESSAGE_BODY_EMPTY_OR_NULL_ERROR = "message body should not be null or empty.";
    static final String MESSAGE_BEGIN_TIMESTAMP_INVALID_ERROR = "message begin timestamp should not be null or invalid.";
    static final String MESSAGE_END_TIMESTAMP_INVALID_ERROR = "message end timestamp should not be null or invalid.";

    RocketMQConstants() {
    }
}

