/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.api.Client;
import com.clickhouse.client.api.ClientConfigProperties;
import com.clickhouse.data.ClickHouseDataType;
import com.clickhouse.jdbc.Driver;
import com.clickhouse.jdbc.DriverProperties;
import com.google.common.collect.ImmutableMap;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class JdbcConfiguration {
    private static final String PREFIX_CLICKHOUSE = "jdbc:clickhouse:";
    private static final String PREFIX_CLICKHOUSE_SHORT = "jdbc:ch:";
    static final String USE_SSL_PROP = "ssl";
    private static final String PARSE_URL_CONN_URL_PROP = "connection_url";
    private static final Pattern PATTERN_HTTP_TOKEN = Pattern.compile("[A-Za-z0-9!#$%&'*+\\.\\^_`\\|~-]+");
    private final boolean disableFrameworkDetection;
    final Map<String, String> clientProperties;
    private final Map<String, String> driverProperties;
    private final String connectionUrl;
    private boolean isIgnoreUnsupportedRequests;
    private List<DriverPropertyInfo> listOfProperties;

    public Map<String, String> getClientProperties() {
        return ImmutableMap.copyOf(this.clientProperties);
    }

    public boolean isDisableFrameworkDetection() {
        return this.disableFrameworkDetection;
    }

    public boolean isIgnoreUnsupportedRequests() {
        return this.isIgnoreUnsupportedRequests;
    }

    public JdbcConfiguration(String url, Properties info) throws SQLException {
        this.disableFrameworkDetection = info != null && Boolean.parseBoolean(info.getProperty("disable_frameworks_detection", "false"));
        this.clientProperties = new HashMap<String, String>();
        this.driverProperties = new HashMap<String, String>();
        Map<String, String> urlProperties = this.parseUrl(url);
        String tmpConnectionUrl = urlProperties.remove(PARSE_URL_CONN_URL_PROP);
        this.initProperties(urlProperties, info);
        boolean useSSLInfo = Boolean.parseBoolean(info.getProperty(DriverProperties.SECURE_CONNECTION.getKey(), "false"));
        boolean useSSLUrlProperties = Boolean.parseBoolean(urlProperties.getOrDefault(DriverProperties.SECURE_CONNECTION.getKey(), "false"));
        boolean useSSL = useSSLInfo || useSSLUrlProperties;
        String bearerToken = info.getProperty(ClientConfigProperties.BEARERTOKEN_AUTH.getKey(), null);
        if (bearerToken != null) {
            this.clientProperties.put(ClientConfigProperties.BEARERTOKEN_AUTH.getKey(), bearerToken);
        }
        this.connectionUrl = JdbcConfiguration.createConnectionURL(tmpConnectionUrl, useSSL);
        this.isIgnoreUnsupportedRequests = Boolean.parseBoolean(this.getDriverProperty(DriverProperties.IGNORE_UNSUPPORTED_VALUES.getKey(), "false"));
    }

    public static boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("URL is null");
        }
        if (!url.startsWith(PREFIX_CLICKHOUSE) && !url.startsWith(PREFIX_CLICKHOUSE_SHORT)) {
            return false;
        }
        try {
            URI uri = new URI(url);
            return "jdbc".equals(uri.getScheme());
        }
        catch (URISyntaxException urise) {
            throw new SQLException("Not a valid URL '" + url + "'. ", urise);
        }
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    private static String createConnectionURL(String url, boolean ssl) throws SQLException {
        String adjustedURL = ssl && url.startsWith("http://") ? "https://" + url.substring(7) : url;
        try {
            URI tmp = URI.create(adjustedURL);
            String asciiString = tmp.toASCIIString();
            if (tmp.getPort() < 0) {
                String port = ssl || adjustedURL.startsWith("https") ? ":8443" : ":8123";
                asciiString = asciiString + port;
            }
            return asciiString;
        }
        catch (IllegalArgumentException iae) {
            throw new SQLException("Failed to parse URL '" + url + "'", iae);
        }
    }

    private static String stripJDBCPrefix(String url) {
        if (url.startsWith(PREFIX_CLICKHOUSE)) {
            return url.substring(PREFIX_CLICKHOUSE.length());
        }
        if (url.startsWith(PREFIX_CLICKHOUSE_SHORT)) {
            return url.substring(PREFIX_CLICKHOUSE_SHORT.length());
        }
        throw new IllegalArgumentException("Specified JDBC URL doesn't have any of prefixes: [ jdbc:clickhouse:, jdbc:ch: ]");
    }

    private Map<String, String> parseUrl(String url) throws SQLException {
        HashMap<String, String> properties = new HashMap<String, String>();
        String myURL = null;
        try {
            myURL = JdbcConfiguration.stripJDBCPrefix(url);
        }
        catch (Exception e) {
            throw new SQLException("Error determining JDBC prefix from URL '" + url + "'", e);
        }
        if (myURL.startsWith("//")) {
            myURL = "http://" + myURL.substring(2);
        }
        URI uri = null;
        try {
            uri = new URI(myURL);
        }
        catch (URISyntaxException urise) {
            throw new SQLException("Invalid JDBC URL '" + url + "'", urise);
        }
        if (uri.getAuthority() == null) {
            throw new SQLException("Invalid authority part JDBC URL '" + url + "'");
        }
        if (uri.getAuthority().contains(",")) {
            throw new SQLException("Multiple endpoints not supported");
        }
        properties.put(PARSE_URL_CONN_URL_PROP, uri.getScheme() + "://" + uri.getRawAuthority());
        if (uri.getPath() != null && !uri.getPath().trim().isEmpty() && !"/".equals(uri.getPath())) {
            properties.put(ClientConfigProperties.DATABASE.getKey(), uri.getPath().substring(1));
        }
        if (uri.getQuery() != null && !uri.getQuery().trim().isEmpty()) {
            for (String pair : uri.getRawQuery().split("&")) {
                try {
                    String[] p = pair.split("=", 2);
                    if (p.length != 2 || p[0] == null || p[1] == null) {
                        throw new SQLException("Invalid query parameter '" + pair + "'");
                    }
                    String key = URLDecoder.decode(p[0], StandardCharsets.UTF_8.name());
                    if (key == null || key.trim().isEmpty() || !PATTERN_HTTP_TOKEN.matcher(key).matches()) {
                        throw new SQLException("Invalid query parameter key in pair'" + pair + "'");
                    }
                    String value = URLDecoder.decode(p[1], StandardCharsets.UTF_8.name());
                    if (value == null || value.trim().isEmpty() || "=".equals(value)) {
                        throw new SQLException("Invalid query parameter value in pair '" + pair + "'");
                    }
                    properties.put(key.trim(), value);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SQLException("Internal error'", e);
                }
            }
        }
        return properties;
    }

    private void initProperties(Map<String, String> urlProperties, Properties providedProperties) {
        DriverPropertyInfo propertyInfo;
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : providedProperties.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) {
                props.put((String)entry.getKey(), (String)entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Property key and value should be a string");
        }
        props.putAll(urlProperties);
        HashMap<String, DriverPropertyInfo> propertyInfos = new HashMap<String, DriverPropertyInfo>();
        for (Map.Entry prop : props.entrySet()) {
            DriverPropertyInfo propertyInfo2 = new DriverPropertyInfo((String)prop.getKey(), (String)prop.getValue());
            propertyInfo2.description = "(User Defined)";
            propertyInfos.put((String)prop.getKey(), propertyInfo2);
            this.clientProperties.put((String)prop.getKey(), (String)prop.getValue());
        }
        for (ClientConfigProperties clientConfigProperties : ClientConfigProperties.values()) {
            propertyInfo = (DriverPropertyInfo)propertyInfos.get(clientConfigProperties.getKey());
            if (propertyInfo != null) continue;
            propertyInfo = new DriverPropertyInfo(clientConfigProperties.getKey(), clientConfigProperties.getDefaultValue());
            propertyInfos.put(clientConfigProperties.getKey(), propertyInfo);
        }
        for (DriverProperties driverProperties : DriverProperties.values()) {
            String value;
            propertyInfo = (DriverPropertyInfo)propertyInfos.get(driverProperties.getKey());
            if (propertyInfo == null) {
                propertyInfo = new DriverPropertyInfo(driverProperties.getKey(), driverProperties.getDefaultValue());
                propertyInfos.put(driverProperties.getKey(), propertyInfo);
            }
            if ((value = this.clientProperties.get(driverProperties.getKey())) == null) continue;
            this.driverProperties.put(driverProperties.getKey(), value);
        }
        this.listOfProperties = propertyInfos.values().stream().sorted(Comparator.comparing(o -> o.name)).collect(Collectors.toList());
    }

    public List<DriverPropertyInfo> getDriverPropertyInfo() {
        return this.listOfProperties;
    }

    public String getDriverProperty(String key, String defaultValue) {
        return this.driverProperties.getOrDefault(key, defaultValue);
    }

    public Boolean isSet(DriverProperties driverProp) {
        String v = this.driverProperties.getOrDefault(driverProp.getKey(), driverProp.getDefaultValue());
        return Boolean.parseBoolean(v);
    }

    public Client.Builder applyClientProperties(Client.Builder builder) {
        builder.addEndpoint(this.connectionUrl).setOptions(this.clientProperties).typeHintMapping(this.defaultTypeHintMapping());
        return builder;
    }

    public void updateUserClient(String clientName, Client client) {
        client.updateClientName((clientName == null || clientName.isEmpty() ? "" : clientName) + ' ' + JdbcConfiguration.getDefaultClientName());
    }

    public static String getDefaultClientName() {
        StringBuilder jdbcName = new StringBuilder();
        jdbcName.append("jdbc-v2/").append(Driver.driverVersion);
        return jdbcName.toString();
    }

    public boolean isBetaFeatureEnabled(DriverProperties prop) {
        String value = this.driverProperties.getOrDefault(prop.getKey(), prop.getDefaultValue());
        return Boolean.parseBoolean(value);
    }

    private Map<ClickHouseDataType, Class<?>> defaultTypeHintMapping() {
        HashMap mapping = new HashMap();
        mapping.put(ClickHouseDataType.Array, List.class);
        return mapping;
    }
}

