/*
 * Decompiled with CFR 0.152.
 */
package com.cmb.xft.open.api;

import com.cmb.xft.open.api.HttpResponseData;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpReqUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final boolean ignoreSSLCheck = true;
    private static final boolean ignoreHostCheck = true;

    protected static HttpResponseData doPost(String url, Map<String, Object> params, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        String ctype = "application/json; charset=" + charset;
        byte[] content = new byte[]{};
        if (null != params) {
            Gson gson = new Gson();
            content = gson.toJson(params).getBytes(charset);
        }
        return HttpReqUtils.execByType(url, ctype, content, connectTimeout, readTimeout, headerMap, proxy, "POST", "STRING");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HttpResponseData doFileUpload(String url, Map<String, String> queryParams, String fileName, byte[] bytes, Map<String, String> headerMap, String responseType) throws IOException {
        String NEWLINE = "\r\n";
        String PREFIX = "--";
        String BOUNDARY = "---------" + System.nanoTime();
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        HttpResponseData data = new HttpResponseData();
        try {
            String ctype = "multipart/form-data; charset=UTF-8; boundary=" + BOUNDARY;
            conn = HttpReqUtils.getConnection(new URL(url), "POST", ctype, headerMap, null);
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(30000);
            out = conn.getOutputStream();
            byte[] entryBoundaryBytes = ("--" + BOUNDARY + "\r\n").getBytes(StandardCharsets.UTF_8);
            if (null != queryParams) {
                Set<Map.Entry<String, String>> textEntrySet = queryParams.entrySet();
                for (Map.Entry<String, String> textEntry : textEntrySet) {
                    byte[] textBytes = HttpReqUtils.convertFileData(textEntry.getKey(), textEntry.getValue(), DEFAULT_CHARSET);
                    out.write(entryBoundaryBytes);
                    out.write(textBytes);
                }
            }
            if (null != fileName && null != bytes) {
                out.write(entryBoundaryBytes);
                out.write(("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"" + "\r\n").getBytes(StandardCharsets.UTF_8));
                out.write("\r\n".getBytes(StandardCharsets.UTF_8));
                out.write(bytes);
                out.write("\r\n".getBytes(StandardCharsets.UTF_8));
            }
            byte[] endBoundaryBytes = ("--" + BOUNDARY + "--" + "\r\n").getBytes(StandardCharsets.UTF_8);
            out.write(endBoundaryBytes);
            out.flush();
            rsp = "STRING".equals(responseType) ? HttpReqUtils.getResponseAsString(conn) : HttpReqUtils.getResponseBytes(conn);
            data.setBody(rsp);
            data.setHeaders(conn.getHeaderFields());
            data.setHttpStatusCode(conn.getResponseCode());
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return data;
    }

    private static byte[] convertFileData(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition: form-data; name=\"");
        entry.append(fieldName);
        entry.append("\"\r\n\r\n");
        entry.append(fieldValue);
        entry.append("\r\n");
        return entry.toString().getBytes(charset);
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap, Proxy proxy) throws IOException {
        HttpURLConnection conn;
        HttpURLConnection httpURLConnection = conn = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection connHttps = (HttpsURLConnection)conn;
            try {
                SSLContext ctx = SSLContext.getInstance("TLSv1.2");
                ctx.init(null, new TrustManager[]{new TrustAllTrustManager()}, new SecureRandom());
                connHttps.setSSLSocketFactory(ctx.getSocketFactory());
                connHttps.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return hostname.equalsIgnoreCase(session.getPeerHost());
                    }
                });
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
            conn = connHttps;
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "application/json,text/xml,text/javascript");
        conn.setRequestProperty("XFT-API-Call-Type", "sdk-java");
        conn.setRequestProperty("XFT-API-SDK-Version", "2.0.3-RELEASE");
        conn.setRequestProperty("XFT-API-Scene", "cust");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            conn.setRequestProperty("Host", headerMap.get("TOP_HTTP_DNS_HOST") != null ? headerMap.get("TOP_HTTP_DNS_HOST") : url.getHost());
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                if ("TOP_HTTP_DNS_HOST".equals(entry.getKey())) continue;
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    protected static HttpResponseData doPut(String url, Map<String, Object> params, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        String ctype = "application/json; charset=" + charset;
        byte[] content = new byte[]{};
        if (null != params) {
            Gson gson = new Gson();
            content = gson.toJson(params).getBytes(charset);
        }
        return HttpReqUtils.execByType(url, ctype, content, connectTimeout, readTimeout, headerMap, proxy, "PUT", "STRING");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HttpResponseData doGet(String url, Map<String, String> paramsMap, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        HttpResponseData data = new HttpResponseData();
        try {
            String ctype = "application/json; charset=" + charset;
            String query = HttpReqUtils.buildQuery(paramsMap, charset);
            conn = HttpReqUtils.getConnection(HttpReqUtils.buildGetUrl(url, query), "GET", ctype, headerMap, proxy);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            rsp = HttpReqUtils.getResponseAsString(conn);
            data.setBody(rsp);
            data.setHttpStatusCode(conn.getResponseCode());
            Map<String, List<String>> headerFields = conn.getHeaderFields();
            HashMap<String, List<String>> nonNullHeaderMap = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                String k = entry.getKey();
                List<String> v = entry.getValue();
                if (k == null || k.isEmpty()) continue;
                nonNullHeaderMap.put(k, v);
            }
            data.setHeaders(nonNullHeaderMap);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return data;
    }

    private static URL buildGetUrl(String url, String query) throws IOException {
        if (query == null || "".equals(query)) {
            return new URL(url);
        }
        return new URL(HttpReqUtils.buildRequestUrl(url, query));
    }

    private static String buildRequestUrl(String url, String ... queries) {
        if (queries == null || queries.length == 0) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        boolean hasPrepend = url.endsWith("?") || url.endsWith("&");
        for (String query : queries) {
            if (query == null || "".equals(query)) continue;
            if (!hasPrepend) {
                if (hasQuery) {
                    newUrl.append("&");
                } else {
                    newUrl.append("?");
                    hasQuery = true;
                }
            }
            newUrl.append(query);
            hasPrepend = false;
        }
        return newUrl.toString();
    }

    private static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (name == null || "".equals(name) || value == null) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponseData execByType(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy, String reqType, String responseType) throws IOException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        HttpResponseData data = new HttpResponseData();
        try {
            conn = HttpReqUtils.getConnection(new URL(url), reqType, ctype, headerMap, proxy);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            if (null != content) {
                out = conn.getOutputStream();
                out.write(content);
            }
            rsp = "STRING".equals(responseType) ? HttpReqUtils.getResponseAsString(conn) : HttpReqUtils.getResponseBytes(conn);
            data.setBody(rsp);
            data.setHttpStatusCode(conn.getResponseCode());
            Map<String, List<String>> headerFields = conn.getHeaderFields();
            HashMap<String, List<String>> nonNullHeaderMap = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                String k = entry.getKey();
                List<String> v = entry.getValue();
                if (k == null || k.isEmpty()) continue;
                nonNullHeaderMap.put(k, v);
            }
            data.setHeaders(nonNullHeaderMap);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return data;
    }

    private static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = HttpReqUtils.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                return HttpReqUtils.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return HttpReqUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        InputStream error = conn.getErrorStream();
        if (conn.getResponseCode() == 400 && error != null) {
            return HttpReqUtils.getStreamAsString(error, charset);
        }
        return HttpReqUtils.getStreamAsString(conn.getErrorStream(), charset);
    }

    public static HttpResponseData doFileDownload(String url, Map<String, Object> params, Map<String, String> headerMap, String responseType, String reqType) throws IOException {
        String ctype = "application/json; charset=UTF-8";
        byte[] content = new byte[]{};
        if (null != params) {
            Gson gson = new Gson();
            content = gson.toJson(params).getBytes(StandardCharsets.UTF_8);
        }
        if ("GET".equals(reqType)) {
            return HttpReqUtils.execByType(url, ctype, null, 15000, 30000, headerMap, null, "GET", responseType);
        }
        return HttpReqUtils.execByType(url, ctype, content, 15000, 30000, headerMap, null, "POST", responseType);
    }

    protected static String getResponseBytes(HttpURLConnection conn) throws IOException {
        String charset = HttpReqUtils.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                return HttpReqUtils.getStreamBytes(new GZIPInputStream(conn.getInputStream()));
            }
            return HttpReqUtils.getStreamBytes(conn.getInputStream());
        }
        InputStream error = conn.getErrorStream();
        if (conn.getResponseCode() == 400 && error != null) {
            return HttpReqUtils.getStreamAsString(error, charset);
        }
        throw new IOException(conn.getResponseCode() + " " + HttpReqUtils.getStreamAsString(error, charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamBytes(InputStream stream) throws IOException {
        try {
            int read;
            StringBuilder response = new StringBuilder();
            byte[] buff = new byte[1024];
            while ((read = stream.read(buff)) > 0) {
                byte[] tem = new byte[read];
                System.arraycopy(buff, 0, tem, 0, read);
                response.append(new String(tem, "ISO-8859-1"));
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (ctype != null && !"".equals(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || pair[1] == null || "".equals(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    /*
     * Loose catch block
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            try (InputStreamReader reader = new InputStreamReader(stream, charset);){
                StringBuilder response = new StringBuilder();
                char[] buff = new char[1024];
                int read = 0;
                while ((read = reader.read(buff)) > 0) {
                    response.append(buff, 0, read);
                }
                String string = response.toString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static class TrustAllTrustManager
    implements X509TrustManager {
        private TrustAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

