/*
 * Decompiled with CFR 0.152.
 */
package com.cmb.xft.open.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.util.encoders.Hex;

public class Sm2SignatureUtils {
    protected static String sm3withsm2Signature(String privateKeyStr, String dataStr) throws CryptoException, IOException {
        byte[] key = Hex.decode((String)privateKeyStr);
        byte[] data = dataStr.getBytes("UTF-8");
        ECNamedCurveParameterSpec spec = ECNamedCurveTable.getParameterSpec((String)"sm2p256v1");
        ECDomainParameters domainParameters = new ECDomainParameters(spec.getCurve(), spec.getG(), spec.getN(), spec.getH(), spec.getSeed());
        ECPrivateKeyParameters privateKey = new ECPrivateKeyParameters(new BigInteger(1, key), domainParameters);
        ParametersWithID parameters = new ParametersWithID((CipherParameters)privateKey, "1234567812345678".getBytes());
        SM2Signer signer = new SM2Signer();
        signer.init(true, (CipherParameters)parameters);
        signer.update(data, 0, data.length);
        return Hex.toHexString((byte[])Sm2SignatureUtils.decodeDERSignature(signer.generateSignature()));
    }

    private static byte[] decodeDERSignature(byte[] signature) throws IOException {
        ASN1InputStream stream = new ASN1InputStream((InputStream)new ByteArrayInputStream(signature));
        ASN1Sequence primitive = (ASN1Sequence)stream.readObject();
        Enumeration enumeration = primitive.getObjects();
        BigInteger R = ((ASN1Integer)enumeration.nextElement()).getValue();
        BigInteger S = ((ASN1Integer)enumeration.nextElement()).getValue();
        byte[] bytes = new byte[64];
        byte[] r = Sm2SignatureUtils.format(R.toByteArray());
        byte[] s = Sm2SignatureUtils.format(S.toByteArray());
        System.arraycopy(r, 0, bytes, 0, 32);
        System.arraycopy(s, 0, bytes, 32, 32);
        return bytes;
    }

    private static byte[] format(byte[] value) {
        if (value.length == 32) {
            return value;
        }
        byte[] bytes = new byte[32];
        if (value.length > 32) {
            System.arraycopy(value, value.length - 32, bytes, 0, 32);
        } else {
            System.arraycopy(value, 0, bytes, 32 - value.length, value.length);
        }
        return bytes;
    }
}

