/*
 * Decompiled with CFR 0.152.
 */
package com.cmb.xft.open.api;

import com.cmb.xft.open.api.BaseReqInf;
import com.cmb.xft.open.api.Constants;
import com.cmb.xft.open.api.HttpReqUtils;
import com.cmb.xft.open.api.HttpResponseData;
import com.cmb.xft.open.api.SM3Utils;
import com.cmb.xft.open.api.SignInf;
import com.cmb.xft.open.api.Sm2SignatureUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class XftOpenApiReqClient {
    private static final Log log = LogFactory.getLog(XftOpenApiReqClient.class);
    private static final String PARAM_FIELD_CSCAPPUID = "CSCAPPUID=";
    private static final String PARAM_FIELD_CSCPRJCOD = "&CSCPRJCOD=";
    private static final String PARAM_FIELD_CSCUSRUID = "&CSCUSRUID=";
    private static final String PARAM_FIELD_CSCREQTIM = "&CSCREQTIM=";
    private static final String PARAM_FIELD_CSCUSRNBR = "&CSCUSRNBR=";
    public static final String PARAM_FILED_EDSPRJCOD = "&EDSPRJCOD=";
    private static final List<String> BLACK_HOST_LIST = Arrays.asList("http://xft-open-gateway-cs.paas.cmbchina.cn", "https://xft-open-gateway-cs.paas.cmbchina.cn", "http://xft2-open-gateway-cs.paas.cmbchina.cn", "https://xft2-open-gateway-cs.paas.cmbchina.cn", "http://xft-open-gateway-cs.paasst.cmbchina.cn", "https://xft-open-gateway-cs.paasst.cmbchina.cn", "http://xft2-open-gateway-cs.paasst.cmbchina.cn", "https://xft2-open-gateway-cs.paasst.cmbchina.cn", "http://xft2-open-gateway-cs.paasuat.cmbchina.cn", "https://xft2-open-gateway-cs.paasuat.cmbchina.cn", "http://xft4-open-gateway-cs.paasuat.cmbchina.cn", "https://xft4-open-gateway-cs.paasuat.cmbchina.cn", "http://xft-open-gateway-cs.paasuat.cmbchina.cn", "https://xft-open-gateway-cs.paasuat.cmbchina.cn", "http://xft-open-gateway-alb.cmbchina.cn", "http://xft-open-gw-dmz-alb.cmbchina.cn", "http://xft-open-gw-biz-alb.cmbchina.cn");

    public static HttpResponseData doCommonPostReq(BaseReqInf reqInf, String url, Map<String, Object> queryParam, String requestBody) throws Exception {
        if (XftOpenApiReqClient.whrBlackHost(url)) {
            throw Constants.BLACK_HOST;
        }
        SignInf signInf = XftOpenApiReqClient.getSignInf(reqInf, url, queryParam);
        String digest = SM3Utils.sm3Signature2(requestBody);
        String signStr = "POST " + signInf.getPath() + "\nx-alb-digest: " + requestBody + "\nx-alb-timestamp: " + signInf.getTimestamp();
        log.info((Object)("signStr:" + signStr));
        String apisign = Sm2SignatureUtils.sm3withsm2Signature(reqInf.getAuthoritySecret(), signStr);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json; charset=utf-8");
        headerMap.put("appid", reqInf.getAppId());
        headerMap.put("x-alb-timestamp", signInf.getTimestamp());
        headerMap.put("x-alb-digest", digest);
        headerMap.put("apisign", apisign);
        headerMap.put("x-alb-verify", "sm3withsm2");
        String ctype = "application/json; charset=UTF-8";
        return HttpReqUtils.execByType(signInf.getUrl(), ctype, requestBody.getBytes(StandardCharsets.UTF_8), 120000, 120000, headerMap, null, "POST", "STRING");
    }

    public static HttpResponseData doCommonGetReq(BaseReqInf reqInf, String url, Map<String, Object> queryParam) throws Exception {
        if (XftOpenApiReqClient.whrBlackHost(url)) {
            throw Constants.BLACK_HOST;
        }
        SignInf signInf = XftOpenApiReqClient.getSignInf(reqInf, url, queryParam);
        String signStr = "GET " + signInf.getPath() + "\nx-alb-timestamp: " + signInf.getTimestamp();
        log.info((Object)("signStr:" + signStr));
        String apisign = Sm2SignatureUtils.sm3withsm2Signature(reqInf.getAuthoritySecret(), signStr);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json; charset=utf-8");
        headerMap.put("appid", reqInf.getAppId());
        headerMap.put("x-alb-timestamp", signInf.getTimestamp());
        headerMap.put("apisign", apisign);
        headerMap.put("x-alb-verify", "sm3withsm2");
        return HttpReqUtils.doGet(signInf.getUrl(), null, "UTF-8", 120000, 120000, headerMap, null);
    }

    public static HttpResponseData doFileUploadByFileReq(BaseReqInf reqInf, String url, Map<String, Object> queryParam, MultipartFile file) throws Exception {
        if (XftOpenApiReqClient.whrBlackHost(url)) {
            throw Constants.BLACK_HOST;
        }
        byte[] bytes = file.getBytes();
        if (bytes.length > 0x1400000) {
            throw new RuntimeException("\u6587\u4ef6\u5185\u5bb9\u8fc7\u5927");
        }
        SignInf signInf = XftOpenApiReqClient.getSignInf(reqInf, url, queryParam);
        String signStr = "POST " + signInf.getPath() + "\nx-alb-timestamp: " + signInf.getTimestamp();
        log.info((Object)("signStr:" + signStr));
        String apisign = Sm2SignatureUtils.sm3withsm2Signature(reqInf.getAuthoritySecret(), signStr);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("appid", reqInf.getAppId());
        headerMap.put("x-alb-timestamp", signInf.getTimestamp());
        headerMap.put("apisign", apisign);
        headerMap.put("x-alb-verify", "sm3withsm2");
        return HttpReqUtils.doFileUpload(signInf.getUrl(), null, file.getName(), bytes, headerMap, "STRING");
    }

    public static HttpResponseData doFileUploadByFileWithOriginalName(BaseReqInf reqInf, String url, Map<String, Object> queryParam, MultipartFile file) throws Exception {
        if (XftOpenApiReqClient.whrBlackHost(url)) {
            throw Constants.BLACK_HOST;
        }
        byte[] bytes = file.getBytes();
        if (bytes.length > 0x1400000) {
            throw new RuntimeException("\u6587\u4ef6\u5185\u5bb9\u8fc7\u5927");
        }
        SignInf signInf = XftOpenApiReqClient.getSignInf(reqInf, url, queryParam);
        String signStr = "POST " + signInf.getPath() + "\nx-alb-timestamp: " + signInf.getTimestamp();
        log.info((Object)("signStr:" + signStr));
        String apisign = Sm2SignatureUtils.sm3withsm2Signature(reqInf.getAuthoritySecret(), signStr);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("appid", reqInf.getAppId());
        headerMap.put("x-alb-timestamp", signInf.getTimestamp());
        headerMap.put("apisign", apisign);
        headerMap.put("x-alb-verify", "sm3withsm2");
        return HttpReqUtils.doFileUpload(signInf.getUrl(), null, file.getOriginalFilename(), bytes, headerMap, "STRING");
    }

    private static SignInf getSignInf(BaseReqInf reqInf, String url, Map<String, Object> queryParam) {
        long currentTimeMillis = System.currentTimeMillis();
        String timestamp = String.valueOf(currentTimeMillis / 1000L);
        StringBuilder paramStringBuild = new StringBuilder();
        paramStringBuild.append(PARAM_FIELD_CSCAPPUID).append(reqInf.getAppId());
        if (!StringUtils.isEmpty((Object)reqInf.getCompanyId())) {
            paramStringBuild.append(PARAM_FIELD_CSCPRJCOD).append(reqInf.getCompanyId());
        }
        if (!StringUtils.isEmpty((Object)reqInf.getUsrNbr())) {
            paramStringBuild.append(PARAM_FIELD_CSCUSRNBR).append(reqInf.getUsrNbr());
        }
        if (!StringUtils.isEmpty((Object)reqInf.getUsrUid())) {
            paramStringBuild.append(PARAM_FIELD_CSCUSRUID).append(reqInf.getUsrUid());
        }
        if (!StringUtils.isEmpty((Object)reqInf.getEdsCompanyId())) {
            paramStringBuild.append(PARAM_FILED_EDSPRJCOD).append(reqInf.getCompanyId());
        }
        paramStringBuild.append(PARAM_FIELD_CSCREQTIM).append(currentTimeMillis);
        if (null != queryParam) {
            for (Map.Entry<String, Object> entry : queryParam.entrySet()) {
                paramStringBuild.append("&").append(entry.getKey()).append("=").append(entry.getValue());
            }
        }
        url = url + "?" + paramStringBuild;
        String subUrl = url.replaceAll("http://", "").replaceAll("https://", "");
        int pathIndex = subUrl.indexOf("/");
        String path = subUrl.substring(pathIndex);
        return new SignInf(timestamp, url, path);
    }

    public static HttpResponseData doGetFileDownloadReq(BaseReqInf reqInf, String url, Map<String, Object> queryParam) throws Exception {
        if (XftOpenApiReqClient.whrBlackHost(url)) {
            throw Constants.BLACK_HOST;
        }
        SignInf signInf = XftOpenApiReqClient.getSignInf(reqInf, url, queryParam);
        String signStr = "GET " + signInf.getPath() + "\nx-alb-timestamp: " + signInf.getTimestamp();
        log.info((Object)("signStr:" + signStr));
        String apisign = Sm2SignatureUtils.sm3withsm2Signature(reqInf.getAuthoritySecret(), signStr);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json; charset=utf-8");
        headerMap.put("appid", reqInf.getAppId());
        headerMap.put("x-alb-timestamp", signInf.getTimestamp());
        headerMap.put("apisign", apisign);
        headerMap.put("x-alb-verify", "sm3withsm2");
        return HttpReqUtils.doFileDownload(signInf.getUrl(), null, headerMap, "BYTE", "GET");
    }

    public static HttpResponseData doPostFileDownloadReq(BaseReqInf reqInf, String url, Map<String, Object> queryParam, String requestBody) throws Exception {
        if (XftOpenApiReqClient.whrBlackHost(url)) {
            throw Constants.BLACK_HOST;
        }
        SignInf signInf = XftOpenApiReqClient.getSignInf(reqInf, url, queryParam);
        String digest = SM3Utils.sm3Signature2(requestBody);
        String signStr = "POST " + signInf.getPath() + "\nx-alb-digest: " + requestBody + "\nx-alb-timestamp: " + signInf.getTimestamp();
        log.info((Object)("signStr:" + signStr));
        String apisign = Sm2SignatureUtils.sm3withsm2Signature(reqInf.getAuthoritySecret(), signStr);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json; charset=utf-8");
        headerMap.put("appid", reqInf.getAppId());
        headerMap.put("x-alb-timestamp", signInf.getTimestamp());
        headerMap.put("x-alb-digest", digest);
        headerMap.put("apisign", apisign);
        headerMap.put("x-alb-verify", "sm3withsm2");
        String ctype = "application/json; charset=UTF-8";
        return HttpReqUtils.execByType(signInf.getUrl(), ctype, requestBody.getBytes(StandardCharsets.UTF_8), 120000, 120000, headerMap, null, "POST", "BYTE");
    }

    public static boolean whrBlackHost(String restUrl) {
        return BLACK_HOST_LIST.stream().anyMatch(restUrl::startsWith);
    }
}

