/*
 * Decompiled with CFR 0.152.
 */
package com.cmb.xft.open.api;

import com.cmb.xft.open.api.BaseReqInf;
import com.cmb.xft.open.api.Constants;
import com.cmb.xft.open.api.HttpResponseData;
import com.cmb.xft.open.api.LoginInfo;
import com.cmb.xft.open.api.LoginUserInfo;
import com.cmb.xft.open.api.PrjInfo;
import com.cmb.xft.open.api.Sm4Util;
import com.cmb.xft.open.api.StringUtils;
import com.cmb.xft.open.api.XftOpenApiReqClient;
import com.cmb.xft.open.api.XftSignException;
import com.cmb.xft.open.utils.Base64;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.CollectionUtils;

public class XftVerifySignClient {
    private static final Log log = LogFactory.getLog(XftVerifySignClient.class);
    private BaseReqInf baseReqInf;
    private Integer validMinute = 5;
    private String url;

    public void setValidMinute(Integer validMinute) {
        this.validMinute = validMinute;
    }

    public XftVerifySignClient(BaseReqInf baseReqInf, String url) {
        this.url = url;
        this.baseReqInf = baseReqInf;
    }

    public LoginInfo verifySign(String data, String sign) throws Exception {
        Map<String, String> dataMap;
        String dateStr = null;
        try {
            dateStr = new String(Base64.decode(URLDecoder.decode(data, "UTF-8")));
            dataMap = this.getDataParamMap(dateStr);
        }
        catch (Exception e) {
            log.warn((Object)"data\u975eurl.encode\u683c\u5f0f");
            dateStr = new String(Base64.decode(data));
            dataMap = this.getDataParamMap(dateStr);
        }
        if (dateStr == null) {
            throw Constants.ERROR_DATA_ERROR;
        }
        if (!this.isInValidTime(dataMap.get("REQTIM"))) {
            log.error((Object)"\u65f6\u95f4\u8d85\u65f6");
            throw Constants.ERROR_SIGN_EXPIRED;
        }
        this.getVerifyResult(dateStr, sign);
        String jsonBody = "{\"SYCOMOPAY\":[{\"SESTKN\":\"" + dataMap.get("TKNNBR") + "\",\"OPAUID\":\"" + this.baseReqInf.getAppId() + "\"}]}";
        String key = this.baseReqInf.getAuthoritySecret().substring(0, 32);
        String secretMsg = Sm4Util.encryptEcb(key, jsonBody);
        HashMap<String, String> newRequestBodyMap = new HashMap<String, String>(8);
        newRequestBodyMap.put("secretMsg", secretMsg);
        Gson gson = new Gson();
        jsonBody = gson.toJson(newRequestBodyMap);
        HttpResponseData responseData = XftOpenApiReqClient.doCommonPostReq(this.baseReqInf, this.url, null, jsonBody);
        String responseBody = responseData.getBody();
        responseBody = Sm4Util.decryptEcb(key, responseBody);
        return this.getLoginInfo(responseBody);
    }

    private LoginInfo getLoginInfo(String body) throws XftSignException {
        List list;
        log.info((Object)("\u8fd4\u56de\u503c:" + body));
        Gson gson = new Gson();
        LoginInfo loginInfo = new LoginInfo();
        Map map = (Map)gson.fromJson(body, Map.class);
        String errCode = "0000000";
        String errMsg = "0000000";
        if (map != null && map.containsKey("SYCOMRETZ") && map.get("SYCOMRETZ") instanceof List && !(list = (List)map.get("SYCOMRETZ")).isEmpty()) {
            errCode = ((Map)list.get(0)).get("ERRCOD").toString();
            errMsg = ((Map)list.get(0)).get("ERRMSG").toString();
        }
        if (!"0000000".equals(errCode)) {
            throw new XftSignException(errCode, errMsg);
        }
        LoginUserInfo loginUserInfo = (LoginUserInfo)gson.fromJson(gson.toJson(((List)map.get("OPUSINFOY")).get(0)), LoginUserInfo.class);
        if (map.get("OPUSRINFY") != null && !CollectionUtils.isEmpty((Collection)((List)map.get("OPUSRINFY")))) {
            Map result = (Map)((List)map.get("OPUSRINFY")).get(0);
            loginUserInfo.setCopUid(StringUtils.valueOf(result.get("COPUID")));
            loginUserInfo.setCopUnm(StringUtils.valueOf(result.get("COPUNM")));
        }
        if (map.get("OPPRJINFY") != null && !CollectionUtils.isEmpty((Collection)((List)map.get("OPPRJINFY")))) {
            List prjInfoList = (List)gson.fromJson(gson.toJson(map.get("OPPRJINFY")), new TypeToken<List<PrjInfo>>(){}.getType());
            if (loginUserInfo.getUsrUid() == null) {
                loginUserInfo.setUsrUid(((PrjInfo)prjInfoList.get(0)).getUsrUid());
            }
            loginInfo.setPrjInfoList(prjInfoList);
        }
        loginInfo.setLoginUserInfo(loginUserInfo);
        return loginInfo;
    }

    private Map<String, String> getDataParamMap(String dateStr) {
        String[] params = dateStr.split("\\|");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (String param : params) {
            int index = param.indexOf(61);
            if (index <= 0) continue;
            dataMap.put(param.substring(0, index), param.substring(index + 1));
        }
        return dataMap;
    }

    private boolean isInValidTime(String reqTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.add(12, -this.validMinute.intValue());
        return Long.parseLong(reqTime) >= calendar.getTimeInMillis();
    }

    private void getVerifyResult(String dataStr, String sign) throws XftSignException {
        String signal;
        try {
            String signStr = dataStr + "&" + this.baseReqInf.getAuthoritySecret();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(signStr.getBytes("UTF-8"));
            byte[] buffer = digest.digest();
            signal = Base64.encodeToString(buffer, false);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            log.error((Object)"sha256\u7b7e\u540d\u751f\u6210\u5931\u8d25", (Throwable)e);
            throw Constants.ERROR_SIGN_ERROR;
        }
        if (!sign.equals(signal)) {
            try {
                if (!URLDecoder.decode(sign, "UTF-8").equals(signal)) {
                    throw Constants.ERROR_SIGN_ERROR;
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"sign\u7684\u683c\u5f0f\u4e0d\u6b63\u786e");
                throw Constants.ERROR_SIGN_ERROR;
            }
        }
    }
}

