/*
 * Decompiled with CFR 0.152.
 */
package com.cmb.xft.open.api;

import com.cmb.xft.open.api.BaseReqInf;
import com.cmb.xft.open.api.Constants;
import com.cmb.xft.open.api.HttpResponseData;
import com.cmb.xft.open.api.Sm4Util;
import com.cmb.xft.open.api.XftFrameworkResponse;
import com.cmb.xft.open.api.XftOpenApiReqClient;
import com.cmb.xft.open.api.XftSignException;
import com.cmb.xft.open.login.token.LoginInfo;
import com.cmb.xft.open.login.token.LoginTokenInfo;
import com.cmb.xft.open.utils.Base64;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XftVerifyTokenClient {
    private static final Log log = LogFactory.getLog(XftVerifyTokenClient.class);
    private final BaseReqInf baseReqInf;
    private final String accessTokenUrl;
    private String loginUserUrl;

    public XftVerifyTokenClient(BaseReqInf baseReqInf, String accessTokenUrl) {
        this.accessTokenUrl = accessTokenUrl;
        this.baseReqInf = baseReqInf;
    }

    public XftVerifyTokenClient(BaseReqInf baseReqInf, String accessTokenUrl, String loginUserUrl) {
        this.accessTokenUrl = accessTokenUrl;
        this.loginUserUrl = loginUserUrl;
        this.baseReqInf = baseReqInf;
    }

    public LoginInfo getLoginInfo(String data, String sign) throws Exception {
        LoginTokenInfo loginTokenInfo = this.verifyToken(data, sign);
        if (null == loginTokenInfo) {
            return null;
        }
        String format = "{\"token\":\"%s\"}";
        String body = String.format(format, loginTokenInfo.getToken());
        this.baseReqInf.setCompanyId(loginTokenInfo.getEnterpriseId());
        this.baseReqInf.setUsrNbr(loginTokenInfo.getEnterpriseUserId());
        this.baseReqInf.setUsrUid(loginTokenInfo.getAccountId());
        String key = this.baseReqInf.getAuthoritySecret().substring(0, 32);
        String secretMsg = Sm4Util.encryptEcb(key, body);
        HashMap<String, String> newRequestBodyMap = new HashMap<String, String>(8);
        newRequestBodyMap.put("secretMsg", secretMsg);
        Gson gson = new Gson();
        body = gson.toJson(newRequestBodyMap);
        HttpResponseData responseData = XftOpenApiReqClient.doCommonPostReq(this.baseReqInf, this.loginUserUrl, null, body);
        if (!responseData.isSuccess()) {
            throw Constants.ERROR_LOGIN_USER;
        }
        String responseBody = responseData.getBody();
        XftFrameworkResponse xftFrameworkResponse = (XftFrameworkResponse)gson.fromJson(responseBody = Sm4Util.decryptEcb(key, responseBody), XftFrameworkResponse.class);
        if (!xftFrameworkResponse.isSuccess()) {
            throw new XftSignException(xftFrameworkResponse.getReturnCode(), xftFrameworkResponse.getErrorMsg());
        }
        return (LoginInfo)gson.fromJson(gson.toJson(xftFrameworkResponse.getBody()), LoginInfo.class);
    }

    public LoginTokenInfo verifyToken(String data, String sign) throws Exception {
        String dateStr = this.getDataStr(data);
        Map<String, String> dataMap = this.getDataParamMap(dateStr);
        this.verifyDataAndSign(dateStr, sign);
        String token = dataMap.get("TKNNBR");
        if (null == token) {
            throw Constants.ERROR_DATA_TOKEN_NOT_EXIST;
        }
        String format = "{\"token\":\"%s\",\"appId\":\"%s\"}";
        String body = String.format(format, token, this.baseReqInf.getAppId());
        if (this.baseReqInf.getWhrService()) {
            String companyId = dataMap.getOrDefault("enterpriseId", "TEMP0000");
            this.baseReqInf.setCompanyId(companyId);
        }
        String key = this.baseReqInf.getAuthoritySecret().substring(0, 32);
        String secretMsg = Sm4Util.encryptEcb(key, body);
        HashMap<String, String> newRequestBodyMap = new HashMap<String, String>(8);
        newRequestBodyMap.put("secretMsg", secretMsg);
        Gson gson = new Gson();
        body = gson.toJson(newRequestBodyMap);
        HttpResponseData responseData = XftOpenApiReqClient.doCommonPostReq(this.baseReqInf, this.accessTokenUrl, null, body);
        if (!responseData.isSuccess()) {
            throw Constants.ERROR_CHANGE_TOKEN;
        }
        String responseBody = responseData.getBody();
        XftFrameworkResponse xftFrameworkResponse = (XftFrameworkResponse)gson.fromJson(responseBody = Sm4Util.decryptEcb(key, responseBody), XftFrameworkResponse.class);
        if (!xftFrameworkResponse.isSuccess()) {
            throw new XftSignException(xftFrameworkResponse.getReturnCode(), xftFrameworkResponse.getErrorMsg());
        }
        return (LoginTokenInfo)gson.fromJson(gson.toJson(xftFrameworkResponse.getBody()), LoginTokenInfo.class);
    }

    private String getDataStr(String data) {
        String dateStr = null;
        try {
            byte[] decode = Base64.decode(URLDecoder.decode(data, "UTF-8"));
            if (null == decode) {
                decode = Base64.decode(data);
            }
            if (null == decode) {
                throw Constants.ERROR_DATA_ERROR;
            }
            dateStr = new String(decode);
        }
        catch (Exception e) {
            log.warn((Object)"data\u89e3\u6790\u5931\u8d25");
            return null;
        }
        return dateStr;
    }

    private Map<String, String> getDataParamMap(String dateStr) {
        if (null == dateStr) {
            return new HashMap<String, String>();
        }
        String[] params = dateStr.split("\\|");
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (String param : params) {
            int index = param.indexOf(61);
            if (index <= 0) continue;
            dataMap.put(param.substring(0, index), param.substring(index + 1));
        }
        return dataMap;
    }

    private void verifyDataAndSign(String dataStr, String sign) throws XftSignException {
        String signal;
        try {
            String signStr = dataStr + "&" + this.baseReqInf.getAuthoritySecret();
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(signStr.getBytes(StandardCharsets.UTF_8));
            byte[] buffer = digest.digest();
            signal = Base64.encodeToString(buffer, false);
        }
        catch (NoSuchAlgorithmException e) {
            throw Constants.ERROR_SIGN_ERROR;
        }
        if (!sign.equals(signal)) {
            try {
                if (!URLDecoder.decode(sign, "UTF-8").equals(signal)) {
                    throw Constants.ERROR_SIGN_ERROR;
                }
            }
            catch (UnsupportedEncodingException e) {
                throw Constants.ERROR_SIGN_ERROR;
            }
        }
    }
}

