/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.codec;

import com.digitalpetri.modbus.FunctionCode;
import com.digitalpetri.modbus.ModbusPdu;
import com.digitalpetri.modbus.UnsupportedPdu;
import com.digitalpetri.modbus.codec.ModbusPduDecoder;
import com.digitalpetri.modbus.requests.MaskWriteRegisterRequest;
import com.digitalpetri.modbus.requests.ReadCoilsRequest;
import com.digitalpetri.modbus.requests.ReadDiscreteInputsRequest;
import com.digitalpetri.modbus.requests.ReadHoldingRegistersRequest;
import com.digitalpetri.modbus.requests.ReadInputRegistersRequest;
import com.digitalpetri.modbus.requests.ReadWriteMultipleRegistersRequest;
import com.digitalpetri.modbus.requests.WriteMultipleCoilsRequest;
import com.digitalpetri.modbus.requests.WriteMultipleRegistersRequest;
import com.digitalpetri.modbus.requests.WriteSingleCoilRequest;
import com.digitalpetri.modbus.requests.WriteSingleRegisterRequest;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;

public class ModbusRequestDecoder
implements ModbusPduDecoder {
    @Override
    public ModbusPdu decode(ByteBuf buffer) throws DecoderException {
        byte code = buffer.readByte();
        FunctionCode functionCode = (FunctionCode)FunctionCode.fromCode((int)code).orElseThrow(() -> new DecoderException("invalid function code: " + code));
        return this.decodeResponse(functionCode, buffer);
    }

    private ModbusPdu decodeResponse(FunctionCode functionCode, ByteBuf buffer) throws DecoderException {
        switch (functionCode) {
            case ReadCoils: {
                return this.decodeReadCoils(buffer);
            }
            case ReadDiscreteInputs: {
                return this.decodeReadDiscreteInputs(buffer);
            }
            case ReadHoldingRegisters: {
                return this.decodeReadHoldingRegisters(buffer);
            }
            case ReadInputRegisters: {
                return this.decodeReadInputRegisters(buffer);
            }
            case WriteSingleCoil: {
                return this.decodeWriteSingleCoil(buffer);
            }
            case WriteSingleRegister: {
                return this.decodeWriteSingleRegister(buffer);
            }
            case WriteMultipleCoils: {
                return this.decodeWriteMultipleCoils(buffer);
            }
            case WriteMultipleRegisters: {
                return this.decodeWriteMultipleRegisters(buffer);
            }
            case MaskWriteRegister: {
                return this.decodeMaskWriteRegister(buffer);
            }
            case ReadWriteMultipleRegisters: {
                return this.decodeReadWriteMultipleRegisters(buffer);
            }
        }
        return new UnsupportedPdu(functionCode);
    }

    private ReadCoilsRequest decodeReadCoils(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int quantity = buffer.readUnsignedShort();
        return new ReadCoilsRequest(address, quantity);
    }

    private ReadDiscreteInputsRequest decodeReadDiscreteInputs(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int quantity = buffer.readUnsignedShort();
        return new ReadDiscreteInputsRequest(address, quantity);
    }

    private ReadHoldingRegistersRequest decodeReadHoldingRegisters(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int quantity = buffer.readUnsignedShort();
        return new ReadHoldingRegistersRequest(address, quantity);
    }

    private ReadInputRegistersRequest decodeReadInputRegisters(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int quantity = buffer.readUnsignedShort();
        return new ReadInputRegistersRequest(address, quantity);
    }

    private WriteSingleCoilRequest decodeWriteSingleCoil(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        boolean value = buffer.readUnsignedShort() == 65280;
        return new WriteSingleCoilRequest(address, value);
    }

    private WriteSingleRegisterRequest decodeWriteSingleRegister(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int value = buffer.readUnsignedShort();
        return new WriteSingleRegisterRequest(address, value);
    }

    private WriteMultipleCoilsRequest decodeWriteMultipleCoils(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int quantity = buffer.readUnsignedShort();
        short byteCount = buffer.readUnsignedByte();
        ByteBuf values = buffer.readSlice((int)byteCount).retain();
        return new WriteMultipleCoilsRequest(address, quantity, values);
    }

    private WriteMultipleRegistersRequest decodeWriteMultipleRegisters(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int quantity = buffer.readUnsignedShort();
        short byteCount = buffer.readUnsignedByte();
        ByteBuf values = buffer.readSlice((int)byteCount).retain();
        return new WriteMultipleRegistersRequest(address, quantity, values);
    }

    private MaskWriteRegisterRequest decodeMaskWriteRegister(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int andMask = buffer.readUnsignedShort();
        int orMask = buffer.readUnsignedShort();
        return new MaskWriteRegisterRequest(address, andMask, orMask);
    }

    private ReadWriteMultipleRegistersRequest decodeReadWriteMultipleRegisters(ByteBuf buffer) {
        int readAddress = buffer.readUnsignedShort();
        int readQuantity = buffer.readUnsignedShort();
        int writeAddress = buffer.readUnsignedShort();
        int writeQuantity = buffer.readUnsignedShort();
        short byteCount = buffer.readUnsignedByte();
        ByteBuf values = buffer.readSlice((int)byteCount).retain();
        return new ReadWriteMultipleRegistersRequest(readAddress, readQuantity, writeAddress, writeQuantity, values);
    }
}

