/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.codec;

import com.digitalpetri.modbus.ExceptionCode;
import com.digitalpetri.modbus.FunctionCode;
import com.digitalpetri.modbus.ModbusPdu;
import com.digitalpetri.modbus.UnsupportedPdu;
import com.digitalpetri.modbus.codec.ModbusPduDecoder;
import com.digitalpetri.modbus.responses.ExceptionResponse;
import com.digitalpetri.modbus.responses.MaskWriteRegisterResponse;
import com.digitalpetri.modbus.responses.ReadCoilsResponse;
import com.digitalpetri.modbus.responses.ReadDiscreteInputsResponse;
import com.digitalpetri.modbus.responses.ReadHoldingRegistersResponse;
import com.digitalpetri.modbus.responses.ReadInputRegistersResponse;
import com.digitalpetri.modbus.responses.ReadWriteMultipleRegistersResponse;
import com.digitalpetri.modbus.responses.WriteMultipleCoilsResponse;
import com.digitalpetri.modbus.responses.WriteMultipleRegistersResponse;
import com.digitalpetri.modbus.responses.WriteSingleCoilResponse;
import com.digitalpetri.modbus.responses.WriteSingleRegisterResponse;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;

public class ModbusResponseDecoder
implements ModbusPduDecoder {
    @Override
    public ModbusPdu decode(ByteBuf buffer) throws DecoderException {
        short code = buffer.readUnsignedByte();
        if (FunctionCode.isExceptionCode((int)code)) {
            FunctionCode functionCode = (FunctionCode)FunctionCode.fromCode((int)(code - 128)).orElseThrow(() -> new DecoderException("invalid function code: " + (code - 128)));
            return this.decodeException(functionCode, buffer);
        }
        FunctionCode functionCode = (FunctionCode)FunctionCode.fromCode((int)code).orElseThrow(() -> new DecoderException("invalid function code: " + code));
        return this.decodeResponse(functionCode, buffer);
    }

    private ModbusPdu decodeException(FunctionCode functionCode, ByteBuf buffer) throws DecoderException {
        short code = buffer.readUnsignedByte();
        ExceptionCode exceptionCode = (ExceptionCode)ExceptionCode.fromCode((int)code).orElseThrow(() -> new DecoderException("invalid exception code: " + code));
        return new ExceptionResponse(functionCode, exceptionCode);
    }

    private ModbusPdu decodeResponse(FunctionCode functionCode, ByteBuf buffer) throws DecoderException {
        switch (functionCode) {
            case ReadCoils: {
                return this.decodeReadCoils(buffer);
            }
            case ReadDiscreteInputs: {
                return this.decodeReadDiscreteInputs(buffer);
            }
            case ReadHoldingRegisters: {
                return this.decodeReadHoldingRegisters(buffer);
            }
            case ReadInputRegisters: {
                return this.decodeReadInputRegisters(buffer);
            }
            case WriteSingleCoil: {
                return this.decodeWriteSingleCoil(buffer);
            }
            case WriteSingleRegister: {
                return this.decodeWriteSingleRegister(buffer);
            }
            case WriteMultipleCoils: {
                return this.decodeWriteMultipleCoils(buffer);
            }
            case WriteMultipleRegisters: {
                return this.decodeWriteMultipleRegisters(buffer);
            }
            case MaskWriteRegister: {
                return this.decodeMaskWriteRegister(buffer);
            }
            case ReadWriteMultipleRegisters: {
                return this.decodeReadWriteMultipleRegisters(buffer);
            }
        }
        return new UnsupportedPdu(functionCode);
    }

    public ReadCoilsResponse decodeReadCoils(ByteBuf buffer) {
        short byteCount = buffer.readUnsignedByte();
        ByteBuf coilStatus = buffer.readSlice((int)byteCount).retain();
        return new ReadCoilsResponse(coilStatus);
    }

    public ReadDiscreteInputsResponse decodeReadDiscreteInputs(ByteBuf buffer) {
        short byteCount = buffer.readUnsignedByte();
        ByteBuf inputStatus = buffer.readSlice((int)byteCount).retain();
        return new ReadDiscreteInputsResponse(inputStatus);
    }

    public ReadHoldingRegistersResponse decodeReadHoldingRegisters(ByteBuf buffer) {
        short byteCount = buffer.readUnsignedByte();
        ByteBuf registers = buffer.readSlice((int)byteCount).retain();
        return new ReadHoldingRegistersResponse(registers);
    }

    public ReadInputRegistersResponse decodeReadInputRegisters(ByteBuf buffer) {
        short byteCount = buffer.readUnsignedByte();
        ByteBuf registers = buffer.readSlice((int)byteCount).retain();
        return new ReadInputRegistersResponse(registers);
    }

    public WriteSingleCoilResponse decodeWriteSingleCoil(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int value = buffer.readUnsignedShort();
        return new WriteSingleCoilResponse(address, value);
    }

    public WriteSingleRegisterResponse decodeWriteSingleRegister(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int value = buffer.readUnsignedShort();
        return new WriteSingleRegisterResponse(address, value);
    }

    public WriteMultipleCoilsResponse decodeWriteMultipleCoils(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int quantity = buffer.readUnsignedShort();
        return new WriteMultipleCoilsResponse(address, quantity);
    }

    public WriteMultipleRegistersResponse decodeWriteMultipleRegisters(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int quantity = buffer.readUnsignedShort();
        return new WriteMultipleRegistersResponse(address, quantity);
    }

    public MaskWriteRegisterResponse decodeMaskWriteRegister(ByteBuf buffer) {
        int address = buffer.readUnsignedShort();
        int andMask = buffer.readUnsignedShort();
        int orMask = buffer.readUnsignedShort();
        return new MaskWriteRegisterResponse(address, andMask, orMask);
    }

    public ReadWriteMultipleRegistersResponse decodeReadWriteMultipleRegisters(ByteBuf buffer) {
        short byteCount = buffer.readUnsignedByte();
        ByteBuf registers = buffer.readSlice((int)byteCount).retain();
        return new ReadWriteMultipleRegistersResponse(registers);
    }
}

