/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.master;

import com.digitalpetri.modbus.codec.Modbus;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;

public class ModbusTcpMasterConfig {
    private final String address;
    private final int port;
    private final Duration timeout;
    private final boolean lazy;
    private final boolean persistent;
    private final int maxReconnectDelay;
    private final String instanceId;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduler;
    private final EventLoopGroup eventLoop;
    private final HashedWheelTimer wheelTimer;
    private final Consumer<Bootstrap> bootstrapConsumer;

    public ModbusTcpMasterConfig(String address, int port, Duration timeout, boolean lazy, boolean persistent, int maxReconnectDelay, String instanceId, ExecutorService executor, ScheduledExecutorService scheduler, EventLoopGroup eventLoop, HashedWheelTimer wheelTimer, Consumer<Bootstrap> bootstrapConsumer) {
        this.address = address;
        this.port = port;
        this.timeout = timeout;
        this.lazy = lazy;
        this.persistent = persistent;
        this.maxReconnectDelay = maxReconnectDelay;
        this.instanceId = instanceId;
        this.executor = executor;
        this.scheduler = scheduler;
        this.eventLoop = eventLoop;
        this.wheelTimer = wheelTimer;
        this.bootstrapConsumer = bootstrapConsumer;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public boolean isLazy() {
        return this.lazy;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public int getMaxReconnectDelaySeconds() {
        return this.maxReconnectDelay;
    }

    public Optional<String> getInstanceId() {
        return Optional.ofNullable(this.instanceId);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public EventLoopGroup getEventLoop() {
        return this.eventLoop;
    }

    public HashedWheelTimer getWheelTimer() {
        return this.wheelTimer;
    }

    public Consumer<Bootstrap> getBootstrapConsumer() {
        return this.bootstrapConsumer;
    }

    public static class Builder {
        private final String address;
        private int port = 502;
        private Duration timeout = Duration.ofSeconds(5L);
        private boolean lazy = true;
        private boolean persistent = true;
        private int maxReconnectDelaySeconds = 16;
        private String instanceId = null;
        private ExecutorService executor;
        private ScheduledExecutorService scheduler;
        private EventLoopGroup eventLoop;
        private HashedWheelTimer wheelTimer;
        private Consumer<Bootstrap> bootstrapConsumer = b -> {};

        public Builder(String address) {
            this.address = address;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder setLazy(boolean lazy) {
            this.lazy = lazy;
            return this;
        }

        public Builder setPersistent(boolean persistent) {
            this.persistent = persistent;
            return this;
        }

        public Builder setMaxReconnectDelaySeconds(int maxReconnectDelaySeconds) {
            this.maxReconnectDelaySeconds = maxReconnectDelaySeconds;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder setExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder setScheduler(ScheduledExecutorService scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        public Builder setEventLoop(EventLoopGroup eventLoop) {
            this.eventLoop = eventLoop;
            return this;
        }

        public Builder setWheelTimer(HashedWheelTimer wheelTimer) {
            this.wheelTimer = wheelTimer;
            return this;
        }

        public Builder setBootstrapConsumer(Consumer<Bootstrap> consumer) {
            this.bootstrapConsumer = consumer;
            return this;
        }

        public ModbusTcpMasterConfig build() {
            return new ModbusTcpMasterConfig(this.address, this.port, this.timeout, this.lazy, this.persistent, this.maxReconnectDelaySeconds, this.instanceId, this.executor != null ? this.executor : Modbus.sharedExecutor(), this.scheduler != null ? this.scheduler : Modbus.sharedScheduledExecutor(), (EventLoopGroup)(this.eventLoop != null ? this.eventLoop : Modbus.sharedEventLoop()), this.wheelTimer != null ? this.wheelTimer : Modbus.sharedWheelTimer(), this.bootstrapConsumer);
        }
    }
}

