/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.asf;

import com.gbasedbt.asf.CSMspwd;
import com.gbasedbt.asf.IfxASFException;
import com.gbasedbt.asf.IfxDataInputStream;
import com.gbasedbt.util.IfxErrMsg;
import java.io.BufferedInputStream;
import java.io.IOException;

public class CSMBufferedInputStream
extends BufferedInputStream {
    static final int STREAM_BUF_SIZE = 4098;
    static final int BLOCK_SIZE = 8;
    static final int SPWD_CSM_MSG_TYPE_DATA = 3;
    private CSMspwd CSMspwd = null;
    private IfxDataInputStream IfxIs = null;
    private byte[] messageArray;
    private byte[] decryptedDataBuf;
    private int decryptedDataBufSize;
    private int decryptedDataBufPos;
    private int decryptedDataBufLen;
    private String ClientLocale = null;

    public CSMBufferedInputStream(IfxDataInputStream ifxDataInputStream, CSMspwd cSMspwd) {
        super(ifxDataInputStream);
        this.CSMspwd = cSMspwd;
        this.IfxIs = ifxDataInputStream;
        this.decryptedDataBuf = new byte[4098];
        this.decryptedDataBufSize = 4098;
        this.decryptedDataBufPos = 0;
        this.decryptedDataBufLen = 0;
    }

    public CSMBufferedInputStream(IfxDataInputStream ifxDataInputStream, int n2, CSMspwd cSMspwd) {
        super(ifxDataInputStream, n2);
        this.CSMspwd = cSMspwd;
        this.IfxIs = ifxDataInputStream;
        this.decryptedDataBuf = new byte[4098];
        this.decryptedDataBufSize = 4098;
        this.decryptedDataBufPos = 0;
        this.decryptedDataBufLen = 0;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n2 = this.read(byArray, 0, 1);
        if (n2 != -1) {
            return byArray[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.decryptedDataBufLen < n3) {
            this.fillDecryptedDataBuf(n3);
        }
        return this.copyOutData(byArray, n2, n3);
    }

    @Override
    public long skip(long l2) throws IOException {
        if (this.decryptedDataBufLen < (int)l2) {
            this.fillDecryptedDataBuf((int)l2);
        }
        int n2 = this.decryptedDataBufLen < (int)l2 ? this.decryptedDataBufLen : (int)l2;
        this.decryptedDataBufPos += n2;
        if (this.decryptedDataBufPos >= this.decryptedDataBufSize) {
            this.decryptedDataBufPos = 0;
        }
        this.decryptedDataBufLen -= n2;
        return n2;
    }

    @Override
    public int available() throws IOException {
        int n2 = this.IfxIs.available();
        if (n2 > 0) {
            this.fillDecryptedDataBuf(n2);
        }
        return this.decryptedDataBufLen;
    }

    private void fillDecryptedDataBuf(int n2) throws IOException {
        short s2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (this.decryptedDataBufLen < n2 && (s2 = this.IfxIs.readShort()) != -1) {
            if (s2 == 3) {
                this.readInDataToken();
                continue;
            }
            throw new IOException("JCSM protocol error.");
        }
    }

    private void readInDataToken() throws IOException {
        try {
            short s2 = this.IfxIs.readShort();
            short s3 = this.IfxIs.readShort();
            int n2 = s2 - 2;
            this.messageArray = new byte[n2];
            int n3 = this.IfxIs.readFully(this.messageArray, 0, n2);
            if (n3 < n2) {
                throw new IOException("JCSM protocol error.");
            }
            byte[] byArray = new byte[n2];
            this.CSMspwd.processInMessage(this.messageArray, byArray);
            this.copyInData(byArray, s3);
        }
        catch (IfxASFException ifxASFException) {
            throw IfxErrMsg.getLocIOException(-5030, this.ClientLocale);
        }
    }

    private void copyInData(byte[] byArray, int n2) {
        int n3 = this.decryptedDataBufLen + n2;
        if (n3 > this.decryptedDataBufSize) {
            byte[] byArray2 = new byte[n3];
            this.decryptedDataBufSize = n3;
            System.arraycopy(this.decryptedDataBuf, this.decryptedDataBufPos, byArray2, 0, this.decryptedDataBufLen);
            System.arraycopy(byArray, 0, byArray2, this.decryptedDataBufLen, n2);
            this.decryptedDataBuf = byArray2;
            this.decryptedDataBufPos = 0;
            this.decryptedDataBufLen = n3;
        } else if (this.decryptedDataBufPos + n3 >= this.decryptedDataBufSize) {
            System.arraycopy(this.decryptedDataBuf, this.decryptedDataBufPos, this.decryptedDataBuf, 0, this.decryptedDataBufLen);
            System.arraycopy(byArray, 0, this.decryptedDataBuf, this.decryptedDataBufLen, n2);
            this.decryptedDataBufPos = 0;
            this.decryptedDataBufLen = n3;
        } else {
            System.arraycopy(byArray, 0, this.decryptedDataBuf, this.decryptedDataBufPos + this.decryptedDataBufLen, n2);
            this.decryptedDataBufLen = n3;
        }
    }

    private int copyOutData(byte[] byArray, int n2, int n3) {
        if (this.decryptedDataBufLen == 0) {
            return -1;
        }
        int n4 = n3 > this.decryptedDataBufLen ? this.decryptedDataBufLen : n3;
        System.arraycopy(this.decryptedDataBuf, this.decryptedDataBufPos, byArray, n2, n4);
        this.decryptedDataBufPos += n4;
        if (this.decryptedDataBufPos >= this.decryptedDataBufSize) {
            this.decryptedDataBufPos = 0;
        }
        this.decryptedDataBufLen -= n4;
        return n4;
    }

    public void setClientLocale(String string) {
        this.ClientLocale = string;
    }

    public String getClientLocale() {
        return this.ClientLocale;
    }
}

