/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sqlj.framework.checker.SQLChecker;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.JSError;
import sqlj.framework.error.Warning;
import sqlj.framework.ide.TranslationOptionsQuery;
import sqlj.framework.options.ConnectionFactory;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.PropertyList;
import sqlj.framework.options.PropertyListImpl;
import sqlj.mesg.SemanticErrors;
import sqlj.semantics.SemanticAnalyzerFactory;

public class ConnectionManager {
    private ConnectionFactory m_connFact = new ConnectionFactory();
    private SemanticAnalyzerFactory m_saf = null;
    private TranslationOptionsQuery m_query_password = null;
    private static Integer failed = new Integer(0);
    private Hashtable m_connections = new Hashtable();
    private Hashtable m_sql_checkers = new Hashtable();
    private Hashtable m_checkers_loaded = new Hashtable();
    private Hashtable m_user_url = new Hashtable();

    ConnectionManager(SemanticAnalyzerFactory semanticAnalyzerFactory) {
        this.m_saf = semanticAnalyzerFactory;
    }

    public SQLChecker getSQLChecker(String string, ErrorLog errorLog) {
        Object v2;
        if (string == null) {
            string = "";
        }
        if ((v2 = this.m_sql_checkers.get(string)) == null) {
            return this.doGetSQLChecker(string, errorLog);
        }
        if (v2 == failed) {
            return null;
        }
        return (SQLChecker)v2;
    }

    public Connection getConnection(String string, ErrorLog errorLog) {
        Object v2;
        if (string == null) {
            string = "";
        }
        if ((v2 = this.m_connections.get(string)) == null) {
            return this.doGetConnection(string, errorLog);
        }
        if (v2 == failed) {
            return null;
        }
        return (Connection)v2;
    }

    public void registerOptionsQuery(TranslationOptionsQuery translationOptionsQuery) {
        if (translationOptionsQuery != null) {
            this.m_connFact.setOptionsQuery(translationOptionsQuery);
        }
    }

    private SQLChecker doGetSQLChecker(String string, ErrorLog errorLog) {
        if (this.onlineChecking(string)) {
            return this.doGetOnlineSQLChecker(string, errorLog);
        }
        return this.doGetOfflineSQLChecker(string, errorLog);
    }

    private SQLChecker doGetOfflineSQLChecker(String string, ErrorLog errorLog) {
        String string2 = this.m_saf.getOffline(string);
        if (string2 == null) {
            string2 = this.m_saf.getOffline();
        }
        if (string2 == null) {
            errorLog.addEntry(new JSError(string.equals("") ? SemanticErrors.noOfflineCheckerSpecified() : SemanticErrors.noOfflineCheckerForContext(string)));
            this.m_sql_checkers.put(string, failed);
            return null;
        }
        Object v2 = this.m_checkers_loaded.get(string2);
        if (v2 == failed) {
            return null;
        }
        if (v2 != null) {
            return (SQLChecker)v2;
        }
        boolean bl = true;
        Class<?> clazz = null;
        Object var7_7 = null;
        SQLChecker sQLChecker = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            bl = false;
            errorLog.addEntry(new JSError(SemanticErrors.unableToLoadOfflineChecker(string2)));
        }
        if (bl) {
            try {
                var7_7 = clazz.newInstance();
            }
            catch (Exception exception) {
                bl = false;
                errorLog.addEntry(new JSError(SemanticErrors.unableToInstantiateOfflineChecker(string2)));
            }
        }
        if (bl) {
            try {
                sQLChecker = var7_7;
            }
            catch (Exception exception) {
                bl = false;
                errorLog.addEntry(new JSError(SemanticErrors.doesNotImplementChecker(string2)));
            }
        }
        if (bl) {
            try {
                sQLChecker.setOptions(this.getCheckerPropertyList(), errorLog);
            }
            catch (InvalidOptionException invalidOptionException) {
                bl = false;
            }
        }
        if (bl) {
            this.m_checkers_loaded.put(string2, sQLChecker);
            return sQLChecker;
        }
        this.m_sql_checkers.put(string, failed);
        this.m_checkers_loaded.put(string2, failed);
        return null;
    }

    private SQLChecker doGetOnlineSQLChecker(String string, ErrorLog errorLog) {
        SQLChecker sQLChecker;
        Object object;
        Object object2;
        String string2;
        Enumeration enumeration = this.m_saf.getOnline(string);
        if (enumeration == null || !enumeration.hasMoreElements()) {
            enumeration = this.m_saf.getOnline();
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            errorLog.addEntry(new Warning(string.equals("") ? SemanticErrors.noOnlineCheckerSpecified() : SemanticErrors.noOnlineCheckerForContext(string)));
            return this.doGetOfflineSQLChecker(string, errorLog);
        }
        Vector<Object> vector = new Vector<Object>();
        while (enumeration.hasMoreElements() && (string2 = (String)this.m_checkers_loaded.get(object2 = (String)enumeration.nextElement())) != failed) {
            if (string2 != null) {
                vector.addElement(string2);
                continue;
            }
            boolean bl = true;
            object = null;
            sQLChecker = null;
            SQLChecker sQLChecker2 = null;
            try {
                object = Class.forName((String)object2);
            }
            catch (Exception exception) {
                bl = false;
                errorLog.addEntry(new Warning(SemanticErrors.unableToLoadOnlineChecker((String)object2)));
            }
            if (bl) {
                try {
                    sQLChecker = ((Class)object).newInstance();
                }
                catch (Exception exception) {
                    bl = false;
                    errorLog.addEntry(new Warning(SemanticErrors.unableToInstantiateOnlineChecker((String)object2)));
                }
            }
            if (bl) {
                try {
                    sQLChecker2 = sQLChecker;
                }
                catch (Exception exception) {
                    bl = false;
                    errorLog.addEntry(new Warning(SemanticErrors.doesNotImplementChecker((String)object2)));
                }
            }
            if (bl) {
                try {
                    sQLChecker2.setOptions(this.getCheckerPropertyList(), errorLog);
                }
                catch (InvalidOptionException invalidOptionException) {
                    bl = false;
                }
            }
            if (bl) {
                this.m_checkers_loaded.put(object2, sQLChecker2);
                vector.addElement(sQLChecker2);
                continue;
            }
            return this.doGetOfflineSQLChecker(string, errorLog);
        }
        enumeration = vector.elements();
        object2 = null;
        string2 = null;
        String string3 = null;
        if (enumeration.hasMoreElements()) {
            object2 = this.getConnection(string, errorLog);
            if (object2 == null) {
                return this.doGetOfflineSQLChecker(string, errorLog);
            }
            try {
                object = object2.getMetaData();
                string2 = object.getDatabaseProductName();
                string3 = object.getDatabaseProductVersion();
            }
            catch (SQLException sQLException) {
                errorLog.addEntry(new Warning(SemanticErrors.unableToObtainDBMetaData(string)));
                this.m_connections.put(string, failed);
                return this.doGetOfflineSQLChecker(string, errorLog);
            }
        }
        object = null;
        while (object == null && enumeration.hasMoreElements()) {
            sQLChecker = (SQLChecker)enumeration.nextElement();
            if (!sQLChecker.supportsDatabase(errorLog, (Connection)object2, string2, string3)) continue;
            object = sQLChecker;
        }
        if (object == null) {
            errorLog.addEntry(new Warning(string.equals("") ? SemanticErrors.noOnlineCheckerSpecified() : SemanticErrors.noOnlineCheckerForContext(string)));
            return this.doGetOfflineSQLChecker(string, errorLog);
        }
        this.m_sql_checkers.put(string, object);
        return object;
    }

    private boolean onlineChecking(String string) {
        String string2 = this.m_saf.getUser(string);
        if (string2 == null) {
            string2 = this.m_saf.getUser();
        }
        return string2 != null && !string2.equals("");
    }

    private PropertyList getCheckerPropertyList() {
        PropertyListImpl propertyListImpl = new PropertyListImpl();
        int n2 = 3;
        if (this.m_saf.getVerbose()) {
            ++n2;
        }
        if (this.m_saf.getNulls()) {
            ++n2;
        }
        if (this.m_saf.getPrecision()) {
            ++n2;
        }
        if (this.m_saf.getPortable()) {
            ++n2;
        }
        if (this.m_saf.getStrict()) {
            ++n2;
        }
        String[] stringArray = new String[n2];
        stringArray[0] = "default-procedure-mode=" + String.valueOf(this.m_saf.getDefaultProcedureMode());
        stringArray[1] = "default-function-mode=" + String.valueOf(this.m_saf.getDefaultFunctionMode());
        stringArray[2] = "default-block-mode=" + String.valueOf(this.m_saf.getDefaultBlockMode());
        int n3 = 3;
        if (this.m_saf.getVerbose()) {
            stringArray[n3] = "verbose";
            ++n3;
        }
        if (this.m_saf.getNulls()) {
            stringArray[n3] = "null";
            ++n3;
        }
        if (this.m_saf.getPrecision()) {
            stringArray[n3] = "precision";
            ++n3;
        }
        if (this.m_saf.getPortable()) {
            stringArray[n3] = "portable";
            ++n3;
        }
        if (this.m_saf.getStrict()) {
            stringArray[n3] = "strict";
            ++n3;
        }
        propertyListImpl.addProperty(stringArray, "Internal");
        return propertyListImpl;
    }

    private Connection doGetConnection(String string, ErrorLog errorLog) {
        String string2;
        if (!this.onlineChecking(string)) {
            this.m_connections.put(string, failed);
            return null;
        }
        String string3 = this.m_saf.getUser(string);
        if (string3 == null) {
            string3 = this.m_saf.getUser();
            if (string3 == null) {
                errorLog.addEntry(new JSError(SemanticErrors.internalError("ConnectionManager")));
            }
            if (this.m_saf.getVerbose() && !string.equals("")) {
                errorLog.addEntry(new Info(SemanticErrors.noUserForContext(string, string3)));
            }
        }
        if ((string2 = this.m_saf.getURL(string)) == null) {
            string2 = this.m_saf.getURL();
            if (string2 == null) {
                errorLog.addEntry(new JSError(SemanticErrors.noConnectStringSpecified(string)));
                this.m_connections.put(string, failed);
                return null;
            }
            if (this.m_saf.getVerbose() && !string.equals("")) {
                errorLog.addEntry(new Info(SemanticErrors.noConnectionForContext(string, string2)));
            }
        }
        this.m_connFact.setUser(string3);
        this.m_connFact.setURL(string2);
        this.m_connFact.setURLPrefix(this.m_saf.getUrlPrefix());
        this.m_connFact.setDrivers(this.m_saf.getDrivers());
        this.m_connFact.setVerbose(this.m_saf.getVerbose());
        String string4 = this.m_connFact.toString();
        Object v2 = this.m_user_url.get(string4);
        if (v2 == failed) {
            this.m_connections.put(string, failed);
            return null;
        }
        if (v2 != null) {
            this.m_connections.put(string, v2);
            return (Connection)v2;
        }
        String string5 = this.m_saf.getPassword(string);
        if (string5 == null) {
            string5 = this.m_saf.getPassword();
        }
        this.m_connFact.setPassword(string5);
        try {
            Connection connection = this.m_connFact.getConnection(errorLog);
            this.m_connections.put(string, connection);
            this.m_user_url.put(string4, connection);
            return connection;
        }
        catch (SQLException sQLException) {
            String string6 = sQLException.getMessage();
            errorLog.addEntry(new Warning(SemanticErrors.unableToAnalyzeConnection(string3, string2, string6)));
            this.m_connections.put(string, failed);
            this.m_user_url.put(string4, failed);
            return null;
        }
    }
}

