/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sqlj.framework.JSClass;
import sqlj.framework.checker.SQLTypeProperties;
import sqlj.framework.error.ErrorLog;

public class TypeProperties
implements SQLTypeProperties {
    private Connection m_conn = null;
    private ErrorLog m_el = null;
    public static JSClass Invalid_TYPE = JSClass.reflectSystemClass(Invalid.class);
    private Hashtable sql92Keys = null;
    private static Boolean isKey = new Boolean(true);
    public static final int UNKNOWN = -999999;
    private Hashtable builtIns = null;
    private static Boolean isBuiltIn = new Boolean(true);

    public TypeProperties(Connection connection) {
        this.m_conn = connection;
    }

    public TypeProperties() {
        this(null);
    }

    @Override
    public Connection getConnection() {
        return this.m_conn;
    }

    public void setConnection(Connection connection) {
        this.m_conn = connection;
    }

    public void setErrorLog(ErrorLog errorLog) {
        this.m_el = errorLog;
    }

    public ErrorLog getErrorLog() {
        return this.m_el;
    }

    public boolean errorOnUnsupportedTypes() {
        return false;
    }

    public boolean errorOnIncompatibleTypes() {
        return false;
    }

    public boolean isVendorKeyword(String string) {
        if (this.sql92Keys == null) {
            this.sql92Keys = new Hashtable();
            String[] stringArray = new String[]{"connect", "disconnect", "set", "commit", "rollback", "create", "grant", "alter", "drop", "revoke", "module", "select", "insert", "update", "delete", "declare", "open", "fetch", "close", "execute", "prepare", "deallocate", "allocate"};
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.sql92Keys.put(stringArray[i2], isKey);
            }
            Connection connection = this.getConnection();
            if (connection != null) {
                try {
                    String string2 = connection.getMetaData().getSQLKeywords();
                    if (string2 != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                        while (stringTokenizer.hasMoreElements()) {
                            this.sql92Keys.put(stringTokenizer.nextToken().toLowerCase(), isKey);
                        }
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return this.sql92Keys.get(string.toLowerCase()) != null;
    }

    public boolean acceptNonVendorKeyword() {
        return true;
    }

    @Override
    public String printJavaType(JSClass jSClass) {
        if (jSClass == null) {
            throw new IllegalArgumentException("JSClass was null");
        }
        String string = jSClass.toString();
        while (string.startsWith("[")) {
            string = string.substring(1) + "[]";
        }
        return string;
    }

    private static boolean isPrimitiveJavaType(JSClass jSClass) {
        return jSClass.equals(JSClass.boolean_TYPE) || jSClass.equals(JSClass.char_TYPE) || jSClass.equals(JSClass.int_TYPE) || jSClass.equals(JSClass.long_TYPE) || jSClass.equals(JSClass.float_TYPE) || jSClass.equals(JSClass.double_TYPE) || jSClass.equals(JSClass.byte_TYPE) || jSClass.equals(JSClass.short_TYPE);
    }

    private static boolean isCharacterType(JSClass jSClass) {
        return jSClass.equals(JSClass.char_TYPE) || jSClass.equals(JSClass.Character_TYPE);
    }

    private static boolean isJavaClass(JSClass jSClass) {
        return jSClass.equals(JSClass.Boolean_TYPE) || jSClass.equals(JSClass.Character_TYPE) || jSClass.equals(JSClass.Integer_TYPE) || jSClass.equals(JSClass.Long_TYPE) || jSClass.equals(JSClass.Float_TYPE) || jSClass.equals(JSClass.Double_TYPE) || jSClass.equals(JSClass.String_TYPE) || jSClass.equals(JSClass.Object_TYPE) || jSClass.equals(JSClass.BigDecimal_TYPE) || jSClass.equals(JSClass.Byte_TYPE) || jSClass.equals(JSClass.Short_TYPE) || jSClass.equals(JSClass.bytearray_TYPE);
    }

    private static boolean isJDBCClass(JSClass jSClass) {
        return jSClass.equals(JSClass.Date_TYPE) || jSClass.equals(JSClass.Time_TYPE) || jSClass.equals(JSClass.Timestamp_TYPE);
    }

    private static boolean isSQLJClass(JSClass jSClass) {
        return jSClass.equals(JSClass.AsciiStream_TYPE) || jSClass.equals(JSClass.BinaryStream_TYPE) || jSClass.equals(JSClass.UnicodeStream_TYPE);
    }

    @Override
    public boolean isCursorColumnType(JSClass jSClass) {
        return !TypeProperties.isCharacterType(jSClass) && (TypeProperties.isPrimitiveJavaType(jSClass) || TypeProperties.isJavaClass(jSClass) || TypeProperties.isJDBCClass(jSClass) || TypeProperties.isSQLJClass(jSClass));
    }

    @Override
    public final boolean isCursorType(JSClass jSClass) {
        return JSClass.PositionedIterator_TYPE.isAssignableFrom(jSClass) && jSClass != JSClass.PositionedIterator_TYPE || JSClass.NamedIterator_TYPE.isAssignableFrom(jSClass) && jSClass != JSClass.NamedIterator_TYPE || jSClass == JSClass.ResultSetIterator_TYPE;
    }

    @Override
    public boolean isHostItemOutType(JSClass jSClass) {
        return !TypeProperties.isSQLJClass(jSClass) && this.isCursorColumnType(jSClass);
    }

    @Override
    public boolean isHostItemInType(JSClass jSClass) {
        return this.isCursorColumnType(jSClass);
    }

    @Override
    public String fullTypeName(int n2, String string) {
        switch (n2) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return string;
    }

    @Override
    public boolean isNumeric(int n2, String string) {
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isNumeric(JSClass jSClass) {
        return jSClass.equals(JSClass.byte_TYPE) || jSClass.equals(JSClass.Byte_TYPE) || jSClass.equals(JSClass.short_TYPE) || jSClass.equals(JSClass.Short_TYPE) || jSClass.equals(JSClass.float_TYPE) || jSClass.equals(JSClass.Float_TYPE) || jSClass.equals(JSClass.int_TYPE) || jSClass.equals(JSClass.Integer_TYPE) || jSClass.equals(JSClass.long_TYPE) || jSClass.equals(JSClass.Long_TYPE) || jSClass.equals(JSClass.double_TYPE) || jSClass.equals(JSClass.Double_TYPE) || jSClass.equals(JSClass.BigDecimal_TYPE) || jSClass.equals(JSClass.boolean_TYPE) || jSClass.equals(JSClass.Boolean_TYPE);
    }

    private static boolean isDateTime(JSClass jSClass) {
        return jSClass.equals(JSClass.Date_TYPE) || jSClass.equals(JSClass.Time_TYPE) || jSClass.equals(JSClass.Timestamp_TYPE);
    }

    private static boolean isCharStream(JSClass jSClass) {
        return jSClass.equals(JSClass.AsciiStream_TYPE) || jSClass.equals(JSClass.UnicodeStream_TYPE);
    }

    private static boolean isStringOrObject(JSClass jSClass) {
        return jSClass.equals(JSClass.String_TYPE) || jSClass.equals(JSClass.Object_TYPE);
    }

    @Override
    public boolean isCompatible(int n2, String string, JSClass jSClass) {
        switch (n2) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return this.isNumeric(jSClass) || TypeProperties.isStringOrObject(jSClass);
            }
            case -1: 
            case 1: 
            case 12: {
                return this.isNumeric(jSClass) || TypeProperties.isDateTime(jSClass) || TypeProperties.isCharStream(jSClass) || TypeProperties.isStringOrObject(jSClass);
            }
            case -4: 
            case -3: 
            case -2: {
                return TypeProperties.isCharStream(jSClass) || jSClass.equals(JSClass.BinaryStream_TYPE) || jSClass.equals(JSClass.bytearray_TYPE) || TypeProperties.isStringOrObject(jSClass);
            }
            case 91: {
                return jSClass.equals(JSClass.Date_TYPE) || jSClass.equals(JSClass.Timestamp_TYPE) || TypeProperties.isStringOrObject(jSClass);
            }
            case 92: {
                return jSClass.equals(JSClass.Time_TYPE) || TypeProperties.isStringOrObject(jSClass);
            }
            case 93: {
                return TypeProperties.isDateTime(jSClass) || TypeProperties.isStringOrObject(jSClass);
            }
            case 1111: {
                return jSClass.equals(JSClass.Object_TYPE);
            }
        }
        throw new IllegalArgumentException("TypeProperties.isCompatible(): " + n2 + " is not a JDBC type code");
    }

    @Override
    public boolean isNullable(JSClass jSClass) {
        return !TypeProperties.isPrimitiveJavaType(jSClass);
    }

    @Override
    public short getCompatibleSQLTypeCode(JSClass jSClass) {
        if (jSClass == JSClass.boolean_TYPE || jSClass == JSClass.Boolean_TYPE) {
            return -7;
        }
        if (jSClass == JSClass.byte_TYPE || jSClass == JSClass.Byte_TYPE) {
            return -6;
        }
        if (jSClass == JSClass.short_TYPE || jSClass == JSClass.Short_TYPE) {
            return 5;
        }
        if (jSClass == JSClass.int_TYPE || jSClass == JSClass.Integer_TYPE) {
            return 4;
        }
        if (jSClass == JSClass.Long_TYPE || jSClass == JSClass.long_TYPE) {
            return -5;
        }
        if (jSClass == JSClass.double_TYPE || jSClass == JSClass.Double_TYPE) {
            return 8;
        }
        if (jSClass == JSClass.float_TYPE || jSClass == JSClass.Float_TYPE) {
            return 6;
        }
        if (jSClass == JSClass.BigDecimal_TYPE) {
            return 2;
        }
        if (jSClass == JSClass.String_TYPE) {
            return 1;
        }
        if (jSClass == JSClass.bytearray_TYPE || jSClass == JSClass.AsciiStream_TYPE || jSClass == JSClass.UnicodeStream_TYPE || jSClass == JSClass.BinaryStream_TYPE) {
            return -2;
        }
        if (jSClass == JSClass.Date_TYPE) {
            return 91;
        }
        if (jSClass == JSClass.Time_TYPE) {
            return 92;
        }
        if (jSClass == JSClass.Timestamp_TYPE) {
            return 93;
        }
        if (jSClass == JSClass.Object_TYPE) {
            return 1111;
        }
        throw new IllegalArgumentException("TypeProperties.getCompatibleSQLTypeCode(): no JDBC code for " + jSClass);
    }

    @Override
    public String getCompatibleSQLTypeName(JSClass jSClass, int n2) {
        return null;
    }

    @Override
    public boolean noLossOfPrecisionOnOutput(int n2, String string, int n3, int n4, JSClass jSClass) {
        switch (n2) {
            case -7: {
                return true;
            }
            case -6: {
                return !jSClass.equals(JSClass.boolean_TYPE) && !jSClass.equals(JSClass.Boolean_TYPE);
            }
            case 4: 
            case 5: {
                return !jSClass.equals(JSClass.boolean_TYPE) && !jSClass.equals(JSClass.Boolean_TYPE) && !jSClass.equals(JSClass.byte_TYPE) && !jSClass.equals(JSClass.Byte_TYPE) && !jSClass.equals(JSClass.short_TYPE) && !jSClass.equals(JSClass.Short_TYPE);
            }
            case -5: {
                return !jSClass.equals(JSClass.boolean_TYPE) && !jSClass.equals(JSClass.Boolean_TYPE) && !jSClass.equals(JSClass.byte_TYPE) && !jSClass.equals(JSClass.Byte_TYPE) && !jSClass.equals(JSClass.short_TYPE) && !jSClass.equals(JSClass.Short_TYPE) && !jSClass.equals(JSClass.int_TYPE) && !jSClass.equals(JSClass.Integer_TYPE);
            }
            case 8: {
                return !jSClass.equals(JSClass.boolean_TYPE) && !jSClass.equals(JSClass.Boolean_TYPE) && !jSClass.equals(JSClass.byte_TYPE) && !jSClass.equals(JSClass.Byte_TYPE) && !jSClass.equals(JSClass.short_TYPE) && !jSClass.equals(JSClass.Short_TYPE) && !jSClass.equals(JSClass.int_TYPE) && !jSClass.equals(JSClass.Integer_TYPE) && !jSClass.equals(JSClass.long_TYPE) && !jSClass.equals(JSClass.Long_TYPE) && !jSClass.equals(JSClass.float_TYPE) && !jSClass.equals(JSClass.Float_TYPE);
            }
            case 6: 
            case 7: {
                return !jSClass.equals(JSClass.boolean_TYPE) && !jSClass.equals(JSClass.Boolean_TYPE) && !jSClass.equals(JSClass.byte_TYPE) && !jSClass.equals(JSClass.Byte_TYPE) && !jSClass.equals(JSClass.short_TYPE) && !jSClass.equals(JSClass.Short_TYPE) && !jSClass.equals(JSClass.int_TYPE) && !jSClass.equals(JSClass.Integer_TYPE) && !jSClass.equals(JSClass.long_TYPE) && !jSClass.equals(JSClass.Long_TYPE);
            }
            case 3: {
                return jSClass.equals(JSClass.BigDecimal_TYPE);
            }
            case 2: {
                if (n4 == 0 && n3 == 0) {
                    n3 = 38;
                }
                if (jSClass.equals(JSClass.byte_TYPE) || jSClass.equals(JSClass.Byte_TYPE)) {
                    return n4 == 0 && n3 <= 2;
                }
                if (jSClass.equals(JSClass.short_TYPE) || jSClass.equals(JSClass.Short_TYPE)) {
                    return n4 == 0 && n3 <= 4;
                }
                if (jSClass.equals(JSClass.int_TYPE) || jSClass.equals(JSClass.Integer_TYPE)) {
                    return n4 == 0 && n3 <= 9;
                }
                if (jSClass.equals(JSClass.long_TYPE) || jSClass.equals(JSClass.Long_TYPE)) {
                    return n4 == 0 && n3 <= 18;
                }
                if (jSClass.equals(JSClass.float_TYPE) || jSClass.equals(JSClass.Float_TYPE)) {
                    int n5 = -37;
                    int n6 = 37;
                    return n3 <= 6 && n5 - n3 + 1 <= n4 && n4 <= n6 - n3 + 1;
                }
                if (jSClass.equals(JSClass.double_TYPE) || jSClass.equals(JSClass.Double_TYPE)) {
                    int n7 = -307;
                    int n8 = 307;
                    return n3 <= 14 && n7 - n3 + 1 <= n4 && n4 <= n8 - n3 + 1;
                }
                return jSClass.equals(JSClass.BigDecimal_TYPE);
            }
        }
        throw new IllegalArgumentException("TypeProperties.noLossOfPrecisionOnOutput(): unknown JDBC typecode " + n2);
    }

    @Override
    public int[] resolveSQLSignature(int[] nArray, String[] stringArray, int[][] nArray2, String[][] stringArray2) {
        Vector<Integer> vector = new Vector<Integer>();
        for (int i2 = 0; i2 < nArray2.length; ++i2) {
            if (nArray.length != nArray2[i2].length) continue;
            vector.addElement(new Integer(i2));
        }
        int[] nArray3 = new int[vector.size()];
        for (int i3 = 0; i3 < nArray3.length; ++i3) {
            nArray3[i3] = (Integer)vector.elementAt(i3);
        }
        return nArray3;
    }

    @Override
    public void bindNull(JSClass jSClass, int n2, PreparedStatement preparedStatement) throws SQLException {
        if (jSClass.equals(JSClass.int_TYPE)) {
            preparedStatement.setInt(n2, 0);
        } else if (jSClass.equals(JSClass.boolean_TYPE)) {
            preparedStatement.setBoolean(n2, false);
        } else if (jSClass.equals(JSClass.short_TYPE)) {
            preparedStatement.setShort(n2, (short)0);
        } else if (jSClass.equals(JSClass.byte_TYPE)) {
            preparedStatement.setByte(n2, (byte)0);
        } else if (jSClass.equals(JSClass.double_TYPE)) {
            preparedStatement.setDouble(n2, 0.0);
        } else if (jSClass.equals(JSClass.float_TYPE)) {
            preparedStatement.setFloat(n2, 0.0f);
        } else if (jSClass.equals(JSClass.long_TYPE)) {
            preparedStatement.setLong(n2, 0L);
        } else if (jSClass.equals(JSClass.Object_TYPE)) {
            preparedStatement.setObject(n2, null);
        } else {
            try {
                short s2 = this.getCompatibleSQLTypeCode(jSClass);
                preparedStatement.setNull(n2, s2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                preparedStatement.setObject(n2, null);
            }
        }
    }

    public boolean isBuiltInFunction(String string) {
        if (this.builtIns == null && this.getConnection() != null) {
            this.populateBuiltIns();
        }
        if (string == null || this.builtIns == null) {
            return false;
        }
        return this.builtIns.get(string.toLowerCase()) != null;
    }

    private void populateBuiltIns() {
        String[] stringArray;
        this.builtIns = new Hashtable();
        try {
            DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
            stringArray = new String[]{databaseMetaData.getNumericFunctions(), databaseMetaData.getTimeDateFunctions(), databaseMetaData.getSystemFunctions(), databaseMetaData.getStringFunctions()};
        }
        catch (SQLException sQLException) {
            stringArray = new String[]{};
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i2], ",");
            while (stringTokenizer.hasMoreTokens()) {
                this.builtIns.put(stringTokenizer.nextToken().toLowerCase(), isBuiltIn);
            }
        }
    }

    class Invalid {
        Invalid() {
        }
    }
}

