/*
 * Decompiled with CFR 0.152.
 */
package sqlj.semantics.sql;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sqlj.framework.checker.SQLToken;

public class SQLMisc {
    private static final Hashtable SQL92reserved = SQLMisc.newSQL92ReservedTable();
    private static final String oraclev8 = "v8";
    private static final String oraclev7 = "v7";
    private static final String oraclev7key = "v7key";
    private static final String sql92stmt = "92stmt";

    public static String sqlCasing(String string) {
        if (string == null) {
            return string;
        }
        if (string.substring(0, 1).equals("\"") && string.substring(string.length() - 1).equals("\"")) {
            return string.substring(1, string.length() - 1);
        }
        return string.toUpperCase();
    }

    public static String sqlCasing(SQLToken sQLToken) {
        if (sQLToken == null) {
            return null;
        }
        if (sQLToken.tokenType() == 2) {
            return SQLMisc.sqlCasing(sQLToken.tokenText());
        }
        return sQLToken.tokenText();
    }

    public static String sqlCasing(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(SQLMisc.sqlCasing((SQLToken)enumeration.nextElement()));
        }
        return stringBuffer.toString();
    }

    public static String sqlCasing(Vector vector) {
        if (vector == null) {
            return null;
        }
        return SQLMisc.sqlCasing(vector.elements());
    }

    public static String printSqlId(Enumeration enumeration) {
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            SQLToken sQLToken = (SQLToken)enumeration.nextElement();
            String string = sQLToken.tokenText();
            if (sQLToken.tokenType() == 2 && !string.startsWith("\"")) {
                stringBuffer.append(SQLMisc.sqlCasing(string));
                continue;
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String printSqlId(Vector vector) {
        return SQLMisc.printSqlId(vector.elements());
    }

    public static boolean isSQL92Reserved(String string) {
        return SQL92reserved.get(string.toLowerCase()) != null;
    }

    public static boolean isSQL92Statement(String string) {
        return SQL92reserved.get(string.toLowerCase()) == sql92stmt;
    }

    private static Hashtable newSQL92ReservedTable() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("binary", oraclev8);
        hashtable.put("blob", oraclev8);
        hashtable.put("clob", oraclev8);
        hashtable.put("echo", oraclev8);
        hashtable.put("ref", oraclev8);
        hashtable.put("rem", sql92stmt);
        hashtable.put("replace", oraclev8);
        hashtable.put("signed", oraclev8);
        hashtable.put("type", oraclev8);
        hashtable.put("unsigned", oraclev8);
        hashtable.put("value", oraclev8);
        hashtable.put("varray", oraclev8);
        hashtable.put("access", oraclev7);
        hashtable.put("add", oraclev7);
        hashtable.put("all", oraclev7);
        hashtable.put("alter", sql92stmt);
        hashtable.put("and", oraclev7);
        hashtable.put("any", oraclev7);
        hashtable.put("as", oraclev7);
        hashtable.put("asc", oraclev7);
        hashtable.put("audit", sql92stmt);
        hashtable.put("between", oraclev7);
        hashtable.put("by", oraclev7);
        hashtable.put("char", oraclev7);
        hashtable.put("check", oraclev7);
        hashtable.put("cluster", oraclev7);
        hashtable.put("column", oraclev7);
        hashtable.put("comment", oraclev7);
        hashtable.put("compress", oraclev7);
        hashtable.put("connect", sql92stmt);
        hashtable.put("create", sql92stmt);
        hashtable.put("current", oraclev7);
        hashtable.put("date", oraclev7);
        hashtable.put("decimal", oraclev7);
        hashtable.put("default", oraclev7);
        hashtable.put("delete", sql92stmt);
        hashtable.put("desc", oraclev7);
        hashtable.put("distinct", oraclev7);
        hashtable.put("drop", sql92stmt);
        hashtable.put("else", oraclev7);
        hashtable.put("exclusive", oraclev7);
        hashtable.put("exists", oraclev7);
        hashtable.put("file", oraclev7);
        hashtable.put("float", oraclev7);
        hashtable.put("from", oraclev7);
        hashtable.put("grant", sql92stmt);
        hashtable.put("group", oraclev7);
        hashtable.put("having", oraclev7);
        hashtable.put("identified", oraclev7);
        hashtable.put("immediate", oraclev7);
        hashtable.put("in", oraclev7);
        hashtable.put("increment", oraclev7);
        hashtable.put("index", oraclev7);
        hashtable.put("initial", oraclev7);
        hashtable.put("insert", sql92stmt);
        hashtable.put("integer", oraclev7);
        hashtable.put("intersect", oraclev7);
        hashtable.put("into", oraclev7);
        hashtable.put("is", oraclev7);
        hashtable.put("level", oraclev7);
        hashtable.put("like", oraclev7);
        hashtable.put("lock", oraclev7);
        hashtable.put("long", oraclev7);
        hashtable.put("maxextents", oraclev7);
        hashtable.put("minus", oraclev7);
        hashtable.put("mode", oraclev7);
        hashtable.put("modify", sql92stmt);
        hashtable.put("noaudit", oraclev7);
        hashtable.put("nocompress", oraclev7);
        hashtable.put("not", oraclev7);
        hashtable.put("nowait", oraclev7);
        hashtable.put("null", oraclev7);
        hashtable.put("number", oraclev7);
        hashtable.put("of", oraclev7);
        hashtable.put("offline", oraclev7);
        hashtable.put("on", oraclev7);
        hashtable.put("online", oraclev7);
        hashtable.put("option", oraclev7);
        hashtable.put("or", oraclev7);
        hashtable.put("order", oraclev7);
        hashtable.put("pctfree", oraclev7);
        hashtable.put("prior", oraclev7);
        hashtable.put("privileges", oraclev7);
        hashtable.put("public", oraclev7);
        hashtable.put("raw", oraclev7);
        hashtable.put("rename", sql92stmt);
        hashtable.put("resource", oraclev7);
        hashtable.put("revoke", sql92stmt);
        hashtable.put("row", oraclev7);
        hashtable.put("rowid", oraclev7);
        hashtable.put("rowlabel", oraclev7);
        hashtable.put("rownum", oraclev7);
        hashtable.put("rows", oraclev7);
        hashtable.put("select", sql92stmt);
        hashtable.put("session", oraclev7);
        hashtable.put("set", sql92stmt);
        hashtable.put("share", oraclev7);
        hashtable.put("size", oraclev7);
        hashtable.put("smallint", oraclev7);
        hashtable.put("start", oraclev7);
        hashtable.put("successful", oraclev7);
        hashtable.put("synonym", oraclev7);
        hashtable.put("sysdate", oraclev7);
        hashtable.put("table", oraclev7);
        hashtable.put("then", oraclev7);
        hashtable.put("to", oraclev7);
        hashtable.put("trigger", oraclev7);
        hashtable.put("uid", oraclev7);
        hashtable.put("union", oraclev7);
        hashtable.put("unique", oraclev7);
        hashtable.put("update", sql92stmt);
        hashtable.put("user", oraclev7);
        hashtable.put("validate", sql92stmt);
        hashtable.put("values", oraclev7);
        hashtable.put("varchar", oraclev7);
        hashtable.put("varchar2", oraclev7);
        hashtable.put("view", oraclev7);
        hashtable.put("whenever", oraclev7);
        hashtable.put("where", oraclev7);
        hashtable.put("with", oraclev7);
        hashtable.put("admin", oraclev7key);
        hashtable.put("after", oraclev7key);
        hashtable.put("allocate", oraclev7key);
        hashtable.put("analyze", oraclev7key);
        hashtable.put("archive", oraclev7key);
        hashtable.put("archivelog", oraclev7key);
        hashtable.put("authorization", oraclev7key);
        hashtable.put("avg", oraclev7key);
        hashtable.put("backup", oraclev7key);
        hashtable.put("begin", oraclev7key);
        hashtable.put("become", oraclev7key);
        hashtable.put("before", oraclev7key);
        hashtable.put("block", oraclev7key);
        hashtable.put("body", oraclev7key);
        hashtable.put("cache", oraclev7key);
        hashtable.put("cancel", oraclev7key);
        hashtable.put("cascade", oraclev7key);
        hashtable.put("change", oraclev7key);
        hashtable.put("character", oraclev7key);
        hashtable.put("checkpoint", oraclev7key);
        hashtable.put("close", oraclev7key);
        hashtable.put("cobol", oraclev7key);
        hashtable.put("commit", oraclev7key);
        hashtable.put("compile", oraclev7key);
        hashtable.put("constraint", oraclev7key);
        hashtable.put("constraints", oraclev7key);
        hashtable.put("contents", oraclev7key);
        hashtable.put("continue", oraclev7key);
        hashtable.put("controlfile", oraclev7key);
        hashtable.put("count", oraclev7key);
        hashtable.put("cursor", oraclev7key);
        hashtable.put("cycle", oraclev7key);
        hashtable.put("database", oraclev7key);
        hashtable.put("datafile", oraclev7key);
        hashtable.put("dba", oraclev7key);
        hashtable.put("dec", oraclev7key);
        hashtable.put("declare", oraclev7key);
        hashtable.put("disable", oraclev7key);
        hashtable.put("dismount", oraclev7key);
        hashtable.put("double", oraclev7key);
        hashtable.put("dump", oraclev7key);
        hashtable.put("each", oraclev7key);
        hashtable.put("enable", oraclev7key);
        hashtable.put("end", oraclev7key);
        hashtable.put("escape", oraclev7key);
        hashtable.put("events", oraclev7key);
        hashtable.put("except", oraclev7key);
        hashtable.put("exceptions", oraclev7key);
        hashtable.put("exec", oraclev7key);
        hashtable.put("explain", oraclev7key);
        hashtable.put("execute", oraclev7key);
        hashtable.put("extent", oraclev7key);
        hashtable.put("externally", oraclev7key);
        hashtable.put("fetch", oraclev7key);
        hashtable.put("flush", oraclev7key);
        hashtable.put("freelist", oraclev7key);
        hashtable.put("freelists", oraclev7key);
        hashtable.put("force", oraclev7key);
        hashtable.put("foreign", oraclev7key);
        hashtable.put("fortran", oraclev7key);
        hashtable.put("found", oraclev7key);
        hashtable.put("function", oraclev7key);
        hashtable.put("go", oraclev7key);
        hashtable.put("goto", oraclev7key);
        hashtable.put("groups", oraclev7key);
        hashtable.put("including", oraclev7key);
        hashtable.put("indicator", oraclev7key);
        hashtable.put("initrans", oraclev7key);
        hashtable.put("instance", oraclev7key);
        hashtable.put("int", oraclev7key);
        hashtable.put("key", oraclev7key);
        hashtable.put("language", oraclev7key);
        hashtable.put("layer", oraclev7key);
        hashtable.put("link", oraclev7key);
        hashtable.put("lists", oraclev7key);
        hashtable.put("logfile", oraclev7key);
        hashtable.put("manage", oraclev7key);
        hashtable.put("manual", oraclev7key);
        hashtable.put("max", oraclev7key);
        hashtable.put("maxdatafiles", oraclev7key);
        hashtable.put("maxinstances", oraclev7key);
        hashtable.put("maxlogfiles", oraclev7key);
        hashtable.put("maxloghistory", oraclev7key);
        hashtable.put("maxlogmembers", oraclev7key);
        hashtable.put("maxtrans", oraclev7key);
        hashtable.put("maxvalue", oraclev7key);
        hashtable.put("min", oraclev7key);
        hashtable.put("minextents", oraclev7key);
        hashtable.put("minvalue", oraclev7key);
        hashtable.put("module", oraclev7key);
        hashtable.put("mount", oraclev7key);
        hashtable.put("next", oraclev7key);
        hashtable.put("new", oraclev7key);
        hashtable.put("noarchivelog", oraclev7key);
        hashtable.put("nocache", oraclev7key);
        hashtable.put("nocycle", oraclev7key);
        hashtable.put("nomaxvalue", oraclev7key);
        hashtable.put("nominvalue", oraclev7key);
        hashtable.put("none", oraclev7key);
        hashtable.put("noorder", oraclev7key);
        hashtable.put("noresetlogs", oraclev7key);
        hashtable.put("normal", oraclev7key);
        hashtable.put("nosort", oraclev7key);
        hashtable.put("numeric", oraclev7key);
        hashtable.put("off", oraclev7key);
        hashtable.put("old", oraclev7key);
        hashtable.put("only", oraclev7key);
        hashtable.put("optimal", oraclev7key);
        hashtable.put("open", oraclev7key);
        hashtable.put("own", oraclev7key);
        hashtable.put("package", oraclev7key);
        hashtable.put("parallel", oraclev7key);
        hashtable.put("pascal", oraclev7key);
        hashtable.put("pctincrease", oraclev7key);
        hashtable.put("pctused", oraclev7key);
        hashtable.put("plan", oraclev7key);
        hashtable.put("pli", oraclev7key);
        hashtable.put("precision", oraclev7key);
        hashtable.put("primary", oraclev7key);
        hashtable.put("private", oraclev7key);
        hashtable.put("procedure", oraclev7key);
        hashtable.put("profile", oraclev7key);
        hashtable.put("quota", oraclev7key);
        hashtable.put("read", oraclev7key);
        hashtable.put("real", oraclev7key);
        hashtable.put("recover", oraclev7key);
        hashtable.put("references", oraclev7key);
        hashtable.put("referencing", oraclev7key);
        hashtable.put("resetlogs", oraclev7key);
        hashtable.put("restricted", oraclev7key);
        hashtable.put("reuse", oraclev7key);
        hashtable.put("role", oraclev7key);
        hashtable.put("roles", oraclev7key);
        hashtable.put("rollback", oraclev7key);
        hashtable.put("savepoint", oraclev7key);
        hashtable.put("schema", oraclev7key);
        hashtable.put("scn", oraclev7key);
        hashtable.put("section", oraclev7key);
        hashtable.put("segment", oraclev7key);
        hashtable.put("sequence", oraclev7key);
        hashtable.put("shared", oraclev7key);
        hashtable.put("snapshot", oraclev7key);
        hashtable.put("some", oraclev7key);
        hashtable.put("sort", oraclev7key);
        hashtable.put("sqlcode", oraclev7key);
        hashtable.put("sqlerror", oraclev7key);
        hashtable.put("statement_id", oraclev7key);
        hashtable.put("statistics", oraclev7key);
        hashtable.put("stop", oraclev7key);
        hashtable.put("storage", oraclev7key);
        hashtable.put("sum", oraclev7key);
        hashtable.put("switch", oraclev7key);
        hashtable.put("system", oraclev7key);
        hashtable.put("tables", oraclev7key);
        hashtable.put("tablespace", oraclev7key);
        hashtable.put("temporary", oraclev7key);
        hashtable.put("thread", oraclev7key);
        hashtable.put("time", oraclev7key);
        hashtable.put("tracing", oraclev7key);
        hashtable.put("transaction", oraclev7key);
        hashtable.put("triggers", oraclev7key);
        hashtable.put("truncate", oraclev7key);
        hashtable.put("under", oraclev7key);
        hashtable.put("unlimited", oraclev7key);
        hashtable.put("until", oraclev7key);
        hashtable.put("use", oraclev7key);
        hashtable.put("using", oraclev7key);
        hashtable.put("when", oraclev7key);
        hashtable.put("write", oraclev7key);
        hashtable.put("work", oraclev7key);
        return hashtable;
    }

    public static String stringify(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c2 == '\b') {
                stringBuffer.append("\\b");
                continue;
            }
            if (c2 == '\t') {
                stringBuffer.append("\\t");
                continue;
            }
            if (c2 == '\f') {
                stringBuffer.append("\\f");
                continue;
            }
            if (c2 == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }
}

