/*
 * Decompiled with CFR 0.152.
 */
package sqlj.translator;

import java.io.File;
import java.io.IOException;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.JSError;
import sqlj.framework.options.HasOptions;
import sqlj.framework.options.InvalidOptionException;
import sqlj.framework.options.PropertyList;
import sqlj.mesg.OptionDesc;
import sqlj.mesg.TranslatorErrors;
import sqlj.translator.FileTranslationUnit;
import sqlj.translator.TranslationUnit;
import sqlj.util.io.ErrorLogger;

public class TranslationUnitFactory
implements HasOptions {
    private static final String DIR_OPTION = "dir";
    private static final String SER_DIR_OPTION = "d";
    private static final String ENCODING_OPTION = "encoding";
    private String m_dir_location = OptionDesc.default_origin();
    private String m_directory = null;
    private String m_ser_dir_location = OptionDesc.default_origin();
    private String m_ser_directory = null;
    private String m_enc_location = OptionDesc.default_origin();
    private String m_encoding = null;

    TranslationUnitFactory() {
    }

    TranslationUnit newTranslationUnit(String string, ErrorLogger errorLogger) throws IOException {
        return new FileTranslationUnit(string, this.m_directory, this.m_ser_directory, this.m_encoding, errorLogger);
    }

    String getDirectory() {
        return this.m_directory;
    }

    String getSerDirectory() {
        return this.m_ser_directory;
    }

    String getEncoding() {
        return this.m_encoding;
    }

    @Override
    public void setOptions(PropertyList propertyList, ErrorLog errorLog) throws InvalidOptionException {
        this.m_directory = propertyList.getProperty(DIR_OPTION);
        if (this.m_directory != null && this.m_directory.equals("")) {
            this.m_directory = null;
        }
        if (this.m_directory != null) {
            this.m_dir_location = propertyList.getPropertyLocation(DIR_OPTION);
            if (!new File(this.m_directory).isDirectory()) {
                errorLog.addEntry(new JSError(OptionDesc.bad_option(DIR_OPTION, this.m_dir_location, TranslatorErrors.not_a_directory(this.m_directory))));
                throw new InvalidOptionException();
            }
        }
        this.m_ser_directory = propertyList.getProperty(SER_DIR_OPTION);
        if (this.m_ser_directory != null && this.m_ser_directory.equals("")) {
            this.m_ser_directory = null;
        }
        if (this.m_ser_directory != null) {
            this.m_ser_dir_location = propertyList.getPropertyLocation(SER_DIR_OPTION);
            if (!new File(this.m_ser_directory).isDirectory()) {
                errorLog.addEntry(new JSError(OptionDesc.bad_option(SER_DIR_OPTION, this.m_ser_dir_location, TranslatorErrors.not_a_directory(this.m_ser_directory))));
                throw new InvalidOptionException();
            }
        }
        this.m_encoding = propertyList.getProperty(ENCODING_OPTION);
        if (this.m_encoding != null) {
            this.m_enc_location = propertyList.getPropertyLocation(ENCODING_OPTION);
        } else {
            this.m_encoding = System.getProperty("file.encoding", "8859_1");
        }
    }

    @Override
    public String[][] getOptionInfo() {
        return new String[][]{{DIR_OPTION, OptionDesc.directory(), this.m_directory == null ? OptionDesc.input_dir() : this.m_directory, OptionDesc.java_dir(), this.m_dir_location}};
    }
}

