/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Inovance;

import HslCommunication.Core.Transfer.DataFormat;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.ModBus.ModbusTcpNet;
import HslCommunication.Profinet.Inovance.InovanceHelper;
import HslCommunication.Profinet.Inovance.InovanceSeries;

public class InovanceTcpNet
extends ModbusTcpNet {
    private InovanceSeries Series = InovanceSeries.AM;

    public InovanceTcpNet() {
        this.Series = InovanceSeries.AM;
        this.getByteTransform().setDataFormat(DataFormat.CDAB);
    }

    public InovanceTcpNet(String ipAddress, int port, byte station) {
        super(ipAddress, port, station);
        this.Series = InovanceSeries.AM;
        this.getByteTransform().setDataFormat(DataFormat.CDAB);
    }

    public InovanceTcpNet(InovanceSeries series, String ipAddress, int port, byte station) {
        super(ipAddress, port, station);
        this.Series = series;
    }

    public InovanceSeries getSeries() {
        return this.Series;
    }

    public void setSeries(InovanceSeries series) {
        this.Series = series;
    }

    @Override
    public OperateResultExOne<String> TranslateToModbusAddress(String address, byte modbusCode) {
        return InovanceHelper.PraseInovanceAddress(this.Series, address, modbusCode);
    }

    @Override
    public String toString() {
        return "InovanceTcpNet<" + (Object)((Object)this.Series) + ">[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

