/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Omron;

import HslCommunication.Authorization;
import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.BasicFramework.SoftIncrementCount;
import HslCommunication.Core.IMessage.AllenBradleyMessage;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.ByteTransformHelper;
import HslCommunication.Core.Transfer.RegularByteTransform;
import HslCommunication.Core.Types.BitConverter;
import HslCommunication.Core.Types.FunctionOperateExOne;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExThree;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.Profinet.AllenBradley.AllenBradleyHelper;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.io.ByteArrayOutputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Random;
import java.util.regex.Pattern;

public class OmronConnectedCipNet
extends NetworkDeviceBase {
    private int SessionHandle = 0;
    public String ProductName = "";
    private int OTConnectionId = 0;
    public byte ConnectionTimeoutMultiplier = (byte)2;
    private SoftIncrementCount incrementCount = new SoftIncrementCount(65535L);
    private Random random = new Random();

    public OmronConnectedCipNet() {
        this.WordLength = (short)2;
        this.setByteTransform(new RegularByteTransform());
    }

    public OmronConnectedCipNet(String ipAddress, int port) {
        this();
        this.setIpAddress(ipAddress);
        this.setPort(port);
    }

    @Override
    protected INetMessage GetNewNetMessage() {
        return new AllenBradleyMessage();
    }

    @Override
    protected byte[] PackCommandWithHeader(byte[] command) {
        return AllenBradleyHelper.PackRequestHeader(112, this.SessionHandle, AllenBradleyHelper.PackCommandSpecificData(this.GetOTConnectionIdService(), command));
    }

    @Override
    protected OperateResult InitializationOnConnect(Socket socket) {
        OperateResultExOne<byte[]> read1 = this.ReadFromCoreServer(socket, AllenBradleyHelper.RegisterSessionHandle(), true, false);
        if (!read1.IsSuccess) {
            return read1;
        }
        OperateResult check = AllenBradleyHelper.CheckResponse((byte[])read1.Content);
        if (!check.IsSuccess) {
            return check;
        }
        this.SessionHandle = this.getByteTransform().TransInt32((byte[])read1.Content, 4);
        for (int i = 0; i < 10; ++i) {
            short tick = i < 7 ? (short)i : (short)(100 + i);
            OperateResultExOne<byte[]> read2 = this.ReadFromCoreServer(socket, AllenBradleyHelper.PackRequestHeader(111, this.SessionHandle, this.GetLargeForwardOpen(tick)), true, false);
            if (!read2.IsSuccess) {
                return read2;
            }
            try {
                if (((byte[])read2.Content).length >= 46 && ((byte[])read2.Content)[42] != 0) {
                    int err = this.getByteTransform().TransUInt16((byte[])read2.Content, 44);
                    if (err == 256 && i < 9) continue;
                    if (err == 256) {
                        return new OperateResult("Connection in use or duplicate Forward Open");
                    }
                    if (err == 275) {
                        return new OperateResult("Extended Status: Out of connections (0x0113)");
                    }
                    return new OperateResult("Forward Open failed, Code: " + this.getByteTransform().TransUInt16((byte[])read2.Content, 44));
                }
                this.OTConnectionId = this.getByteTransform().TransInt32((byte[])read2.Content, 44);
                break;
            }
            catch (Exception ex) {
                return new OperateResult(ex.getMessage() + "\r\nSource: " + SoftBasic.ByteToHexString((byte[])read2.Content, ' '));
            }
        }
        this.incrementCount.ResetCurrentValue();
        OperateResultExOne<byte[]> read3 = this.ReadFromCoreServer(socket, AllenBradleyHelper.PackRequestHeader(111, this.SessionHandle, this.GetAttributeAll()), true, false);
        if (!read3.IsSuccess) {
            return read3;
        }
        if (((byte[])read3.Content).length > 59) {
            this.ProductName = new String((byte[])read3.Content, 59, (int)((byte[])read3.Content)[58], StandardCharsets.UTF_8);
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    protected OperateResult ExtraOnDisconnect(Socket socket) {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(socket, AllenBradleyHelper.UnRegisterSessionHandle(this.SessionHandle), true, false);
        if (!read.IsSuccess) {
            return read;
        }
        return OperateResult.CreateSuccessResult();
    }

    private byte[] GetOTConnectionIdService() {
        byte[] buffer = new byte[8];
        buffer[0] = -95;
        buffer[1] = 0;
        buffer[2] = 4;
        buffer[3] = 0;
        System.arraycopy(this.getByteTransform().TransByte(this.OTConnectionId), 0, buffer, 4, 4);
        return buffer;
    }

    private OperateResultExOne<byte[]> BuildReadCommand(String[] address, short[] length) {
        try {
            ArrayList<byte[]> cips = new ArrayList<byte[]>();
            for (int i = 0; i < address.length; ++i) {
                cips.add(AllenBradleyHelper.PackRequsetRead(address[i], length[i], true));
            }
            return OperateResultExOne.CreateSuccessResult(this.PackCommandService(Utilities.ToArray(cips)));
        }
        catch (Exception ex) {
            return new OperateResultExOne<byte[]>("Address Wrong:" + ex.getMessage());
        }
    }

    private OperateResultExOne<byte[]> BuildWriteCommand(String address, short typeCode, byte[] data, int length) {
        try {
            return OperateResultExOne.CreateSuccessResult(this.PackCommandService(new byte[][]{AllenBradleyHelper.PackRequestWrite(address, typeCode, data, length, true)}));
        }
        catch (Exception ex) {
            return new OperateResultExOne<byte[]>("Address Wrong:" + ex.getMessage());
        }
    }

    private byte[] PackCommandService(byte[] ... cip) {
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        ms.write(177);
        ms.write(0);
        ms.write(0);
        ms.write(0);
        long messageId = this.incrementCount.GetCurrentValue();
        ms.write(Utilities.getBytes(messageId)[0]);
        ms.write(Utilities.getBytes(messageId)[1]);
        if (cip.length == 1) {
            ms.write(cip[0], 0, cip[0].length);
        } else {
            int i;
            ms.write(new byte[]{10, 2, 32, 2, 36, 1}, 0, 6);
            ms.write(Utilities.getBytes(cip.length)[0]);
            ms.write(Utilities.getBytes(cip.length)[1]);
            int offset = 2 + cip.length * 2;
            for (i = 0; i < cip.length; ++i) {
                ms.write(Utilities.getBytes(offset)[0]);
                ms.write(Utilities.getBytes(offset)[1]);
                offset += cip[i].length;
            }
            for (i = 0; i < cip.length; ++i) {
                ms.write(cip[i], 0, cip[i].length);
            }
        }
        byte[] data = ms.toByteArray();
        System.arraycopy(Utilities.getBytes((short)(data.length - 4)), 0, data, 2, 2);
        return data;
    }

    private OperateResultExThree<byte[], Short, Boolean> ReadWithType(String[] address, short[] length) {
        OperateResultExOne<byte[]> command = this.BuildReadCommand(address, length);
        if (!command.IsSuccess) {
            return OperateResultExThree.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return OperateResultExThree.CreateFailedResult(read);
        }
        OperateResult check = AllenBradleyHelper.CheckResponse((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExThree.CreateFailedResult(check);
        }
        return OmronConnectedCipNet.ExtractActualData((byte[])read.Content, true);
    }

    public OperateResultExOne<byte[]> ReadCipFromServer(byte[] ... cips) {
        byte[] command = this.PackCommandService(cips);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(command);
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = AllenBradleyHelper.CheckResponse((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return OperateResultExOne.CreateSuccessResult(read.Content);
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExThree<byte[], Short, Boolean> read = this.ReadWithType(new String[]{address}, new short[]{length});
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(read.Content1);
    }

    public OperateResultExOne<byte[]> Read(String[] address, short[] length) {
        if (!Authorization.asdniasnfaksndiqwhawfskhfaiw()) {
            return new OperateResultExOne<byte[]>(StringResources.Language.InsufficientPrivileges());
        }
        OperateResultExThree<byte[], Short, Boolean> read = this.ReadWithType(address, length);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(read.Content1);
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        if (length == 1 && !Pattern.matches("\\[[0-9]+\\]$", address)) {
            OperateResultExOne<byte[]> read = this.Read(address, length);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            return OperateResultExOne.CreateSuccessResult(SoftBasic.ByteToBoolArray((byte[])read.Content));
        }
        OperateResultExOne<byte[]> read = this.Read(address, length);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        boolean[] values = new boolean[length];
        for (int i = 0; i < values.length; ++i) {
            if (((byte[])read.Content)[i] == 0) continue;
            values[i] = true;
        }
        return OperateResultExOne.CreateSuccessResult(values);
    }

    public OperateResultExOne<Byte> ReadByte(String address) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)1);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(((byte[])read.Content)[0]);
    }

    public OperateResultExTwo<Short, byte[]> ReadTag(String address, short length) {
        OperateResultExThree<byte[], Short, Boolean> read = this.ReadWithType(new String[]{address}, new short[]{length});
        if (!read.IsSuccess) {
            return OperateResultExTwo.CreateFailedResult(read);
        }
        return OperateResultExTwo.CreateSuccessResult(read.Content2, read.Content1);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        return new OperateResult(StringResources.Language.NotSupportedFunction() + " Please refer to use WriteTag instead ");
    }

    public OperateResult WriteTag(String address, short typeCode, byte[] value) {
        return this.WriteTag(address, typeCode, value, 1);
    }

    public OperateResult WriteTag(String address, short typeCode, byte[] value, int length) {
        OperateResultExOne<byte[]> command = this.BuildWriteCommand(address, typeCode, value, length);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = AllenBradleyHelper.CheckResponse((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return AllenBradleyHelper.ExtractActualData((byte[])read.Content, false);
    }

    @Override
    public OperateResultExOne<short[]> ReadInt16(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], short[]>(){

            @Override
            public short[] Action(byte[] content) {
                return OmronConnectedCipNet.this.getByteTransform().TransInt16(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<int[]> ReadUInt16(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], int[]>(){

            @Override
            public int[] Action(byte[] content) {
                return OmronConnectedCipNet.this.getByteTransform().TransUInt16(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<int[]> ReadInt32(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], int[]>(){

            @Override
            public int[] Action(byte[] content) {
                return OmronConnectedCipNet.this.getByteTransform().TransInt32(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<long[]> ReadUInt32(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], long[]>(){

            @Override
            public long[] Action(byte[] content) {
                return OmronConnectedCipNet.this.getByteTransform().TransUInt32(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<float[]> ReadFloat(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], float[]>(){

            @Override
            public float[] Action(byte[] content) {
                return OmronConnectedCipNet.this.getByteTransform().TransSingle(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<long[]> ReadInt64(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], long[]>(){

            @Override
            public long[] Action(byte[] content) {
                return OmronConnectedCipNet.this.getByteTransform().TransInt64(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<double[]> ReadDouble(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], double[]>(){

            @Override
            public double[] Action(byte[] content) {
                return OmronConnectedCipNet.this.getByteTransform().TransDouble(content, 0, length);
            }
        });
    }

    public OperateResultExOne<String> ReadString(String address) {
        return this.ReadString(address, (short)1, StandardCharsets.UTF_8);
    }

    @Override
    public OperateResultExOne<String> ReadString(String address, short length) {
        return this.ReadString(address, length, StandardCharsets.UTF_8);
    }

    @Override
    public OperateResultExOne<String> ReadString(String address, short length, Charset encoding) {
        OperateResultExOne<byte[]> read = this.Read(address, length);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        if (((byte[])read.Content).length >= 2) {
            int strLength = this.getByteTransform().TransUInt16((byte[])read.Content, 0);
            return OperateResultExOne.CreateSuccessResult(new String((byte[])read.Content, 2, strLength, encoding));
        }
        return OperateResultExOne.CreateSuccessResult(new String((byte[])read.Content, encoding));
    }

    @Override
    public OperateResult Write(String address, short[] values) {
        return this.WriteTag(address, (short)195, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, int[] values) {
        return this.WriteTag(address, (short)196, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, float[] values) {
        return this.WriteTag(address, (short)202, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, long[] values) {
        return this.WriteTag(address, (short)197, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, double[] values) {
        return this.WriteTag(address, (short)203, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, String value) {
        return this.Write(address, value, StandardCharsets.UTF_8);
    }

    @Override
    public OperateResult Write(String address, String value, Charset encoding) {
        byte[] buffer = Utilities.IsStringNullOrEmpty(value) ? new byte[]{} : value.getBytes(encoding);
        byte[] result = new byte[buffer.length + 2];
        System.arraycopy(Utilities.getBytes((short)buffer.length), 0, result, 0, 2);
        if (buffer.length > 0) {
            System.arraycopy(buffer, 0, result, 2, buffer.length);
        }
        return this.WriteTag(address, (short)208, result);
    }

    @Override
    public OperateResult Write(String address, boolean value) {
        byte[] byArray;
        if (value) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -1;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 0;
            byArray = byArray3;
            byArray3[1] = 0;
        }
        return this.WriteTag(address, (short)193, byArray);
    }

    public OperateResult Write(String address, byte value) {
        return this.WriteTag(address, (short)194, new byte[]{value});
    }

    private byte[] GetLargeForwardOpen(short connectionID) {
        byte[] buffer = SoftBasic.HexStringToBytes("00 00 00 00 00 00 02 00 00 00 00 00 b2 00 34 00 5b 02 20 06 24 01 06 9c 02 00 00 80 01 00 fe 8002 00 1b 05 30 a7 2b 03 02 00 00 00 80 84 1e 00 cc 07 00 42 80 84 1e 00 cc 07 00 42 a3 03 20 02 24 01 2c 01");
        buffer[40] = this.ConnectionTimeoutMultiplier;
        System.arraycopy(BitConverter.GetBytes((short)(2 + connectionID)), 0, buffer, 32, 2);
        return buffer;
    }

    private byte[] GetAttributeAll() {
        return SoftBasic.HexStringToBytes("00 00 00 00 00 00 02 00 00 00 00 00 b2 00 06 00 01 02 20 01 24 01");
    }

    public static OperateResultExThree<byte[], Short, Boolean> ExtractActualData(byte[] response, boolean isRead) {
        short dataType;
        boolean hasMoreData;
        ByteArrayOutputStream data;
        block28: {
            int count;
            int offset;
            block29: {
                block27: {
                    data = new ByteArrayOutputStream();
                    offset = 42;
                    hasMoreData = false;
                    dataType = 0;
                    count = Utilities.getUShort(response, offset);
                    if (Utilities.getInt(response, 46) != 138) break block27;
                    offset = 50;
                    int dataCount = Utilities.getUShort(response, offset);
                    for (int i = 0; i < dataCount; ++i) {
                        int offsetStart = Utilities.getUShort(response, offset + 2 + i * 2) + offset;
                        int offsetEnd = i == dataCount - 1 ? response.length : Utilities.getUShort(response, offset + 4 + i * 2) + offset;
                        int err = Utilities.getUShort(response, offsetStart + 2);
                        switch (err) {
                            case 4: {
                                return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley04());
                            }
                            case 5: {
                                return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley05());
                            }
                            case 6: {
                                if (response[offset + 2] != -46 && response[offset + 2] != -52) break;
                                return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley06());
                            }
                            case 10: {
                                return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley0A());
                            }
                            case 19: {
                                return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley13());
                            }
                            case 28: {
                                return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley1C());
                            }
                            case 30: {
                                return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley1E());
                            }
                            case 38: {
                                return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley26());
                            }
                            case 0: {
                                break;
                            }
                            default: {
                                return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.UnknownError());
                            }
                        }
                        if (!isRead) continue;
                        for (int j = offsetStart + 6; j < offsetEnd; ++j) {
                            data.write(response[j]);
                        }
                    }
                    break block28;
                }
                byte err = response[offset + 6];
                switch (err) {
                    case 4: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley04());
                    }
                    case 5: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley05());
                    }
                    case 6: {
                        hasMoreData = true;
                        break;
                    }
                    case 10: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley0A());
                    }
                    case 19: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley13());
                    }
                    case 28: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley1C());
                    }
                    case 30: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley1E());
                    }
                    case 38: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley26());
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.UnknownError());
                    }
                }
                if (response[offset + 4] == -51 || response[offset + 4] == -45) {
                    return OperateResultExThree.CreateSuccessResult(data.toByteArray(), dataType, hasMoreData);
                }
                if (response[offset + 4] != -52 && response[offset + 4] != -46) break block29;
                for (int i = offset + 10; i < offset + 2 + count; ++i) {
                    data.write(response[i]);
                }
                dataType = (short)Utilities.getUShort(response, offset + 8);
                break block28;
            }
            if (response[offset + 4] != -43) break block28;
            for (int i = offset + 8; i < offset + 2 + count; ++i) {
                data.write(response[i]);
            }
        }
        return OperateResultExThree.CreateSuccessResult(data.toByteArray(), dataType, hasMoreData);
    }
}

