/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Panasonic;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.IMessage.SpecifiedCharacterMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.DataFormat;
import HslCommunication.Core.Transfer.RegularByteTransform;
import HslCommunication.Core.Types.HslHelper;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.Profinet.Panasonic.PanasonicHelper;
import HslCommunication.StringResources;

public class PanasonicMewtocolOverTcp
extends NetworkDeviceBase {
    private int Station = -18;

    public PanasonicMewtocolOverTcp(int station) {
        this.setByteTransform(new RegularByteTransform());
        this.Station = station;
        this.getByteTransform().setDataFormat(DataFormat.DCBA);
    }

    public PanasonicMewtocolOverTcp(String ipAddress, int port, byte station) {
        this(station);
        this.setIpAddress(ipAddress);
        this.setPort(port);
    }

    @Override
    protected INetMessage GetNewNetMessage() {
        return new SpecifiedCharacterMessage(13);
    }

    public int getStation() {
        return this.Station;
    }

    public void setStation(int station) {
        this.Station = station;
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        int station = this.getStation();
        OperateResultExTwo<Integer, String> extra = HslHelper.ExtractParameter(address, "s", this.getStation());
        if (extra.IsSuccess) {
            station = (Integer)extra.Content1;
            address = (String)extra.Content2;
        }
        OperateResultExOne<byte[]> command = PanasonicHelper.BuildReadCommand(station, address, length);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        return PanasonicHelper.ExtraActualData((byte[])read.Content);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        int station = this.getStation();
        OperateResultExTwo<Integer, String> extra = HslHelper.ExtractParameter(address, "s", this.getStation());
        if (extra.IsSuccess) {
            station = (Integer)extra.Content1;
            address = (String)extra.Content2;
        }
        OperateResultExOne<byte[]> command = PanasonicHelper.BuildWriteCommand(station, address, value);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        return PanasonicHelper.ExtraActualData((byte[])read.Content);
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        int station = this.getStation();
        OperateResultExTwo<Integer, String> extractParameter = HslHelper.ExtractParameter(address, "s", this.getStation());
        if (extractParameter.IsSuccess) {
            station = (Integer)extractParameter.Content1;
            address = (String)extractParameter.Content2;
        }
        OperateResultExTwo<String, Integer> analysis = PanasonicHelper.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        OperateResultExOne<byte[]> command = PanasonicHelper.BuildReadCommand(station, address, length);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResultExOne<byte[]> extra = PanasonicHelper.ExtraActualData((byte[])read.Content);
        if (!extra.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(extra);
        }
        return OperateResultExOne.CreateSuccessResult(SoftBasic.BoolArraySelectMiddle(SoftBasic.ByteToBoolArray((byte[])extra.Content), (Integer)analysis.Content2 % 16, length));
    }

    @Override
    public OperateResultExOne<Boolean> ReadBool(String address) {
        int station = this.getStation();
        OperateResultExTwo<Integer, String> extra = HslHelper.ExtractParameter(address, "s", this.getStation());
        if (extra.IsSuccess) {
            station = (Integer)extra.Content1;
            address = (String)extra.Content2;
        }
        OperateResultExOne<byte[]> command = PanasonicHelper.BuildReadOneCoil(station, address);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return PanasonicHelper.ExtraActualBool((byte[])read.Content);
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        int station = this.getStation();
        OperateResultExTwo<Integer, String> extra = HslHelper.ExtractParameter(address, "s", this.getStation());
        if (extra.IsSuccess) {
            station = (Integer)extra.Content1;
            address = (String)extra.Content2;
        }
        OperateResultExTwo<String, Integer> analysis = PanasonicHelper.AnalysisAddress(address);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        if ((Integer)analysis.Content2 % 16 != 0) {
            return new OperateResult(StringResources.Language.PanasonicAddressBitStartMulti16());
        }
        if (values.length % 16 != 0) {
            return new OperateResult(StringResources.Language.PanasonicBoolLengthMulti16());
        }
        byte[] buffer = SoftBasic.BoolArrayToByte(values);
        OperateResultExOne<byte[]> command = PanasonicHelper.BuildWriteCommand(station, address, buffer);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        return PanasonicHelper.ExtraActualData((byte[])read.Content);
    }

    @Override
    public OperateResult Write(String address, boolean value) {
        int station = this.getStation();
        OperateResultExTwo<Integer, String> extra = HslHelper.ExtractParameter(address, "s", this.getStation());
        if (extra.IsSuccess) {
            station = (Integer)extra.Content1;
            address = (String)extra.Content2;
        }
        OperateResultExOne<byte[]> command = PanasonicHelper.BuildWriteOneCoil(station, address, value);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        return PanasonicHelper.ExtraActualData((byte[])read.Content);
    }

    @Override
    public String toString() {
        return "PanasonicMewtocolOverTcp[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

