/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESUtil {
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final String KEY_ALGORITHM = "AES";
    private static final String AES_ECB_PADDING = "AES/ECB/PKCS5Padding";
    private static final String AES_CBC_PADDING = "AES/CBC/PKCS5Padding";

    public static byte[] decryptByCBC(byte[] content, byte[] key, byte[] initVector) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, KEY_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(initVector);
            Cipher cipher = Cipher.getInstance(AES_CBC_PADDING);
            cipher.init(2, (Key)keySpec, iv);
            return cipher.doFinal(content);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptByCBC(byte[] content, byte[] key, byte[] initVector) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, KEY_ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(initVector);
            Cipher cipher = Cipher.getInstance(AES_CBC_PADDING);
            cipher.init(1, (Key)keySpec, iv);
            return cipher.doFinal(content);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decryptByECB(byte[] content, byte[] key) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(AES_ECB_PADDING);
            cipher.init(2, keySpec);
            return cipher.doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] encryptByECB(byte[] content, byte[] key) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(key, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(AES_ECB_PADDING);
            cipher.init(1, keySpec);
            return cipher.doFinal(content);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decodeByCBC(String content, String key, String initVector) {
        AESUtil.checkParamsOfCBC(content, key, initVector);
        byte[] decryptFrom = AESUtil.parseHexStr2Byte(content);
        byte[] decryptResult = AESUtil.decryptByCBC(decryptFrom, key.getBytes(), initVector.getBytes());
        return new String(decryptResult);
    }

    public static String encodeByCBC(String content, String key, String initVector) {
        AESUtil.checkParamsOfCBC(content, key, initVector);
        byte[] encryptResult = null;
        try {
            encryptResult = AESUtil.encryptByCBC(content.getBytes(DEFAULT_CHARSET), key.getBytes(), initVector.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String encryptResultStr = AESUtil.parseByte2HexStr(encryptResult);
        return encryptResultStr;
    }

    public static String encodeByECB(String content, String key) {
        AESUtil.checkContentAndKey(content, key);
        try {
            byte[] encrypted = AESUtil.encryptByECB(content.getBytes(DEFAULT_CHARSET), key.getBytes(DEFAULT_CHARSET));
            return new Base64().encodeToString(encrypted);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decodeByECB(String content, String key) {
        AESUtil.checkContentAndKey(content, key);
        try {
            byte[] result = AESUtil.decryptByECB(Base64.decodeBase64((String)content), key.getBytes(DEFAULT_CHARSET));
            return new String(result, DEFAULT_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() >> 1];
        for (int i = 0; i < hexStr.length() >> 1; ++i) {
            int high = Integer.parseInt(hexStr.substring(i << 1, (i << 1) + 1), 16);
            int low = Integer.parseInt(hexStr.substring((i << 1) + 1, i + 1 << 1), 16);
            result[i] = (byte)((high << 4) + low);
        }
        return result;
    }

    private static void checkParamsOfCBC(String content, String key, String initVector) {
        AESUtil.checkContentAndKey(content, key);
        if (StringUtil.isEmpty(initVector)) {
            throw new NullPointerException("The init Vector can't be null or empty.");
        }
    }

    private static void checkContentAndKey(String content, String key) {
        if (StringUtil.isEmpty(content)) {
            throw new NullPointerException("The string to be encrypted cannot be null.");
        }
        if (StringUtil.isEmpty(key)) {
            throw new NullPointerException("The key can't be null or empty.");
        }
        if (key.length() != 16) {
            throw new RuntimeException("The length of key must be 16 while use AES CBC mode.");
        }
    }

    private static SecretKeySpec getSecretKey(String key) {
        try {
            return new SecretKeySpec(key.getBytes(DEFAULT_CHARSET), KEY_ALGORITHM);
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

