/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String SERIALNO_PATTERN = "yyyyMMddHHmmssSSS";
    private static final char UNDERLINE = '_';

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim()) || "null".equals(str.trim()) || "NaN".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isSameCharacter(String s) {
        s = s.toUpperCase();
        String character = s.substring(0, 1);
        String replace = "";
        String test = s.replace(character, replace);
        return "".equals(test);
    }

    public static boolean isContinuityCharacter(String s) {
        boolean continuity = true;
        char[] data = s.toCharArray();
        for (int i = 0; i < data.length - 1; ++i) {
            int a = Integer.parseInt(data[i] + "");
            int b = Integer.parseInt(data[i + 1] + "");
            continuity = continuity && (a + 1 == b || a - 1 == b);
        }
        return continuity;
    }

    public static String getCharCode(String str) {
        String temp = "";
        for (int i = 0; i < temp.length(); ++i) {
            temp = temp + Integer.toHexString(str.charAt(i)) + "nbsp;";
        }
        return temp;
    }

    public static String convertTo8859(String str) {
        String strOutPut = "";
        try {
            byte[] tempStrByte = str.getBytes("ISO-8859-1");
            strOutPut = new String(tempStrByte);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strOutPut;
    }

    public static String capitalise(String fieldName) {
        return fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String trim(String sourceStr) {
        if (StringUtil.isEmpty(sourceStr)) {
            return null;
        }
        return sourceStr.replaceAll(" ", "");
    }

    public static String filterStr(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        str = str.replaceAll(";", "");
        str = str.replaceAll("%", "");
        str = str.replaceAll("--", "");
        str = str.replaceAll("/", "");
        str = str.replaceAll("=", "");
        str = str.replaceAll("'", "&#39;");
        str = str.replaceAll("\\(", "&#40;").replace("\\)", "&#41;");
        str = str.replaceAll("<", "&lt");
        str = str.replaceAll(">", "&gt");
        return str;
    }

    public static String cleanSqlWildCharater(String str) {
        if (StringUtil.isEmpty(str)) {
            return str;
        }
        str = str.replaceAll("%", "invalid character");
        str = str.replaceAll("_", "invalid character");
        str = str.replaceAll("=", "invalid character");
        return str;
    }

    public static String cleanXSS(String value) {
        if (null == value) {
            return value;
        }
        value = value.replaceAll("\\bselect\\b", "invalid character");
        value = value.replaceAll("\\band\\b", "invalid character");
        value = value.replaceAll("\\bor\\b", "invalid character");
        value = value.replaceAll("\\bdelete\\b", "invalid character");
        value = value.replaceAll("\\bjoin\\b", "invalid character");
        value = value.replaceAll("\\bdrop\\b", "invalid character");
        value = value.replaceAll("\\+", "&#43;");
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("%", "&#37;");
        value = value.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        value = value.replaceAll("%3C", "&lt;").replaceAll("%3E", "&gt;");
        value = value.replaceAll("\\(", "&#40;").replaceAll("\\)", "&#41;");
        value = value.replaceAll("%28", "&#40;").replaceAll("%29", "&#41;");
        value = value.replaceAll("'", "&#39;");
        value = value.replaceAll("alert", "invalid character");
        value = value.replaceAll("eval\\((.*)\\)", "invalid character");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("<\\s*script", "invalid character");
        value = value.replaceAll("location.href", "invalid character");
        return value;
    }

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int length = param.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int length = param.length();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= length) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCapitalizeCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = StringUtil.underlineToCamel(s);
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String firstToUpperCase(String param) {
        char[] cs = param.toCharArray();
        if (cs[0] > '`' && cs[0] < '{') {
            cs[0] = (char)(cs[0] - 32);
        }
        return String.valueOf(cs);
    }

    public static String firstToLowerCase(String param) {
        char[] cs = param.toCharArray();
        if (cs[0] > '@' && cs[0] < '[') {
            cs[0] = (char)(cs[0] + 32);
        }
        return String.valueOf(cs);
    }

    public static String createSerialNo() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat(SERIALNO_PATTERN);
        return format.format(cal.getTime());
    }

    public static String urlDecode(String str) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String ios8859ToUtf8(String str) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        try {
            return new String(str.getBytes("iso8859-1"), "utf-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String binaryString2hexString(String bString) {
        if (bString == null || bString.equals("") || bString.length() % 8 != 0) {
            return null;
        }
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < bString.length(); i += 4) {
            int iTmp = 0;
            for (int j = 0; j < 4; ++j) {
                iTmp += Integer.parseInt(bString.substring(i + j, i + j + 1)) << 4 - j - 1;
            }
            tmp.append(Integer.toHexString(iTmp));
        }
        return tmp.toString();
    }

    public static String hexString2binaryString(String hexString) {
        if (hexString == null || hexString.length() % 2 != 0) {
            return null;
        }
        String bString = "";
        for (int i = 0; i < hexString.length(); ++i) {
            String tmp = "0000" + Integer.toBinaryString(Integer.parseInt(hexString.substring(i, i + 1), 16));
            bString = bString + tmp.substring(tmp.length() - 4);
        }
        return bString;
    }

    private static String fillStringByArgs(String str, String[] arr) {
        Matcher m = Pattern.compile("\\{(\\d)\\}").matcher(str);
        while (m.find()) {
            str = str.replace(m.group(), arr[Integer.parseInt(m.group(1))]);
        }
        return str;
    }

    public static String trimBlank(String str) {
        if (StringUtil.isEmpty(str)) {
            return null;
        }
        return str.replaceAll("^[\u3000 ]+|[\u3000 ]+$", "");
    }

    public static int length(String str) {
        if (StringUtil.isEmpty(str)) {
            return 0;
        }
        return str.length();
    }

    public static String createRandom(int length) {
        double a = Math.pow(10.0, length - 1);
        int num = (int)((Math.random() * 9.0 + 1.0) * a);
        return String.valueOf(num);
    }

    public static String removeQuotes(String str) {
        if (StringUtil.isNotEmpty(str)) {
            return str.replace("'", "").replace("\"", "");
        }
        return "";
    }

    public static String replaceHtml(String html) {
        if (StringUtil.isEmpty(html)) {
            return "";
        }
        String regEx = "<.+?>";
        Pattern p = Pattern.compile(regEx);
        Matcher m = p.matcher(html);
        String s = m.replaceAll("");
        return s;
    }

    public static String replaceMobileHtml(String html) {
        if (html == null) {
            return "";
        }
        return html.replaceAll("<([a-z]+?)\\s+?.*?>", "<$1>");
    }

    public static String getChinese(String str) {
        String reg = "[^\u4e00-\u9fa5]";
        str = str.replaceAll(reg, "");
        return str;
    }

    public static String getNotChinese(String str) {
        String reg = "[^A-Za-z0-9_]";
        str = str.replaceAll(reg, "");
        return str;
    }

    public static String removePrefix(String str, String prefix) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(prefix)) {
            return str;
        }
        if (str.startsWith(prefix)) {
            return str.substring(prefix.length());
        }
        return str;
    }

    public static String[] split(String str, String regex) {
        if (null != str) {
            return str.split(regex);
        }
        return null;
    }

    public static String seqNumLeftPadZero(long seq, int len) {
        String b = String.valueOf(seq);
        StringBuilder builder = new StringBuilder();
        int rest = len - b.length();
        for (int i = 0; i < rest; ++i) {
            builder.append("0");
        }
        builder.append(b);
        return builder.toString();
    }
}

