/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.builder;

import com.power.common.util.CollectionUtil;
import com.power.common.util.JsonFormatUtil;
import com.power.common.util.StringUtil;
import com.power.doc.model.ApiConfig;
import com.power.doc.model.ApiDoc;
import com.power.doc.model.ApiMethodDoc;
import com.power.doc.model.ApiReqHeader;
import com.power.doc.model.CustomRespField;
import com.power.doc.model.SourcePath;
import com.power.doc.utils.DocClassUtil;
import com.power.doc.utils.DocUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SourceBuilder {
    private static final String IGNORE_TAG = "ignore";
    private static final String GET_MAPPING = "GetMapping";
    private static final String POST_MAPPING = "PostMapping";
    private static final String PUT_MAPPING = "PutMapping";
    private static final String DELETE_MAPPING = "DeleteMapping";
    private static final String REQUEST_MAPPING = "RequestMapping";
    private static final String REQUEST_BODY = "RequestBody";
    private static final String REQUEST_PARAM = "RequestParam";
    private static final String JSON_CONTENT_TYPE = "application/json; charset=utf-8";
    private static final String MAP_CLASS = "java.util.Map";
    public Map<String, JavaClass> javaFilesMap = new HashMap<String, JavaClass>();
    private JavaProjectBuilder builder;
    private Collection<JavaClass> javaClasses;
    private boolean isStrict;
    private String packageMatch;
    private List<ApiReqHeader> headers;
    private String appUrl;
    public Map<String, CustomRespField> fieldMap = new HashMap<String, CustomRespField>();

    public SourceBuilder(boolean isStrict) {
        this.loadJavaFiles(null);
        this.isStrict = isStrict;
    }

    public SourceBuilder(ApiConfig config) {
        if (null == config) {
            throw new NullPointerException("ApiConfig can't be null.");
        }
        this.appUrl = StringUtil.isEmpty((String)config.getServerUrl()) ? "http://{server}" : config.getServerUrl();
        this.packageMatch = config.getPackageFilters();
        this.isStrict = config.isStrict();
        this.loadJavaFiles(config.getSourcePaths());
        this.headers = config.getRequestHeaders();
        if (CollectionUtil.isNotEmpty(config.getCustomResponseFields())) {
            for (CustomRespField field : config.getCustomResponseFields()) {
                this.fieldMap.put(field.getName(), field);
            }
        }
    }

    private void loadJavaFiles(List<SourcePath> paths) {
        JavaProjectBuilder builder = new JavaProjectBuilder();
        if (CollectionUtil.isEmpty(paths)) {
            builder.addSourceTree(new File("src/main/java"));
        } else {
            for (SourcePath path : paths) {
                String strPath;
                if (null == path || !StringUtil.isNotEmpty((String)(strPath = path.getPath()))) continue;
                strPath = strPath.replace("\\", "/");
                builder.addSourceTree(new File(strPath));
            }
        }
        this.builder = builder;
        this.javaClasses = builder.getClasses();
        for (JavaClass cls : this.javaClasses) {
            this.javaFilesMap.put(cls.getFullyQualifiedName(), cls);
        }
    }

    private int checkController(JavaClass cls) {
        int counter = 0;
        List classAnnotations = cls.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getName();
            if (!"Controller".equals(annotationName) && !"RestController".equals(annotationName)) continue;
            ++counter;
        }
        return counter;
    }

    private boolean isRestController(JavaClass cls) {
        List classAnnotations = cls.getAnnotations();
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getName();
            if (!"RestController".equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public List<ApiDoc> getControllerApiData() {
        ArrayList<ApiDoc> apiDocList = new ArrayList<ApiDoc>();
        for (JavaClass cls : this.javaClasses) {
            ApiDoc apiDoc;
            List<ApiMethodDoc> apiMethodDocs;
            int counter = this.checkController(cls);
            if (counter <= 0) continue;
            String controllerName = cls.getName();
            if (StringUtil.isNotEmpty((String)this.packageMatch)) {
                if (!DocUtil.isMatch(this.packageMatch, cls.getCanonicalName())) continue;
                apiMethodDocs = this.buildControllerMethod(cls);
                apiDoc = new ApiDoc();
                apiDoc.setDesc(cls.getComment());
                apiDoc.setName(controllerName);
                apiDoc.setList(apiMethodDocs);
                apiDocList.add(apiDoc);
                continue;
            }
            apiMethodDocs = this.buildControllerMethod(cls);
            apiDoc = new ApiDoc();
            apiDoc.setName(controllerName);
            apiDoc.setDesc(cls.getComment());
            apiDoc.setList(apiMethodDocs);
            apiDocList.add(apiDoc);
        }
        return apiDocList;
    }

    public ApiDoc getSingleControllerApiData(String controller) {
        if (!this.javaFilesMap.containsKey(controller)) {
            throw new RuntimeException("Unable to find " + controller + " in your project");
        }
        JavaClass cls = this.builder.getClassByName(controller);
        int counter = this.checkController(cls);
        if (counter > 0) {
            String controllerName = cls.getName();
            List<ApiMethodDoc> apiMethodDocs = this.buildControllerMethod(cls);
            ApiDoc apiDoc = new ApiDoc();
            apiDoc.setList(apiMethodDocs);
            apiDoc.setName(controllerName);
            return apiDoc;
        }
        throw new RuntimeException(controller + " is not a Controller in your project");
    }

    public List<ApiMethodDoc> buildControllerMethod(JavaClass cls) {
        List classAnnotations = cls.getAnnotations();
        String baseUrl = null;
        for (JavaAnnotation annotation : classAnnotations) {
            String annotationName = annotation.getType().getName();
            if (!REQUEST_MAPPING.equals(annotationName)) continue;
            baseUrl = annotation.getNamedParameter("value").toString();
            baseUrl = baseUrl.replaceAll("\"", "");
        }
        List methods = cls.getMethods();
        ArrayList<ApiMethodDoc> methodDocList = new ArrayList<ApiMethodDoc>(methods.size());
        for (JavaMethod method : methods) {
            if (StringUtil.isEmpty((String)method.getComment()) && this.isStrict) {
                throw new RuntimeException("Unable to find comment for method " + method.getName() + " in " + cls.getCanonicalName());
            }
            ApiMethodDoc apiMethodDoc = new ApiMethodDoc();
            apiMethodDoc.setDesc(method.getComment());
            List annotations = method.getAnnotations();
            String url = null;
            String methodType = null;
            int methodCounter = 0;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getName();
                if (REQUEST_MAPPING.equals(annotationName)) {
                    url = null == annotation.getNamedParameter("value") ? "/" : annotation.getNamedParameter("value").toString();
                    methodType = null != annotation.getNamedParameter("method") ? ("RequestMethod.POST".equals(methodType = annotation.getNamedParameter("method").toString()) ? "POST" : ("RequestMethod.GET".equals(methodType) ? "GET" : ("RequestMethod.PUT".equals(methodType) ? "PUT" : ("RequestMethod.DELETE".equals(methodType) ? "DELETE" : "GET")))) : "GET";
                    ++methodCounter;
                    continue;
                }
                if (GET_MAPPING.equals(annotationName)) {
                    url = null == annotation.getNamedParameter("value") ? "/" : annotation.getNamedParameter("value").toString();
                    methodType = "GET";
                    ++methodCounter;
                    continue;
                }
                if (POST_MAPPING.equals(annotationName)) {
                    url = null == annotation.getNamedParameter("value") ? "/" : annotation.getNamedParameter("value").toString();
                    methodType = "POST";
                    ++methodCounter;
                    continue;
                }
                if (PUT_MAPPING.equals(annotationName)) {
                    url = null == annotation.getNamedParameter("value") ? "/" : annotation.getNamedParameter("value").toString();
                    methodType = "PUT";
                    ++methodCounter;
                    continue;
                }
                if (!DELETE_MAPPING.equals(annotationName)) continue;
                url = null == annotation.getNamedParameter("value") ? "/" : annotation.getNamedParameter("value").toString();
                methodType = "DELETE";
                ++methodCounter;
            }
            if (methodCounter <= 0 || null != method.getTagByName(IGNORE_TAG)) continue;
            url = url.replaceAll("\"", "").trim();
            apiMethodDoc.setType(methodType);
            if (StringUtil.isNotEmpty((String)baseUrl)) {
                baseUrl = StringUtils.equals((CharSequence)"/", (CharSequence)baseUrl.subSequence(0, 1)) ? baseUrl : "/" + baseUrl;
                apiMethodDoc.setUrl(this.appUrl + (baseUrl + "/" + url).replace("//", "/"));
            } else {
                url = StringUtils.equals((CharSequence)"/", (CharSequence)url.subSequence(0, 1)) ? url : "/" + url;
                apiMethodDoc.setUrl(this.appUrl + url.replace("//", "/"));
            }
            String comment = this.getCommentTag(method, "param", cls.getCanonicalName());
            apiMethodDoc.setRequestParams(comment);
            String requestJson = this.buildReqJson(method, apiMethodDoc);
            apiMethodDoc.setRequestUsage(JsonFormatUtil.formatJson((String)requestJson));
            apiMethodDoc.setResponseUsage(this.buildReturnJson(method, this.fieldMap));
            String str = this.buildMethodReturn(method, cls.getGenericFullyQualifiedName());
            apiMethodDoc.setResponseParams(str);
            apiMethodDoc.setHeaders(this.createHeaders(this.headers));
            methodDocList.add(apiMethodDoc);
        }
        return methodDocList;
    }

    private String createHeaders(List<ApiReqHeader> headers) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtil.isEmpty(headers)) {
            headers = new ArrayList<ApiReqHeader>(0);
        }
        for (ApiReqHeader header : headers) {
            builder.append(header.getName()).append("|");
            builder.append(header.getType()).append("|");
            builder.append(header.getDesc()).append("\n");
        }
        return builder.toString();
    }

    private String buildMethodReturn(JavaMethod method, String controllerName) {
        String returnType = method.getReturnType().getGenericCanonicalName();
        String typeName = method.getReturnType().getFullyQualifiedName();
        if (DocClassUtil.isMvcIgnoreParams(typeName)) {
            if ("org.springframework.web.servlet.ModelAndView".equals(typeName)) {
                return null;
            }
            throw new RuntimeException("smart-doc can't support " + typeName + " as method return in " + controllerName);
        }
        if (DocClassUtil.isPrimitive(typeName)) {
            return this.primitiveReturnRespComment(DocClassUtil.processTypeNameForParams(typeName));
        }
        if (DocClassUtil.isCollection(typeName)) {
            if (returnType.contains("<")) {
                String gicName = returnType.substring(returnType.indexOf("<") + 1, returnType.lastIndexOf(">"));
                if (DocClassUtil.isPrimitive(gicName)) {
                    return this.primitiveReturnRespComment("array of " + DocClassUtil.processTypeNameForParams(gicName));
                }
                String param = this.buildParams(gicName, "", 0, null, this.fieldMap, true);
                return param;
            }
            return null;
        }
        if (DocClassUtil.isMap(typeName)) {
            String[] keyValue = DocClassUtil.getMapKeyValueType(returnType);
            if (keyValue.length == 0) {
                return null;
            }
            if (DocClassUtil.isPrimitive(keyValue[1])) {
                return this.primitiveReturnRespComment("key value");
            }
            String param = this.buildParams(keyValue[1], "", 0, null, this.fieldMap, true);
            return param;
        }
        if (StringUtil.isNotEmpty((String)returnType)) {
            String param = this.buildParams(returnType, "", 0, null, this.fieldMap, true);
            return param;
        }
        return null;
    }

    private String buildParams(String className, String pre, int i, String isRequired, Map<String, CustomRespField> responseFieldMap, boolean isResp) {
        StringBuilder params0 = new StringBuilder();
        String simpleName = DocClassUtil.getSimpleName(className);
        String[] globGicName = DocClassUtil.getSimpleGicName(className);
        JavaClass cls = this.builder.getClassByName(simpleName);
        List<JavaField> fields = this.getFields(cls, 0);
        int n = 0;
        if (DocClassUtil.isPrimitive(simpleName)) {
            params0.append(this.primitiveReturnRespComment(DocClassUtil.processTypeNameForParams(simpleName)));
        } else if (DocClassUtil.isCollection(simpleName) || DocClassUtil.isArray(simpleName)) {
            if (!DocClassUtil.isCollection(globGicName[0])) {
                String gicName = globGicName[0];
                if (DocClassUtil.isArray(gicName)) {
                    gicName = gicName.substring(0, gicName.indexOf("["));
                }
                params0.append(this.buildParams(gicName, pre, i + 1, isRequired, responseFieldMap, isResp));
            }
        } else if (DocClassUtil.isMap(simpleName)) {
            if (globGicName.length == 2) {
                params0.append(this.buildParams(globGicName[1], pre, i + 1, isRequired, responseFieldMap, isResp));
            }
        } else if ("java.lang.Object".equals(className)) {
            params0.append(pre + "any object|object|");
            if (StringUtil.isEmpty((String)isRequired)) {
                params0.append("any object.").append("\n");
            } else {
                params0.append("any object.").append("|").append(false).append("\n");
            }
        } else {
            block0: for (JavaField field : fields) {
                String gName;
                CustomRespField customResponseField;
                String fieldName = field.getName();
                if ("serialVersionUID".equals(fieldName)) continue;
                String typeSimpleName = field.getType().getSimpleName();
                String subTypeName = field.getType().getFullyQualifiedName();
                String fieldGicName = field.getType().getGenericCanonicalName();
                List javaAnnotations = field.getAnnotations();
                String strRequired = "false";
                int annotationCounter = 0;
                for (Object annotation : javaAnnotations) {
                    if ("JsonIgnore".equals(annotation.getType().getSimpleName()) && isResp) continue block0;
                    if ("JSONField".equals(annotation.getType().getSimpleName()) && isResp) {
                        if (null != annotation.getProperty("serialize")) {
                            if (!"false".equals(annotation.getProperty("serialize").toString())) continue;
                            continue block0;
                        }
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = annotation.getProperty("name").toString().replace("\"", "");
                        continue;
                    }
                    if ("JsonProperty".equals(annotation.getType().getSimpleName()) && isResp) {
                        if (null == annotation.getProperty("value")) continue;
                        fieldName = annotation.getProperty("value").toString().replace("\"", "");
                        continue;
                    }
                    if (!DocClassUtil.isJSR303Required(annotation.getType().getSimpleName())) continue;
                    strRequired = "true";
                    ++annotationCounter;
                    break;
                }
                if (annotationCounter < 1) {
                    Object annotation;
                    List paramTags = field.getTags();
                    annotation = paramTags.iterator();
                    while (annotation.hasNext()) {
                        DocletTag docletTag = (DocletTag)annotation.next();
                        if (!DocClassUtil.isRequiredTag(docletTag.getName())) continue;
                        strRequired = "true";
                        break;
                    }
                }
                String comment = null != (customResponseField = responseFieldMap.get(field.getName())) && StringUtil.isNotEmpty((String)customResponseField.getDesc()) ? customResponseField.getDesc() : field.getComment();
                if (DocClassUtil.isPrimitive(subTypeName)) {
                    params0.append(pre);
                    params0.append(fieldName).append("|").append(DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase())).append("|");
                    if (StringUtil.isNotEmpty((String)comment)) {
                        if (StringUtil.isEmpty((String)isRequired)) {
                            params0.append(comment).append("\n");
                            continue;
                        }
                        params0.append(comment).append("|").append(strRequired).append("\n");
                        continue;
                    }
                    if (StringUtil.isEmpty((String)isRequired)) {
                        params0.append("No comments found.").append("\n");
                        continue;
                    }
                    params0.append("No comments found.").append("|").append(strRequired).append("\n");
                    continue;
                }
                params0.append(pre);
                params0.append(fieldName).append("|").append(DocClassUtil.processTypeNameForParams(typeSimpleName.toLowerCase())).append("|");
                if (StringUtil.isNotEmpty((String)comment)) {
                    if (StringUtil.isEmpty((String)isRequired)) {
                        params0.append(comment).append("\n");
                    } else {
                        params0.append(comment).append("|").append(strRequired).append("\n");
                    }
                } else if (StringUtil.isEmpty((String)isRequired)) {
                    params0.append("No comments found.").append("\n");
                } else {
                    params0.append("No comments found|").append(strRequired).append("\n");
                }
                StringBuilder preBuilder = new StringBuilder();
                for (int j = 0; j < i; ++j) {
                    preBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                }
                preBuilder.append("\u2514\u2500");
                if (DocClassUtil.isMap(subTypeName)) {
                    String gNameTemp = field.getType().getGenericCanonicalName();
                    if (MAP_CLASS.equals(gNameTemp)) {
                        params0.append(preBuilder + "any object|object|any object\n");
                        continue;
                    }
                    String valType = DocClassUtil.getMapKeyValueType(gNameTemp)[1];
                    if (DocClassUtil.isPrimitive(valType)) continue;
                    if (valType.length() == 1) {
                        String gicName = n < globGicName.length ? globGicName[n] : globGicName[globGicName.length - 1];
                        if (DocClassUtil.isPrimitive(gicName) || simpleName.equals(gicName)) continue;
                        params0.append(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                        continue;
                    }
                    params0.append(this.buildParams(valType, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                    continue;
                }
                if (DocClassUtil.isCollection(subTypeName)) {
                    String gNameTemp = field.getType().getGenericCanonicalName();
                    String[] gNameArr = DocClassUtil.getSimpleGicName(gNameTemp);
                    if (gNameArr.length == 0 || DocClassUtil.isPrimitive(gName = DocClassUtil.getSimpleGicName(gNameTemp)[0]) || simpleName.equals(gName) || gName.contains(simpleName)) continue;
                    if (gName.length() == 1) {
                        String gicName;
                        int len = globGicName.length;
                        if (len <= 0 || DocClassUtil.isPrimitive(gicName = n < len ? globGicName[n] : globGicName[len - 1]) || simpleName.equals(gicName)) continue;
                        params0.append(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                        continue;
                    }
                    params0.append(this.buildParams(gName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                    continue;
                }
                if (subTypeName.length() == 1 || "java.lang.Object".equals(subTypeName)) {
                    if (!simpleName.equals(className)) {
                        if (n < globGicName.length) {
                            String gicName = globGicName[n];
                            String simple = DocClassUtil.getSimpleName(gicName);
                            if (!DocClassUtil.isPrimitive(simple)) {
                                if (gicName.contains("<")) {
                                    if (DocClassUtil.isCollection(simple)) {
                                        gName = DocClassUtil.getSimpleGicName(gicName)[0];
                                        if (!DocClassUtil.isPrimitive(gName)) {
                                            params0.append(this.buildParams(gName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                                        }
                                    } else if (DocClassUtil.isMap(simple)) {
                                        String valType = DocClassUtil.getMapKeyValueType(gicName)[1];
                                        if (!DocClassUtil.isPrimitive(valType)) {
                                            params0.append(this.buildParams(valType, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                                        }
                                    } else {
                                        params0.append(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                                    }
                                } else {
                                    params0.append(this.buildParams(gicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                                }
                            }
                        } else {
                            params0.append(this.buildParams(subTypeName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                        }
                    }
                    ++n;
                    continue;
                }
                if (DocClassUtil.isArray(subTypeName)) {
                    if (className.equals(fieldGicName = fieldGicName.substring(0, fieldGicName.indexOf("["))) || DocClassUtil.isPrimitive(fieldGicName)) continue;
                    params0.append(this.buildParams(fieldGicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
                    continue;
                }
                if (simpleName.equals(subTypeName)) continue;
                params0.append(this.buildParams(fieldGicName, preBuilder.toString(), i + 1, isRequired, responseFieldMap, isResp));
            }
        }
        return params0.toString();
    }

    private String primitiveReturnRespComment(String typeName) {
        StringBuilder comments = new StringBuilder();
        comments.append("no param name|").append(typeName).append("|").append("The interface directly returns the ");
        comments.append(typeName).append(" type value.\n");
        return comments.toString();
    }

    private String buildReturnJson(JavaMethod method, Map<String, CustomRespField> responseFieldMap) {
        if ("void".equals(method.getReturnType().getFullyQualifiedName())) {
            return "this api return nothing.";
        }
        String returnType = method.getReturnType().getGenericCanonicalName();
        String typeName = method.getReturnType().getFullyQualifiedName();
        return JsonFormatUtil.formatJson((String)this.buildJson(typeName, returnType, responseFieldMap, true));
    }

    private String buildJson(String typeName, String genericCanonicalName, Map<String, CustomRespField> responseFieldMap, boolean isResp) {
        if (DocClassUtil.isMvcIgnoreParams(typeName)) {
            if ("org.springframework.web.servlet.ModelAndView".equals(typeName)) {
                return "forward or redirect to a page view.";
            }
            return "error restful return.";
        }
        if (DocClassUtil.isPrimitive(typeName)) {
            return DocUtil.jsonValueByType(typeName);
        }
        StringBuilder data0 = new StringBuilder();
        JavaClass cls = this.builder.getClassByName(typeName);
        data0.append("{");
        String[] globGicName = DocClassUtil.getSimpleGicName(genericCanonicalName);
        StringBuilder data = new StringBuilder();
        if (DocClassUtil.isCollection(typeName) || DocClassUtil.isArray(typeName)) {
            String gName;
            data.append("[");
            if (globGicName.length == 0) {
                data.append("{\"object\":\"any object\"}");
                data.append("]");
                return data.toString();
            }
            String gNameTemp = globGicName[0];
            String string = gName = DocClassUtil.isArray(typeName) ? gNameTemp.substring(0, gNameTemp.indexOf("[")) : globGicName[0];
            if ("java.lang.Object".equals(gName)) {
                data.append("{\"waring\":\"You may use java.util.Object instead of display generics in the List\"}");
            } else if (DocClassUtil.isPrimitive(gName)) {
                data.append(DocUtil.jsonValueByType(gName)).append(",");
                data.append(DocUtil.jsonValueByType(gName));
            } else if (gName.contains("<")) {
                String simple = DocClassUtil.getSimpleName(gName);
                String json = this.buildJson(simple, gName, responseFieldMap, isResp);
                data.append(json);
            } else if (DocClassUtil.isCollection(gName)) {
                data.append("\"any object\"");
            } else {
                String json = this.buildJson(gName, gName, responseFieldMap, isResp);
                data.append(json);
            }
            data.append("]");
            return data.toString();
        }
        if (DocClassUtil.isMap(typeName)) {
            String gNameTemp = genericCanonicalName;
            String[] getKeyValType = DocClassUtil.getMapKeyValueType(gNameTemp);
            if (getKeyValType.length == 0) {
                data.append("{\"mapKey\":{}}");
                return data.toString();
            }
            if (!"java.lang.String".equals(getKeyValType[0])) {
                throw new RuntimeException("Map's key can only use String for json,but you use " + getKeyValType[0]);
            }
            String gicName = gNameTemp.substring(gNameTemp.indexOf(",") + 1, gNameTemp.lastIndexOf(">"));
            if ("java.lang.Object".equals(gicName)) {
                data.append("{").append("\"mapKey\":").append("{\"waring\":\"You may use java.util.Object for Map value; smart-doc can't be handle.\"}").append("}");
            } else if (DocClassUtil.isPrimitive(gicName)) {
                data.append("{").append("\"mapKey1\":").append(DocUtil.jsonValueByType(gicName)).append(",");
                data.append("\"mapKey2\":").append(DocUtil.jsonValueByType(gicName)).append("}");
            } else if (gicName.contains("<")) {
                String simple = DocClassUtil.getSimpleName(gicName);
                String json = this.buildJson(simple, gicName, responseFieldMap, isResp);
                data.append("{").append("\"mapKey\":").append(json).append("}");
            } else {
                data.append("{").append("\"mapKey\":").append(this.buildJson(gicName, gNameTemp, responseFieldMap, isResp)).append("}");
            }
            return data.toString();
        }
        if ("java.lang.Object".equals(typeName)) {
            if ("java.lang.Object".equals(typeName)) {
                data.append("{\"object\":\" any object\"},");
            }
        } else {
            List<JavaField> fields = this.getFields(cls, 0);
            int i = 0;
            block0: for (JavaField field : fields) {
                String gicName1;
                String gicName;
                String fieldName = field.getName();
                if ("serialVersionUID".equals(fieldName)) continue;
                List annotations = field.getAnnotations();
                for (JavaAnnotation annotation : annotations) {
                    if ("JsonIgnore".equals(annotation.getType().getSimpleName()) && isResp) continue block0;
                    if ("JSONField".equals(annotation.getType().getSimpleName()) && isResp) {
                        if (null != annotation.getProperty("serialize")) {
                            if (!"false".equals(annotation.getProperty("serialize").toString())) continue;
                            continue block0;
                        }
                        if (null == annotation.getProperty("name")) continue;
                        fieldName = annotation.getProperty("name").toString().replace("\"", "");
                        continue;
                    }
                    if (!"JsonProperty".equals(annotation.getType().getSimpleName()) || !isResp || null == annotation.getProperty("value")) continue;
                    fieldName = annotation.getProperty("value").toString().replace("\"", "");
                }
                String typeSimpleName = field.getType().getSimpleName();
                String subTypeName = field.getType().getFullyQualifiedName();
                String fieldGicName = field.getType().getGenericCanonicalName();
                data0.append("\"").append(fieldName).append("\":");
                if (DocClassUtil.isPrimitive(typeSimpleName)) {
                    CustomRespField customResponseField = responseFieldMap.get(fieldName);
                    if (null != customResponseField) {
                        Object val = customResponseField.getValue();
                        if (null != val) {
                            if ("String".equals(typeSimpleName)) {
                                data0.append("\"").append(val).append("\",");
                                continue;
                            }
                            data0.append(val).append(",");
                            continue;
                        }
                        data0.append(DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName())).append(",");
                        continue;
                    }
                    data0.append(DocUtil.getValByTypeAndFieldName(typeSimpleName, field.getName())).append(",");
                    continue;
                }
                if (DocClassUtil.isCollection(subTypeName) || DocClassUtil.isArray(subTypeName)) {
                    String string = fieldGicName = DocClassUtil.isArray(subTypeName) ? fieldGicName.substring(0, fieldGicName.indexOf("[")) : fieldGicName;
                    if (DocClassUtil.getSimpleGicName(fieldGicName).length == 0) {
                        data0.append("{\"object\":\"any object\"},");
                        continue;
                    }
                    gicName = DocClassUtil.getSimpleGicName(fieldGicName)[0];
                    if ("java.lang.String".equals(gicName)) {
                        data0.append("[").append("\"").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp)).append("\"]").append(",");
                        continue;
                    }
                    if ("java.util.List".equals(gicName)) {
                        data0.append("{\"object\":\"any object\"},");
                        continue;
                    }
                    if (gicName.length() == 1) {
                        if (globGicName.length == 0) {
                            data0.append("{\"object\":\"any object\"},");
                            continue;
                        }
                        String string2 = gicName1 = i < globGicName.length ? globGicName[i] : globGicName[globGicName.length - 1];
                        if ("java.lang.String".equals(gicName1)) {
                            data0.append("[").append("\"").append(this.buildJson(gicName1, gicName1, responseFieldMap, isResp)).append("\"]").append(",");
                            continue;
                        }
                        if (!typeName.equals(gicName1)) {
                            data0.append("[").append(this.buildJson(DocClassUtil.getSimpleName(gicName1), gicName1, responseFieldMap, isResp)).append("]").append(",");
                            continue;
                        }
                        data0.append("[{\"$ref\":\"..\"}]").append(",");
                        continue;
                    }
                    if (!typeName.equals(gicName) && !gicName.contains(typeName)) {
                        if (MAP_CLASS.equals(gicName)) {
                            data0.append("[{\"mapKey\":{}}],");
                            continue;
                        }
                        data0.append("[").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp)).append("]").append(",");
                        continue;
                    }
                    data0.append("[{\"$ref\":\"..\"}]").append(",");
                    continue;
                }
                if (DocClassUtil.isMap(subTypeName)) {
                    if (MAP_CLASS.equals(subTypeName)) {
                        data0.append("{").append("\"mapKey\":{}},");
                        continue;
                    }
                    gicName = fieldGicName.substring(fieldGicName.indexOf(",") + 1, fieldGicName.indexOf(">"));
                    if (gicName.length() == 1) {
                        String string = gicName1 = i < globGicName.length ? globGicName[i] : globGicName[globGicName.length - 1];
                        if ("java.lang.String".equals(gicName1)) {
                            data0.append("{").append("\"mapKey\":\"").append(this.buildJson(gicName1, gicName1, responseFieldMap, isResp)).append("\"},");
                            continue;
                        }
                        if (!typeName.equals(gicName1)) {
                            data0.append("{").append("\"mapKey\":").append(this.buildJson(DocClassUtil.getSimpleName(gicName1), gicName1, responseFieldMap, isResp)).append("},");
                            continue;
                        }
                        data0.append("{\"mapKey\":{}},");
                        continue;
                    }
                    data0.append("{").append("\"mapKey\":").append(this.buildJson(gicName, fieldGicName, responseFieldMap, isResp)).append("},");
                    continue;
                }
                if (subTypeName.length() == 1) {
                    if (!typeName.equals(genericCanonicalName)) {
                        gicName = globGicName[i];
                        if (gicName.contains("<")) {
                            String simple = DocClassUtil.getSimpleName(gicName);
                            data0.append(this.buildJson(simple, gicName, responseFieldMap, isResp)).append(",");
                        } else if (DocClassUtil.isPrimitive(gicName)) {
                            data0.append(DocUtil.jsonValueByType(gicName)).append(",");
                        } else {
                            data0.append(this.buildJson(gicName, gicName, responseFieldMap, isResp)).append(",");
                        }
                    } else {
                        data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                    }
                    ++i;
                    continue;
                }
                if ("java.lang.Object".equals(subTypeName)) {
                    if (i < globGicName.length) {
                        gicName = globGicName[i];
                        if (!typeName.equals(genericCanonicalName)) {
                            if (DocClassUtil.isPrimitive(gicName)) {
                                data0.append("\"").append(this.buildJson(gicName, genericCanonicalName, responseFieldMap, isResp)).append("\",");
                                continue;
                            }
                            data0.append(this.buildJson(gicName, gicName, responseFieldMap, isResp)).append(",");
                            continue;
                        }
                        data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                        continue;
                    }
                    data0.append("{\"waring\":\"You may have used non-display generics.\"},");
                    continue;
                }
                if (typeName.equals(subTypeName)) {
                    data0.append("{\"$ref\":\"...\"}").append(",");
                    continue;
                }
                data0.append(this.buildJson(subTypeName, fieldGicName, responseFieldMap, isResp)).append(",");
            }
        }
        if (data0.toString().contains(",")) {
            data0.deleteCharAt(data0.lastIndexOf(","));
        }
        data0.append("}");
        return data0.toString();
    }

    private String buildReqJson(JavaMethod method, ApiMethodDoc apiMethodDoc) {
        List parameterList = method.getParameters();
        for (JavaParameter parameter : parameterList) {
            JavaType javaType = parameter.getType();
            String simpleTypeName = javaType.getValue();
            String gicTypeName = javaType.getGenericCanonicalName();
            String typeName = javaType.getFullyQualifiedName();
            String paraName = parameter.getName();
            if (DocClassUtil.isMvcIgnoreParams(typeName)) continue;
            List annotations = parameter.getAnnotations();
            int requestBodyCounter = 0;
            for (JavaAnnotation annotation : annotations) {
                String annotationName = annotation.getType().getName();
                if (!REQUEST_BODY.equals(annotationName)) continue;
                ++requestBodyCounter;
                apiMethodDoc.setContentType(JSON_CONTENT_TYPE);
                if (DocClassUtil.isPrimitive(simpleTypeName)) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("{\"").append(paraName).append("\":");
                    builder.append(DocUtil.jsonValueByType(simpleTypeName)).append("}");
                    return builder.toString();
                }
                return this.buildJson(typeName, gicTypeName, this.fieldMap, false);
            }
            if (requestBodyCounter >= true) continue;
            return "smart-doc currently cannot provide examples of parameters for the RequestParam request mode.";
        }
        return "No request parameters are required.";
    }

    private String getCommentTag(JavaMethod javaMethod, String tagName, String className) {
        HashMap<String, CustomRespField> responseFieldMap = new HashMap<String, CustomRespField>();
        List paramTags = javaMethod.getTagsByName(tagName);
        HashMap<String, String> paramTagMap = new HashMap<String, String>();
        for (DocletTag docletTag : paramTags) {
            String pValue;
            String pName;
            String value = docletTag.getValue();
            if (StringUtil.isEmpty((String)value)) {
                throw new RuntimeException("ERROR: #" + javaMethod.getName() + "() - bad @param javadoc from " + className);
            }
            int idx = value.indexOf("\n");
            if (idx > -1) {
                pName = value.substring(0, idx);
                pValue = value.substring(idx + 1);
            } else {
                pName = value.indexOf(" ") > -1 ? value.substring(0, value.indexOf(" ")) : value;
                pValue = value.indexOf(" ") > -1 ? value.substring(value.indexOf(32) + 1) : "No comments found.";
            }
            paramTagMap.put(pName, pValue);
        }
        List parameterList = javaMethod.getParameters();
        if (parameterList.size() > 0) {
            StringBuilder params = new StringBuilder();
            int requestBodyCounter = 0;
            StringBuilder reqBodyParams = new StringBuilder();
            StringBuilder reqParam = new StringBuilder();
            block1: for (JavaParameter parameter : parameterList) {
                List annotations;
                String paramName = parameter.getName();
                String typeName = parameter.getType().getGenericCanonicalName();
                String simpleName = parameter.getType().getValue().toLowerCase();
                String fullTypeName = parameter.getType().getFullyQualifiedName();
                if (DocClassUtil.isMvcIgnoreParams(typeName)) continue;
                if (!paramTagMap.containsKey(paramName) && DocClassUtil.isPrimitive(fullTypeName) && this.isStrict) {
                    throw new RuntimeException("ERROR: Unable to find javadoc @param for actual param \"" + paramName + "\" in method " + javaMethod.getName() + " from " + className);
                }
                String comment = (String)paramTagMap.get(paramName);
                if (StringUtil.isEmpty((String)comment)) {
                    comment = "No comments found.";
                }
                if ((annotations = parameter.getAnnotations()).size() == 0) {
                    if (DocClassUtil.isCollection(fullTypeName) || DocClassUtil.isArray(fullTypeName)) {
                        String[] gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                        String gicName = gicNameArr[0];
                        if (DocClassUtil.isArray(gicName)) {
                            gicName = gicName.substring(0, gicName.indexOf("["));
                        }
                        String typeTemp = "";
                        if (DocClassUtil.isPrimitive(gicName)) {
                            typeTemp = " of " + DocClassUtil.processTypeNameForParams(gicName);
                            reqParam.append(paramName).append("|").append(DocClassUtil.processTypeNameForParams(simpleName)).append(typeTemp).append("|").append(comment).append("|true\n");
                        } else {
                            reqParam.append(paramName).append("|").append(DocClassUtil.processTypeNameForParams(simpleName)).append(typeTemp).append("|").append(comment).append("|true\n");
                            String strPrams = this.buildParams(gicNameArr[0], "\u2514\u2500", 1, "true", responseFieldMap, false);
                            reqParam.append(strPrams);
                        }
                    } else if (DocClassUtil.isPrimitive(simpleName)) {
                        reqParam.append(paramName).append("|").append(DocClassUtil.processTypeNameForParams(simpleName)).append("|").append(comment).append("|true\n");
                    } else if (MAP_CLASS.equals(typeName)) {
                        reqParam.append(paramName).append("|").append("map").append("|").append(comment).append("|true\n");
                    } else {
                        reqParam.append(this.buildParams(fullTypeName, "", 0, "true", responseFieldMap, false));
                    }
                }
                for (JavaAnnotation annotation : annotations) {
                    String annotationName;
                    String required = "true";
                    if (null != annotation.getProperty("required")) {
                        required = annotation.getProperty("required").toString();
                    }
                    if (REQUEST_BODY.equals(annotationName = annotation.getType().getName())) {
                        String[] gicNameArr;
                        if (requestBodyCounter > 0) {
                            throw new RuntimeException("You have use @RequestBody Passing multiple variables  for method " + javaMethod.getName() + " in " + className + ",@RequestBody annotation could only bind one variables.");
                        }
                        if (DocClassUtil.isPrimitive(fullTypeName)) {
                            reqBodyParams.append(paramName).append("|").append(DocClassUtil.processTypeNameForParams(simpleName)).append("|").append(comment).append("|").append(required).append("\n");
                        } else if (DocClassUtil.isCollection(fullTypeName) || DocClassUtil.isArray(fullTypeName)) {
                            gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                            String gicName = gicNameArr[0];
                            if (DocClassUtil.isArray(gicName)) {
                                gicName = gicName.substring(0, gicName.indexOf("["));
                            }
                            if (DocClassUtil.isPrimitive(gicName)) {
                                reqBodyParams.append(paramName).append("|").append(DocClassUtil.processTypeNameForParams(simpleName)).append("|").append(comment).append("|").append(required).append("\n");
                            } else {
                                String strPrams = this.buildParams(gicNameArr[0], "", 0, "true", responseFieldMap, false);
                                reqBodyParams.append(strPrams);
                            }
                        } else if (DocClassUtil.isMap(fullTypeName)) {
                            if (MAP_CLASS.equals(typeName)) {
                                reqParam.append(paramName).append("|").append("map").append("|").append(comment).append("|").append(required).append("\n");
                                continue block1;
                            }
                            gicNameArr = DocClassUtil.getSimpleGicName(typeName);
                            String strPrams = this.buildParams(gicNameArr[1], "", 0, "true", responseFieldMap, false);
                            reqBodyParams.append(strPrams);
                        } else {
                            reqBodyParams.append(this.buildParams(typeName, "", 0, "true", responseFieldMap, false));
                        }
                        ++requestBodyCounter;
                        continue;
                    }
                    reqParam.append(paramName).append("|").append(DocClassUtil.processTypeNameForParams(simpleName)).append("|").append(comment).append("|").append(required).append("\n");
                }
            }
            if (requestBodyCounter > 0) {
                params.append((CharSequence)reqBodyParams);
                return params.toString();
            }
            params.append((CharSequence)reqParam);
            return params.toString();
        }
        return null;
    }

    private List<JavaField> getFields(JavaClass cls1, int i) {
        ArrayList<JavaField> fieldList = new ArrayList<JavaField>();
        if (null == cls1) {
            return fieldList;
        }
        if ("Object".equals(cls1.getSimpleName()) || "Timestamp".equals(cls1.getSimpleName()) || "Date".equals(cls1.getSimpleName()) || "Locale".equals(cls1.getSimpleName())) {
            return fieldList;
        }
        JavaClass pcls = cls1.getSuperJavaClass();
        fieldList.addAll(this.getFields(pcls, i));
        fieldList.addAll(cls1.getFields());
        return fieldList;
    }
}

