/*
 * Decompiled with CFR 0.152.
 */
package com.power.doc.utils;

import com.power.doc.utils.DocUtil;
import java.util.ArrayList;

public class DocClassUtil {
    public static boolean isPrimitive(String type0) {
        String type = type0.contains("java.lang") ? type0.substring(type0.lastIndexOf(".") + 1, type0.length()) : type0;
        switch (type = type.toLowerCase()) {
            case "integer": {
                return true;
            }
            case "int": {
                return true;
            }
            case "long": {
                return true;
            }
            case "double": {
                return true;
            }
            case "float": {
                return true;
            }
            case "short": {
                return true;
            }
            case "bigdecimal": {
                return true;
            }
            case "char": {
                return true;
            }
            case "string": {
                return true;
            }
            case "boolean": {
                return true;
            }
            case "byte": {
                return true;
            }
            case "java.sql.timestamp": {
                return true;
            }
            case "java.util.date": {
                return true;
            }
            case "java.math.bigdecimal": {
                return true;
            }
        }
        return false;
    }

    public static String[] getSimpleGicName(String returnType) {
        if (returnType.contains("<")) {
            String pre = returnType.substring(0, returnType.indexOf("<"));
            if (DocClassUtil.isMap(pre)) {
                return DocClassUtil.getMapKeyValueType(returnType);
            }
            String type = returnType.substring(returnType.indexOf("<") + 1, returnType.lastIndexOf(">"));
            if (DocClassUtil.isCollection(pre)) {
                return type.split(" ");
            }
            String[] arr = type.split(",");
            return DocClassUtil.classNameFix(arr);
        }
        return returnType.split(" ");
    }

    public static String getSimpleName(String gicName) {
        if (gicName.contains("<")) {
            return gicName.substring(0, gicName.indexOf("<"));
        }
        return gicName;
    }

    private static String[] classNameFix(String[] arr) {
        ArrayList<String> classes = new ArrayList<String>();
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        int globIndex = 0;
        for (int i = 0; i < arr.length; ++i) {
            if (classes.size() > 0) {
                int index = classes.size() - 1;
                if (!DocUtil.isClassName((String)classes.get(index))) {
                    if (++globIndex >= arr.length) continue;
                    indexList.add(globIndex);
                    String className = (String)classes.get(index) + "," + arr[globIndex];
                    classes.set(index, className);
                    continue;
                }
                if (++globIndex >= arr.length) continue;
                if (DocUtil.isClassName(arr[globIndex])) {
                    indexList.add(globIndex);
                    classes.add(arr[globIndex]);
                    continue;
                }
                if (indexList.contains(globIndex) || indexList.contains(globIndex + 1)) continue;
                indexList.add(globIndex);
                classes.add(arr[globIndex] + "," + arr[globIndex + 1]);
                indexList.add(++globIndex);
                continue;
            }
            if (DocUtil.isClassName(arr[i])) {
                indexList.add(i);
                classes.add(arr[i]);
                continue;
            }
            if (indexList.contains(i) || indexList.contains(i + 1)) continue;
            globIndex = i + 1;
            classes.add(arr[i] + "," + arr[globIndex]);
            indexList.add(i);
            indexList.add(i + 1);
        }
        return classes.toArray(new String[classes.size()]);
    }

    public static String[] getMapKeyValueType(String gName) {
        if (gName.contains("<")) {
            String[] arr = new String[2];
            String key = gName.substring(gName.indexOf("<") + 1, gName.indexOf(","));
            String value = gName.substring(gName.indexOf(",") + 1, gName.lastIndexOf(">"));
            arr[0] = key;
            arr[1] = value;
            return arr;
        }
        return new String[0];
    }

    public static String processTypeNameForParams(String javaTypeName) {
        if (javaTypeName.length() == 1) {
            return "object";
        }
        if (javaTypeName.contains("[]")) {
            return "array";
        }
        switch (javaTypeName) {
            case "java.lang.String": {
                return "string";
            }
            case "string": {
                return "string";
            }
            case "char": {
                return "char";
            }
            case "java.util.List": {
                return "array";
            }
            case "list": {
                return "array";
            }
            case "java.lang.Integer": {
                return "int";
            }
            case "integer": {
                return "int";
            }
            case "int": {
                return "int";
            }
            case "short": {
                return "int";
            }
            case "java.lang.Short": {
                return "int";
            }
            case "double": {
                return "number";
            }
            case "java.lang.Long": {
                return "number";
            }
            case "long": {
                return "number";
            }
            case "java.lang.Float": {
                return "number";
            }
            case "bigdecimal": {
                return "number";
            }
            case "float": {
                return "number";
            }
            case "java.lang.Boolean": {
                return "boolean";
            }
            case "boolean": {
                return "boolean";
            }
            case "java.util.Byte": {
                return "string";
            }
            case "byte": {
                return "string";
            }
            case "map": {
                return "map";
            }
            case "date": {
                return "string";
            }
        }
        return "object";
    }

    public static boolean isCollection(String type) {
        switch (type) {
            case "java.util.List": {
                return true;
            }
            case "java.util.LinkedList": {
                return true;
            }
            case "java.util.ArrayList": {
                return true;
            }
            case "java.util.Set": {
                return true;
            }
            case "java.util.TreeSet": {
                return true;
            }
            case "java.util.HashSet": {
                return true;
            }
            case "java.util.SortedSet": {
                return true;
            }
            case "java.util.Collection": {
                return true;
            }
            case "java.util.ArrayDeque": {
                return true;
            }
            case "java.util.PriorityQueue": {
                return true;
            }
        }
        return false;
    }

    public static boolean isMap(String type) {
        switch (type) {
            case "java.util.Map": {
                return true;
            }
            case "java.util.SortedMap": {
                return true;
            }
            case "java.util.TreeMap": {
                return true;
            }
            case "java.util.LinkedHashMap": {
                return true;
            }
            case "java.util.HashMap": {
                return true;
            }
            case "java.util.concurrent.ConcurrentHashMap": {
                return true;
            }
            case "java.util.Properties": {
                return true;
            }
            case "java.util.Hashtable": {
                return true;
            }
        }
        return false;
    }

    public static boolean isArray(String type) {
        return type.contains("[]");
    }

    public static boolean isJSR303Required(String annotationSimpleName) {
        switch (annotationSimpleName) {
            case "NotNull": {
                return true;
            }
            case "NotEmpty": {
                return true;
            }
            case "NotBlank": {
                return true;
            }
            case "Required": {
                return true;
            }
        }
        return false;
    }

    public static boolean isRequiredTag(String tagName) {
        switch (tagName) {
            case "required": {
                return true;
            }
        }
        return false;
    }

    public static boolean isMvcIgnoreParams(String paramType) {
        switch (paramType) {
            case "org.springframework.ui.Model": {
                return true;
            }
            case "org.springframework.ui.ModelMap": {
                return true;
            }
            case "org.springframework.web.servlet.ModelAndView": {
                return true;
            }
            case "org.springframework.validation.BindingResult": {
                return true;
            }
            case "javax.servlet.http.HttpServletRequest": {
                return true;
            }
            case "javax.servlet.http.HttpServletResponse": {
                return true;
            }
        }
        return false;
    }
}

