/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.common.algorithm;

import com.github.xingshuangs.iot.common.algorithm.LoopGroupItem;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;

public class LoopGroupAlg {
    private LoopGroupAlg() {
    }

    public static void loopExecute(int actualLength, int maxLength, BiConsumer<Integer, Integer> biConsumer) {
        int len;
        for (int off = 0; off < actualLength; off += len) {
            len = maxLength <= 0 ? actualLength - off : Math.min(maxLength, actualLength - off);
            biConsumer.accept(off, len);
        }
    }

    public static void biLoopExecute(LoopGroupItem item1, LoopGroupItem item2, BiPredicate<LoopGroupItem, LoopGroupItem> biPredicate, BiConsumer<LoopGroupItem, LoopGroupItem> biConsumer) {
        while (item1.inRange() || item2.inRange()) {
            if (item1.getOff() < item1.getActualLength() && item1.inRange()) {
                if (biPredicate.test(item1, item2)) {
                    biConsumer.accept(item1, item2);
                    item1.setOff(item1.getOff() + item1.getLen());
                    item1.setLen(0);
                    continue;
                }
                item1.setLen(item1.getLen() + 1);
                continue;
            }
            if (item1.getOff() < item1.getActualLength() && !item1.inRange() && item2.inRange()) {
                if (biPredicate.test(item1, item2)) {
                    biConsumer.accept(item1, item2);
                    item1.setOff(item1.getActualLength());
                    item1.setLen(0);
                    item2.setOff(item2.getOff() + item2.getLen());
                    item2.setLen(0);
                    continue;
                }
                item2.setLen(item2.getLen() + 1);
                continue;
            }
            if (item2.getOff() < item2.getActualLength() && item2.inRange()) {
                if (biPredicate.test(item1, item2)) {
                    biConsumer.accept(item1, item2);
                    item2.setOff(item2.getOff() + item2.getLen());
                    item2.setLen(0);
                    continue;
                }
                item2.setLen(item2.getLen() + 1);
                continue;
            }
            item2.setLen(item2.getLen() + 1);
        }
        if (item1.getOff() < item1.getActualLength() || item2.getOff() < item2.getActualLength()) {
            biConsumer.accept(item1, item2);
        }
    }
}

