/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.common.enums;

import java.util.HashMap;
import java.util.Map;

public enum EDataType {
    BOOL("bool", 1),
    BYTE("byte", 1),
    UINT16("uint16", 2),
    INT16("int16", 2),
    UINT32("uint32", 4),
    INT32("int32", 4),
    INT64("int64", 8),
    FLOAT32("float32", 4),
    FLOAT64("float64", 8),
    STRING("string", 1),
    TIME("time", 4),
    DATE("date", 2),
    TIME_OF_DAY("timeOfDay", 4),
    DTL("dtl", 12);

    private final int byteLength;
    private final String name;

    public static EDataType from(String data) {
        return (EDataType)((Object)Holder.INSTANCE.get(data));
    }

    private EDataType(String name, int byteLength) {
        this.name = name;
        this.byteLength = byteLength;
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public String getName() {
        return this.name;
    }

    private static class Holder {
        private static final Map<String, EDataType> INSTANCE = Holder.createMap();

        private Holder() {
        }

        private static Map<String, EDataType> createMap() {
            HashMap<String, EDataType> map = new HashMap<String, EDataType>();
            for (EDataType item : EDataType.values()) {
                map.put(item.name, item);
            }
            return map;
        }
    }
}

