/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.common.serializer;

import com.github.xingshuangs.iot.common.buff.EByteBuffFormat;
import com.github.xingshuangs.iot.common.enums.EDataType;

public class ByteArrayParameter {
    protected int byteOffset = 0;
    protected int bitOffset = 0;
    protected int count = 1;
    protected EDataType type = EDataType.BYTE;
    protected boolean littleEndian = false;
    protected EByteBuffFormat format = EByteBuffFormat.DC_BA;
    protected Object value;

    public ByteArrayParameter() {
    }

    public ByteArrayParameter(int byteOffset, int bitOffset, int count, EDataType type) {
        this(byteOffset, bitOffset, count, type, false, EByteBuffFormat.DC_BA);
    }

    public ByteArrayParameter(int byteOffset, int bitOffset, int count, EDataType type, boolean littleEndian) {
        this(byteOffset, bitOffset, count, type, littleEndian, EByteBuffFormat.DC_BA);
    }

    public ByteArrayParameter(int byteOffset, int bitOffset, int count, EDataType type, boolean littleEndian, EByteBuffFormat format) {
        this.byteOffset = byteOffset;
        this.bitOffset = bitOffset;
        this.count = count;
        this.type = type;
        this.littleEndian = littleEndian;
        this.format = format;
    }

    public int getByteOffset() {
        return this.byteOffset;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public int getCount() {
        return this.count;
    }

    public EDataType getType() {
        return this.type;
    }

    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    public EByteBuffFormat getFormat() {
        return this.format;
    }

    public Object getValue() {
        return this.value;
    }

    public void setByteOffset(int byteOffset) {
        this.byteOffset = byteOffset;
    }

    public void setBitOffset(int bitOffset) {
        this.bitOffset = bitOffset;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setType(EDataType type) {
        this.type = type;
    }

    public void setLittleEndian(boolean littleEndian) {
        this.littleEndian = littleEndian;
    }

    public void setFormat(EByteBuffFormat format) {
        this.format = format;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteArrayParameter)) {
            return false;
        }
        ByteArrayParameter other = (ByteArrayParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getByteOffset() != other.getByteOffset()) {
            return false;
        }
        if (this.getBitOffset() != other.getBitOffset()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.isLittleEndian() != other.isLittleEndian()) {
            return false;
        }
        EDataType this$type = this.getType();
        EDataType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        EByteBuffFormat this$format = this.getFormat();
        EByteBuffFormat other$format = other.getFormat();
        if (this$format == null ? other$format != null : !((Object)((Object)this$format)).equals((Object)other$format)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ByteArrayParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getByteOffset();
        result = result * 59 + this.getBitOffset();
        result = result * 59 + this.getCount();
        result = result * 59 + (this.isLittleEndian() ? 79 : 97);
        EDataType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        EByteBuffFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : ((Object)((Object)$format)).hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "ByteArrayParameter(byteOffset=" + this.getByteOffset() + ", bitOffset=" + this.getBitOffset() + ", count=" + this.getCount() + ", type=" + (Object)((Object)this.getType()) + ", littleEndian=" + this.isLittleEndian() + ", format=" + (Object)((Object)this.getFormat()) + ", value=" + this.getValue() + ")";
    }
}

