/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.common.serializer;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.common.enums.EDataType;
import com.github.xingshuangs.iot.common.serializer.ByteArrayParameter;
import com.github.xingshuangs.iot.common.serializer.ByteArrayParseData;
import com.github.xingshuangs.iot.common.serializer.ByteArrayVariable;
import com.github.xingshuangs.iot.common.serializer.IByteArraySerializable;
import com.github.xingshuangs.iot.exceptions.ByteArrayParseException;
import com.github.xingshuangs.iot.utils.BooleanUtil;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ByteArraySerializer
implements IByteArraySerializable {
    private Charset charsets = StandardCharsets.US_ASCII;

    public static ByteArraySerializer newInstance() {
        return new ByteArraySerializer();
    }

    @Override
    public <T> T toObject(Class<T> targetClass, byte[] src) {
        try {
            T bean = targetClass.newInstance();
            for (Field field : targetClass.getDeclaredFields()) {
                ByteArrayVariable variable = field.getAnnotation(ByteArrayVariable.class);
                if (variable == null) continue;
                ByteArrayParameter parameter = new ByteArrayParameter(variable.byteOffset(), variable.bitOffset(), variable.count(), variable.type(), variable.littleEndian(), variable.format());
                this.checkByteArrayVariable(parameter);
                this.extractData(src, bean, field, parameter);
            }
            return bean;
        }
        catch (Exception e) {
            throw new ByteArrayParseException("parsing to object error, cause:" + e.getMessage(), e);
        }
    }

    public ByteArrayParameter extractParameter(ByteArrayParameter parameter, byte[] src) {
        return this.extractParameter(Collections.singletonList(parameter), src).get(0);
    }

    public List<ByteArrayParameter> extractParameter(List<ByteArrayParameter> parameters, byte[] src) {
        try {
            for (ByteArrayParameter parameter : parameters) {
                if (parameter == null) {
                    throw new ByteArrayParseException("null exists in the list of ByteArrayParameter");
                }
                this.checkByteArrayVariable(parameter);
                Field field = parameter.getClass().getDeclaredField("value");
                this.extractData(src, parameter, field, parameter);
            }
            return parameters;
        }
        catch (Exception e) {
            throw new ByteArrayParseException("parsing to object error, cause:" + e.getMessage(), e);
        }
    }

    @Override
    public <T> byte[] toByteArray(T targetBean) {
        try {
            int buffSize = 0;
            ArrayList<ByteArrayParseData> parseDataList = new ArrayList<ByteArrayParseData>();
            for (Field field : targetBean.getClass().getDeclaredFields()) {
                ByteArrayVariable variable = field.getAnnotation(ByteArrayVariable.class);
                if (variable == null) continue;
                ByteArrayParameter parameter = new ByteArrayParameter(variable.byteOffset(), variable.bitOffset(), variable.count(), variable.type(), variable.littleEndian(), variable.format());
                this.checkByteArrayVariable(parameter);
                parseDataList.add(new ByteArrayParseData(variable, field));
                int maxPos = variable.byteOffset() + variable.count() * variable.type().getByteLength();
                if (maxPos <= buffSize) continue;
                buffSize = maxPos;
            }
            if (buffSize == 0 || parseDataList.isEmpty()) {
                return new byte[0];
            }
            ByteWriteBuff buff = ByteWriteBuff.newInstance(buffSize);
            for (ByteArrayParseData item : parseDataList) {
                item.getField().setAccessible(true);
                Object data = item.getField().get(targetBean);
                if (data == null) continue;
                if (item.getVariable().count() == 1) {
                    this.fillOneData(item.getVariable(), data, buff, 0);
                    continue;
                }
                this.fillListData(item.getVariable(), data, buff);
            }
            return buff.getData();
        }
        catch (Exception e) {
            throw new ByteArrayParseException("parsing to object error, cause:" + e.getMessage(), e);
        }
    }

    private <T> void extractData(byte[] src, T bean, Field field, ByteArrayParameter variable) throws IllegalAccessException {
        ByteReadBuff buff = new ByteReadBuff(src, 0, variable.isLittleEndian(), variable.getFormat());
        field.setAccessible(true);
        switch (variable.getType()) {
            case BOOL: {
                List booleans = IntStream.range(0, variable.getCount()).mapToObj(x -> {
                    int byteAdd = variable.getByteOffset() + (variable.getBitOffset() + x) / 8;
                    int bitAdd = (variable.getBitOffset() + x) % 8;
                    return buff.getBoolean(byteAdd, bitAdd);
                }).collect(Collectors.toList());
                field.set(bean, variable.getCount() == 1 ? booleans.get(0) : booleans);
                break;
            }
            case BYTE: {
                List bytes = IntStream.range(0, variable.getCount()).mapToObj(x -> buff.getByte(variable.getByteOffset() + x * variable.getType().getByteLength())).collect(Collectors.toList());
                field.set(bean, variable.getCount() == 1 ? bytes.get(0) : bytes);
                break;
            }
            case UINT16: {
                List uint16s = IntStream.range(0, variable.getCount()).mapToObj(x -> buff.getUInt16(variable.getByteOffset() + x * variable.getType().getByteLength())).collect(Collectors.toList());
                field.set(bean, variable.getCount() == 1 ? uint16s.get(0) : uint16s);
                break;
            }
            case INT16: {
                List int16s = IntStream.range(0, variable.getCount()).mapToObj(x -> buff.getInt16(variable.getByteOffset() + x * variable.getType().getByteLength())).collect(Collectors.toList());
                field.set(bean, variable.getCount() == 1 ? int16s.get(0) : int16s);
                break;
            }
            case UINT32: {
                List uint32s = IntStream.range(0, variable.getCount()).mapToObj(x -> buff.getUInt32(variable.getByteOffset() + x * variable.getType().getByteLength())).collect(Collectors.toList());
                field.set(bean, variable.getCount() == 1 ? uint32s.get(0) : uint32s);
                break;
            }
            case INT32: {
                List int32s = IntStream.range(0, variable.getCount()).mapToObj(x -> buff.getInt32(variable.getByteOffset() + x * variable.getType().getByteLength())).collect(Collectors.toList());
                field.set(bean, variable.getCount() == 1 ? int32s.get(0) : int32s);
                break;
            }
            case INT64: {
                List int64s = IntStream.range(0, variable.getCount()).mapToObj(x -> buff.getInt64(variable.getByteOffset() + x * variable.getType().getByteLength())).collect(Collectors.toList());
                field.set(bean, variable.getCount() == 1 ? int64s.get(0) : int64s);
                break;
            }
            case FLOAT32: {
                List float32s = IntStream.range(0, variable.getCount()).mapToObj(x -> Float.valueOf(buff.getFloat32(variable.getByteOffset() + x * variable.getType().getByteLength()))).collect(Collectors.toList());
                field.set(bean, variable.getCount() == 1 ? float32s.get(0) : float32s);
                break;
            }
            case FLOAT64: {
                List float64s = IntStream.range(0, variable.getCount()).mapToObj(x -> buff.getFloat64(variable.getByteOffset() + x * variable.getType().getByteLength())).collect(Collectors.toList());
                field.set(bean, variable.getCount() == 1 ? float64s.get(0) : float64s);
                break;
            }
            case STRING: {
                field.set(bean, buff.getString(variable.getByteOffset(), variable.getCount(), this.charsets));
                break;
            }
            default: {
                throw new ByteArrayParseException("The data type can not be recognized when extracting the data");
            }
        }
    }

    private void checkByteArrayVariable(ByteArrayParameter variable) {
        if (variable.getByteOffset() < 0) {
            throw new ByteArrayParseException("The byte offset can't be negative");
        }
        if (variable.getCount() < 0) {
            throw new ByteArrayParseException("The number of data can't be negative");
        }
        if (variable.getType() == EDataType.BOOL && (variable.getBitOffset() > 7 || variable.getBitOffset() < 0)) {
            throw new ByteArrayParseException("When the data type is bool, the bit offset can only be [0,7].");
        }
    }

    private void fillOneData(ByteArrayVariable variable, Object data, ByteWriteBuff buff, int index) {
        switch (variable.type()) {
            case BOOL: {
                int byteAdd = variable.byteOffset() + (variable.bitOffset() + index) / 8;
                int bitAdd = (variable.bitOffset() + index) % 8;
                byte newByte = BooleanUtil.setBit(buff.getByte(byteAdd), bitAdd, (Boolean)data);
                buff.putByte(newByte, byteAdd);
                break;
            }
            case BYTE: {
                buff.putByte((Byte)data, variable.byteOffset() + index * variable.type().getByteLength());
                break;
            }
            case UINT16: {
                buff.putShort((Integer)data, variable.byteOffset() + index * variable.type().getByteLength(), variable.littleEndian());
                break;
            }
            case INT16: {
                buff.putShort((Short)data, variable.byteOffset() + index * variable.type().getByteLength(), variable.littleEndian());
                break;
            }
            case UINT32: {
                buff.putInteger((Long)data, variable.byteOffset() + index * variable.type().getByteLength(), variable.littleEndian(), variable.format());
                break;
            }
            case INT32: {
                buff.putInteger(((Integer)data).intValue(), variable.byteOffset() + index * variable.type().getByteLength(), variable.littleEndian(), variable.format());
                break;
            }
            case INT64: {
                buff.putLong((Long)data, variable.byteOffset() + index * variable.type().getByteLength(), variable.littleEndian(), variable.format());
                break;
            }
            case FLOAT32: {
                buff.putFloat(((Float)data).floatValue(), variable.byteOffset() + index * variable.type().getByteLength(), variable.littleEndian(), variable.format());
                break;
            }
            case FLOAT64: {
                buff.putDouble((Double)data, variable.byteOffset() + index * variable.type().getByteLength(), variable.littleEndian(), variable.format());
                break;
            }
            case STRING: {
                buff.putString((String)data, this.charsets, variable.byteOffset());
                break;
            }
            default: {
                throw new ByteArrayParseException("The data type can not be recognized when populating the data");
            }
        }
    }

    private void fillListData(ByteArrayVariable variable, Object data, ByteWriteBuff buff) {
        if (variable.type() == EDataType.STRING) {
            buff.putString((String)data, this.charsets, variable.byteOffset());
        } else {
            List list = (List)data;
            for (int i = 0; i < list.size(); ++i) {
                this.fillOneData(variable, list.get(i), buff, i);
            }
        }
    }

    public Charset getCharsets() {
        return this.charsets;
    }

    public void setCharsets(Charset charsets) {
        this.charsets = charsets;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteArraySerializer)) {
            return false;
        }
        ByteArraySerializer other = (ByteArraySerializer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Charset this$charsets = this.getCharsets();
        Charset other$charsets = other.getCharsets();
        return !(this$charsets == null ? other$charsets != null : !((Object)this$charsets).equals(other$charsets));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ByteArraySerializer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Charset $charsets = this.getCharsets();
        result = result * 59 + ($charsets == null ? 43 : ((Object)$charsets).hashCode());
        return result;
    }

    public String toString() {
        return "ByteArraySerializer(charsets=" + this.getCharsets() + ")";
    }
}

