/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.net.client;

import com.github.xingshuangs.iot.exceptions.SocketRuntimeException;
import com.github.xingshuangs.iot.net.ICommunicable;
import com.github.xingshuangs.iot.net.SocketUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpClientBasic
implements ICommunicable {
    private static final Logger log = LoggerFactory.getLogger(TcpClientBasic.class);
    protected String tag = "";
    protected Socket socket;
    protected int connectTimeout = 10000;
    protected int receiveTimeout = 10000;
    protected final InetSocketAddress socketAddress;
    protected final AtomicBoolean socketError = new AtomicBoolean(false);
    protected boolean enableReconnect = true;

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public boolean isEnableReconnect() {
        return this.enableReconnect;
    }

    public void setEnableReconnect(boolean enableReconnect) {
        this.enableReconnect = enableReconnect;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public TcpClientBasic() {
        this("127.0.0.1", 8088);
    }

    public TcpClientBasic(String host, int port) {
        this.socketAddress = new InetSocketAddress(host, port);
    }

    public boolean checkConnected() {
        return !this.socketError.get() && SocketUtils.isConnected(this.socket);
    }

    public void connect() {
        this.close();
        this.getAvailableSocket();
    }

    public Socket getAvailableSocket() {
        if (this.socket != null && !this.enableReconnect) {
            return this.socket;
        }
        if (this.checkConnected()) {
            return this.socket;
        }
        this.close();
        try {
            this.socket = new Socket();
            this.socket.setSoTimeout(this.receiveTimeout);
            this.socket.connect(this.socketAddress, this.connectTimeout);
            this.socketError.set(false);
            log.debug("Create socket and connect to {} server [{}] succeed", (Object)this.tag, (Object)this.socketAddress);
            this.doAfterConnected();
            return this.socket;
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            SocketUtils.close(this.socket);
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    protected void doAfterConnected() {
    }

    @Override
    public void write(byte[] data) {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) {
        this.write(data, offset, length, -1);
    }

    public void write(byte[] data, int offset, int length, int maxLength) {
        try {
            Socket availableSocket = this.getAvailableSocket();
            SocketUtils.write(availableSocket, data, offset, length, maxLength);
        }
        catch (IOException e) {
            this.socketError.set(true);
            throw new SocketRuntimeException(e);
        }
    }

    @Override
    public int read(byte[] data) {
        return this.read(data, 0, data.length, this.receiveTimeout);
    }

    public int read(byte[] data, int timeout) {
        return this.read(data, 0, data.length, timeout);
    }

    @Override
    public int read(byte[] data, int offset, int length) {
        return this.read(data, offset, length, this.receiveTimeout);
    }

    public int read(byte[] data, int offset, int length, boolean waitForMore) {
        return this.read(data, offset, length, 1024, this.receiveTimeout, waitForMore);
    }

    public int read(byte[] data, int offset, int length, int timeout) {
        return this.read(data, offset, length, -1, timeout);
    }

    public int read(byte[] data, int offset, int length, int maxLength, int timeout) {
        return this.read(data, offset, length, maxLength, timeout, false);
    }

    public int read(byte[] data, int offset, int length, int maxLength, int timeout, boolean waitForMore) {
        try {
            Socket availableSocket = this.getAvailableSocket();
            return SocketUtils.read(availableSocket, data, offset, length, maxLength, timeout, waitForMore);
        }
        catch (IOException e) {
            this.socketError.set(true);
            throw new SocketRuntimeException(e);
        }
    }
}

