/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.net.server;

import com.github.xingshuangs.iot.exceptions.SocketRuntimeException;
import com.github.xingshuangs.iot.net.SocketUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerBasic {
    private static final Logger log = LoggerFactory.getLogger(TcpServerBasic.class);
    private ServerSocket serverSocket;
    protected int port = 8088;
    protected ExecutorService executorService;

    public void start() {
        this.start(this.port);
    }

    public void start(int port) {
        try {
            this.port = port;
            this.stop();
            this.executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            this.serverSocket = new ServerSocket(port);
            Thread thread = new Thread(this::waitForClients);
            thread.setDaemon(true);
            thread.start();
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.isAlive()) {
                this.serverSocket.close();
                this.executorService.shutdown();
                log.debug("Close the server, port number [{}]", (Object)this.port);
            }
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    public boolean isAlive() {
        return this.serverSocket != null && !this.serverSocket.isClosed();
    }

    protected void waitForClients() {
        log.debug("Open accept thread and waiting for clients, port number [{}]", (Object)this.port);
        while (this.isAlive()) {
            try {
                Socket client = this.serverSocket.accept();
                if (!this.checkClientValid(client)) {
                    SocketUtils.close(client);
                }
                this.executorService.execute(() -> this.doClientConnected(client));
            }
            catch (IOException e) {
                if (!this.isAlive()) continue;
                log.error(e.getMessage());
            }
        }
    }

    protected boolean checkClientValid(Socket client) {
        return true;
    }

    protected void doClientConnected(Socket client) {
        log.debug("The client [{}] is connected", (Object)client.getRemoteSocketAddress());
        this.clientConnected(client);
        try {
            if (this.checkHandshake(client) && this.isAlive()) {
                while (SocketUtils.isConnected(client)) {
                    this.doClientHandle(client);
                }
            }
        }
        catch (Exception e) {
            if (SocketUtils.isConnected(client)) {
                log.error(e.getMessage());
            }
        }
        finally {
            try {
                SocketUtils.close(client);
            }
            catch (Exception exception) {}
        }
        this.clientDisconnected(client);
        log.debug("The client [{}] is disconnected", (Object)client.getRemoteSocketAddress());
    }

    protected void clientConnected(Socket socket) {
    }

    protected void clientDisconnected(Socket socket) {
    }

    protected boolean checkHandshake(Socket socket) {
        return true;
    }

    protected void doClientHandle(Socket socket) {
        byte[] data = this.readClientData(socket);
        log.debug(new String(data));
    }

    protected byte[] readClientData(Socket socket) {
        try {
            InputStream in = socket.getInputStream();
            int firstByte = in.read();
            if (firstByte == -1) {
                SocketUtils.close(socket);
                throw new SocketRuntimeException("The client is actively disconnected");
            }
            byte[] data = new byte[in.available() + 1];
            data[0] = (byte)firstByte;
            this.read(socket, data, 1, data.length - 1, 1024);
            return data;
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    protected void write(Socket socket, byte[] data) {
        try {
            SocketUtils.write(socket, data);
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    protected int read(Socket socket, byte[] data) {
        return this.read(socket, data, 0, data.length, 1024);
    }

    protected int read(Socket socket, byte[] data, int offset, int length) {
        return this.read(socket, data, offset, length, 1024);
    }

    protected int read(Socket socket, byte[] data, int offset, int length, int maxLength) {
        try {
            return SocketUtils.read(socket, data, offset, length, maxLength);
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    protected int read(Socket socket, byte[] data, int offset, int length, int maxLength, int timeout, boolean waitForMore) {
        try {
            return SocketUtils.read(socket, data, offset, length, maxLength, timeout, waitForMore);
        }
        catch (IOException e) {
            throw new SocketRuntimeException(e);
        }
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public int getPort() {
        return this.port;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TcpServerBasic)) {
            return false;
        }
        TcpServerBasic other = (TcpServerBasic)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        ServerSocket this$serverSocket = this.getServerSocket();
        ServerSocket other$serverSocket = other.getServerSocket();
        if (this$serverSocket == null ? other$serverSocket != null : !this$serverSocket.equals(other$serverSocket)) {
            return false;
        }
        ExecutorService this$executorService = this.getExecutorService();
        ExecutorService other$executorService = other.getExecutorService();
        return !(this$executorService == null ? other$executorService != null : !this$executorService.equals(other$executorService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TcpServerBasic;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        ServerSocket $serverSocket = this.getServerSocket();
        result = result * 59 + ($serverSocket == null ? 43 : $serverSocket.hashCode());
        ExecutorService $executorService = this.getExecutorService();
        result = result * 59 + ($executorService == null ? 43 : $executorService.hashCode());
        return result;
    }

    public String toString() {
        return "TcpServerBasic(serverSocket=" + this.getServerSocket() + ", port=" + this.getPort() + ", executorService=" + this.getExecutorService() + ")";
    }
}

