/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.enums;

import java.util.HashMap;
import java.util.Map;

public enum EMcFrameType {
    FRAME_4E("4E", 84, 212),
    FRAME_3E("3E", 80, 208),
    FRAME_1E("1E", 0, 0);

    private final String code;
    private final int reqSubHeader;
    private final int ackSubHeader;

    public static EMcFrameType from(String data) {
        return (EMcFrameType)((Object)Holder.INSTANCE.get(data));
    }

    private EMcFrameType(String code, int reqSubHeader, int ackSubHeader) {
        this.code = code;
        this.reqSubHeader = reqSubHeader;
        this.ackSubHeader = ackSubHeader;
    }

    public String getCode() {
        return this.code;
    }

    public int getReqSubHeader() {
        return this.reqSubHeader;
    }

    public int getAckSubHeader() {
        return this.ackSubHeader;
    }

    private static class Holder {
        private static final Map<String, EMcFrameType> INSTANCE = Holder.createMap();

        private Holder() {
        }

        private static Map<String, EMcFrameType> createMap() {
            HashMap<String, EMcFrameType> map = new HashMap<String, EMcFrameType>();
            for (EMcFrameType item : EMcFrameType.values()) {
                map.put(item.code, item);
            }
            return map;
        }
    }
}

