/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;

public class McFrame1EAccessRoute
extends McAccessRoute {
    private int pcNumber = 255;

    public McFrame1EAccessRoute() {
    }

    public McFrame1EAccessRoute(int pcNumber) {
        this.pcNumber = pcNumber;
    }

    @Override
    public int byteArrayLength() {
        return 1;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength(), true).putByte(this.pcNumber).getData();
    }

    public static McFrame1EAccessRoute createDefault() {
        McFrame1EAccessRoute route = new McFrame1EAccessRoute();
        route.pcNumber = 255;
        return route;
    }

    public static McFrame1EAccessRoute fromBytes(byte[] data) {
        return McFrame1EAccessRoute.fromBytes(data, 0);
    }

    public static McFrame1EAccessRoute fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset, true);
        McFrame1EAccessRoute res = new McFrame1EAccessRoute();
        res.pcNumber = buff.getByteToInt();
        return res;
    }

    public int getPcNumber() {
        return this.pcNumber;
    }

    public void setPcNumber(int pcNumber) {
        this.pcNumber = pcNumber;
    }

    public String toString() {
        return "McFrame1EAccessRoute(pcNumber=" + this.getPcNumber() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McFrame1EAccessRoute)) {
            return false;
        }
        McFrame1EAccessRoute other = (McFrame1EAccessRoute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getPcNumber() == other.getPcNumber();
    }

    protected boolean canEqual(Object other) {
        return other instanceof McFrame1EAccessRoute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPcNumber();
        return result;
    }
}

