/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;

public class McFrame4E3EAccessRoute
extends McAccessRoute {
    private int networkNumber = 0;
    private int pcNumber = 255;
    private int requestDestModuleIoNumber = 1023;
    private int requestDestModuleStationNumber = 0;

    public McFrame4E3EAccessRoute() {
    }

    public McFrame4E3EAccessRoute(int networkNumber, int pcNumber, int requestDestModuleIoNumber, int requestDestModuleStationNumber) {
        this.networkNumber = networkNumber;
        this.pcNumber = pcNumber;
        this.requestDestModuleIoNumber = requestDestModuleIoNumber;
        this.requestDestModuleStationNumber = requestDestModuleStationNumber;
    }

    @Override
    public int byteArrayLength() {
        return 5;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength(), true).putByte(this.networkNumber).putByte(this.pcNumber).putShort(this.requestDestModuleIoNumber).putByte(this.requestDestModuleStationNumber).getData();
    }

    public static McFrame4E3EAccessRoute createDefault() {
        McFrame4E3EAccessRoute route = new McFrame4E3EAccessRoute();
        route.networkNumber = 0;
        route.pcNumber = 255;
        route.requestDestModuleIoNumber = 1023;
        route.requestDestModuleStationNumber = 0;
        return route;
    }

    public static McFrame4E3EAccessRoute fromBytes(byte[] data) {
        return McFrame4E3EAccessRoute.fromBytes(data, 0);
    }

    public static McFrame4E3EAccessRoute fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset, true);
        McFrame4E3EAccessRoute res = new McFrame4E3EAccessRoute();
        res.networkNumber = buff.getByteToInt();
        res.pcNumber = buff.getByteToInt();
        res.requestDestModuleIoNumber = buff.getUInt16();
        res.requestDestModuleStationNumber = buff.getByteToInt();
        return res;
    }

    public int getNetworkNumber() {
        return this.networkNumber;
    }

    public int getPcNumber() {
        return this.pcNumber;
    }

    public int getRequestDestModuleIoNumber() {
        return this.requestDestModuleIoNumber;
    }

    public int getRequestDestModuleStationNumber() {
        return this.requestDestModuleStationNumber;
    }

    public void setNetworkNumber(int networkNumber) {
        this.networkNumber = networkNumber;
    }

    public void setPcNumber(int pcNumber) {
        this.pcNumber = pcNumber;
    }

    public void setRequestDestModuleIoNumber(int requestDestModuleIoNumber) {
        this.requestDestModuleIoNumber = requestDestModuleIoNumber;
    }

    public void setRequestDestModuleStationNumber(int requestDestModuleStationNumber) {
        this.requestDestModuleStationNumber = requestDestModuleStationNumber;
    }

    public String toString() {
        return "McFrame4E3EAccessRoute(networkNumber=" + this.getNetworkNumber() + ", pcNumber=" + this.getPcNumber() + ", requestDestModuleIoNumber=" + this.getRequestDestModuleIoNumber() + ", requestDestModuleStationNumber=" + this.getRequestDestModuleStationNumber() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McFrame4E3EAccessRoute)) {
            return false;
        }
        McFrame4E3EAccessRoute other = (McFrame4E3EAccessRoute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getNetworkNumber() != other.getNetworkNumber()) {
            return false;
        }
        if (this.getPcNumber() != other.getPcNumber()) {
            return false;
        }
        if (this.getRequestDestModuleIoNumber() != other.getRequestDestModuleIoNumber()) {
            return false;
        }
        return this.getRequestDestModuleStationNumber() == other.getRequestDestModuleStationNumber();
    }

    protected boolean canEqual(Object other) {
        return other instanceof McFrame4E3EAccessRoute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getNetworkNumber();
        result = result * 59 + this.getPcNumber();
        result = result * 59 + this.getRequestDestModuleIoNumber();
        result = result * 59 + this.getRequestDestModuleStationNumber();
        return result;
    }
}

