/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeaderAck;

public class McHeader1EAck
extends McHeaderAck {
    public McHeader1EAck() {
        this.frameType = EMcFrameType.FRAME_1E;
    }

    @Override
    public int byteArrayLength() {
        return 2;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(2, true).putByte(this.subHeader).putByte(this.endCode).getData();
    }

    public static McHeader1EAck fromBytes(byte[] data) {
        return McHeader1EAck.fromBytes(data, 0);
    }

    public static McHeader1EAck fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset, true);
        McHeader1EAck res = new McHeader1EAck();
        res.subHeader = buff.getByteToInt();
        res.endCode = buff.getByteToInt();
        return res;
    }

    @Override
    public String toString() {
        return "McHeader1EAck()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeader1EAck)) {
            return false;
        }
        McHeader1EAck other = (McHeader1EAck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McHeader1EAck;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

