/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeaderReq;

public class McHeader1EReq
extends McHeaderReq {
    public McHeader1EReq() {
    }

    public McHeader1EReq(McAccessRoute accessRoute, int timer) {
        this.frameType = EMcFrameType.FRAME_1E;
        this.subHeader = this.frameType.getReqSubHeader();
        this.accessRoute = accessRoute;
        this.monitoringTimer = timer / 250;
    }

    @Override
    public int byteArrayLength() {
        return 1 + this.accessRoute.byteArrayLength() + 2;
    }

    @Override
    public byte[] toByteArray() {
        int length = 1 + this.accessRoute.byteArrayLength() + 2;
        return ByteWriteBuff.newInstance(length, true).putByte(this.subHeader).putBytes(this.accessRoute.toByteArray()).putShort(this.monitoringTimer).getData();
    }

    @Override
    public String toString() {
        return "McHeader1EReq()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeader1EReq)) {
            return false;
        }
        McHeader1EReq other = (McHeader1EReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McHeader1EReq;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

