/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McFrame4E3EAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeaderAck;

public class McHeader3EAck
extends McHeaderAck {
    protected McAccessRoute accessRoute;
    protected int dataLength = 0;

    public McHeader3EAck() {
        this.frameType = EMcFrameType.FRAME_3E;
    }

    @Override
    public int byteArrayLength() {
        return 2 + this.accessRoute.byteArrayLength() + 2 + 2;
    }

    @Override
    public byte[] toByteArray() {
        int length = 2 + this.accessRoute.byteArrayLength() + 2 + 2;
        return ByteWriteBuff.newInstance(length, true).putShort(this.subHeader).putBytes(this.accessRoute.toByteArray()).putShort(this.dataLength).putShort(this.endCode).getData();
    }

    public static McHeader3EAck fromBytes(byte[] data) {
        return McHeader3EAck.fromBytes(data, 0);
    }

    public static McHeader3EAck fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset, true);
        McHeader3EAck res = new McHeader3EAck();
        res.subHeader = buff.getUInt16();
        res.accessRoute = McFrame4E3EAccessRoute.fromBytes(buff.getBytes(5));
        res.dataLength = buff.getUInt16();
        res.endCode = buff.getUInt16();
        return res;
    }

    public McAccessRoute getAccessRoute() {
        return this.accessRoute;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setAccessRoute(McAccessRoute accessRoute) {
        this.accessRoute = accessRoute;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    @Override
    public String toString() {
        return "McHeader3EAck(accessRoute=" + this.getAccessRoute() + ", dataLength=" + this.getDataLength() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeader3EAck)) {
            return false;
        }
        McHeader3EAck other = (McHeader3EAck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getDataLength() != other.getDataLength()) {
            return false;
        }
        McAccessRoute this$accessRoute = this.getAccessRoute();
        McAccessRoute other$accessRoute = other.getAccessRoute();
        return !(this$accessRoute == null ? other$accessRoute != null : !this$accessRoute.equals(other$accessRoute));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McHeader3EAck;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDataLength();
        McAccessRoute $accessRoute = this.getAccessRoute();
        result = result * 59 + ($accessRoute == null ? 43 : $accessRoute.hashCode());
        return result;
    }
}

