/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McFrame4E3EAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeaderReq;

public class McHeader3EReq
extends McHeaderReq {
    protected int dataLength = 0;

    public McHeader3EReq() {
    }

    public McHeader3EReq(int timer) {
        this(McFrame4E3EAccessRoute.createDefault(), timer);
    }

    public McHeader3EReq(McAccessRoute accessRoute, int timer) {
        this.frameType = EMcFrameType.FRAME_3E;
        this.subHeader = this.frameType.getReqSubHeader();
        this.accessRoute = accessRoute;
        this.monitoringTimer = timer / 250;
    }

    @Override
    public int byteArrayLength() {
        return 2 + this.accessRoute.byteArrayLength() + 2 + 2;
    }

    @Override
    public byte[] toByteArray() {
        int length = 2 + this.accessRoute.byteArrayLength() + 2 + 2;
        return ByteWriteBuff.newInstance(length, true).putShort(this.subHeader).putBytes(this.accessRoute.toByteArray()).putShort(this.dataLength).putShort(this.monitoringTimer).getData();
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    @Override
    public String toString() {
        return "McHeader3EReq(dataLength=" + this.getDataLength() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeader3EReq)) {
            return false;
        }
        McHeader3EReq other = (McHeader3EReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getDataLength() == other.getDataLength();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McHeader3EReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getDataLength();
        return result;
    }
}

