/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McFrame4E3EAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader3EAck;

public class McHeader4EAck
extends McHeader3EAck {
    protected int serialNumber = 0;
    protected int fixedNumber = 0;

    public McHeader4EAck() {
        this.frameType = EMcFrameType.FRAME_4E;
    }

    @Override
    public int byteArrayLength() {
        return 6 + this.accessRoute.byteArrayLength() + 2 + 2;
    }

    @Override
    public byte[] toByteArray() {
        int length = 6 + this.accessRoute.byteArrayLength() + 2 + 2;
        return ByteWriteBuff.newInstance(length, true).putShort(this.subHeader).putShort(this.serialNumber).putShort(this.fixedNumber).putBytes(this.accessRoute.toByteArray()).putShort(this.dataLength).putShort(this.endCode).getData();
    }

    public static McHeader4EAck fromBytes(byte[] data) {
        return McHeader4EAck.fromBytes(data, 0);
    }

    public static McHeader4EAck fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset, true);
        McHeader4EAck res = new McHeader4EAck();
        res.subHeader = buff.getUInt16();
        res.serialNumber = buff.getUInt16();
        res.fixedNumber = buff.getUInt16();
        res.accessRoute = McFrame4E3EAccessRoute.fromBytes(buff.getBytes(5));
        res.dataLength = buff.getUInt16();
        res.endCode = buff.getUInt16();
        return res;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getFixedNumber() {
        return this.fixedNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setFixedNumber(int fixedNumber) {
        this.fixedNumber = fixedNumber;
    }

    @Override
    public String toString() {
        return "McHeader4EAck(serialNumber=" + this.getSerialNumber() + ", fixedNumber=" + this.getFixedNumber() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeader4EAck)) {
            return false;
        }
        McHeader4EAck other = (McHeader4EAck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSerialNumber() != other.getSerialNumber()) {
            return false;
        }
        return this.getFixedNumber() == other.getFixedNumber();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McHeader4EAck;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getSerialNumber();
        result = result * 59 + this.getFixedNumber();
        return result;
    }
}

