/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McFrame4E3EAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader3EReq;

public class McHeader4EReq
extends McHeader3EReq {
    protected int serialNumber = 0;
    protected int fixedNumber = 0;

    public McHeader4EReq() {
    }

    public McHeader4EReq(int timer) {
        this(McFrame4E3EAccessRoute.createDefault(), timer);
    }

    public McHeader4EReq(McAccessRoute accessRoute, int timer) {
        this.frameType = EMcFrameType.FRAME_4E;
        this.subHeader = this.frameType.getReqSubHeader();
        this.accessRoute = accessRoute;
        this.monitoringTimer = timer / 250;
    }

    @Override
    public int byteArrayLength() {
        return 6 + this.accessRoute.byteArrayLength() + 2 + 2;
    }

    @Override
    public byte[] toByteArray() {
        int length = 6 + this.accessRoute.byteArrayLength() + 2 + 2;
        return ByteWriteBuff.newInstance(length, true).putShort(this.subHeader).putShort(this.serialNumber).putShort(this.fixedNumber).putBytes(this.accessRoute.toByteArray()).putShort(this.dataLength).putShort(this.monitoringTimer).getData();
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getFixedNumber() {
        return this.fixedNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setFixedNumber(int fixedNumber) {
        this.fixedNumber = fixedNumber;
    }

    @Override
    public String toString() {
        return "McHeader4EReq(serialNumber=" + this.getSerialNumber() + ", fixedNumber=" + this.getFixedNumber() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeader4EReq)) {
            return false;
        }
        McHeader4EReq other = (McHeader4EReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSerialNumber() != other.getSerialNumber()) {
            return false;
        }
        return this.getFixedNumber() == other.getFixedNumber();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McHeader4EReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getSerialNumber();
        result = result * 59 + this.getFixedNumber();
        return result;
    }
}

