/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.exceptions.McCommException;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader1EAck;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader3EAck;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader4EAck;

public class McHeaderAck
implements IObjectByteArray {
    protected EMcFrameType frameType = EMcFrameType.FRAME_3E;
    protected int subHeader = 0;
    protected int endCode;

    @Override
    public int byteArrayLength() {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0");
    }

    @Override
    public byte[] toByteArray() {
        throw new UnsupportedOperationException("\u672a\u5b9e\u73b0");
    }

    public static McHeaderAck fromBytes(byte[] data, EMcFrameType frameType) {
        return McHeaderAck.fromBytes(data, 0, frameType);
    }

    public static McHeaderAck fromBytes(byte[] data, int offset, EMcFrameType frameType) {
        switch (frameType) {
            case FRAME_1E: {
                return McHeader1EAck.fromBytes(data, offset);
            }
            case FRAME_3E: {
                return McHeader3EAck.fromBytes(data, offset);
            }
            case FRAME_4E: {
                return McHeader4EAck.fromBytes(data, offset);
            }
        }
        throw new McCommException("unknown frame type");
    }

    public EMcFrameType getFrameType() {
        return this.frameType;
    }

    public int getSubHeader() {
        return this.subHeader;
    }

    public int getEndCode() {
        return this.endCode;
    }

    public void setFrameType(EMcFrameType frameType) {
        this.frameType = frameType;
    }

    public void setSubHeader(int subHeader) {
        this.subHeader = subHeader;
    }

    public void setEndCode(int endCode) {
        this.endCode = endCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeaderAck)) {
            return false;
        }
        McHeaderAck other = (McHeaderAck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSubHeader() != other.getSubHeader()) {
            return false;
        }
        if (this.getEndCode() != other.getEndCode()) {
            return false;
        }
        EMcFrameType this$frameType = this.getFrameType();
        EMcFrameType other$frameType = other.getFrameType();
        return !(this$frameType == null ? other$frameType != null : !((Object)((Object)this$frameType)).equals((Object)other$frameType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McHeaderAck;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSubHeader();
        result = result * 59 + this.getEndCode();
        EMcFrameType $frameType = this.getFrameType();
        result = result * 59 + ($frameType == null ? 43 : ((Object)((Object)$frameType)).hashCode());
        return result;
    }

    public String toString() {
        return "McHeaderAck(frameType=" + (Object)((Object)this.getFrameType()) + ", subHeader=" + this.getSubHeader() + ", endCode=" + this.getEndCode() + ")";
    }
}

