/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.exceptions.McCommException;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader1EReq;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader3EReq;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader4EReq;

public class McHeaderReq
implements IObjectByteArray {
    protected EMcFrameType frameType = EMcFrameType.FRAME_3E;
    protected int subHeader = 0;
    protected McAccessRoute accessRoute;
    protected int monitoringTimer;

    @Override
    public int byteArrayLength() {
        throw new UnsupportedOperationException("not implement");
    }

    @Override
    public byte[] toByteArray() {
        throw new UnsupportedOperationException("not implement");
    }

    public static McHeaderReq createByFrameType(EMcFrameType frameType, McAccessRoute accessRoute, int timer) {
        switch (frameType) {
            case FRAME_1E: {
                return new McHeader1EReq(accessRoute, timer);
            }
            case FRAME_3E: {
                return new McHeader3EReq(accessRoute, timer);
            }
            case FRAME_4E: {
                return new McHeader4EReq(accessRoute, timer);
            }
        }
        throw new McCommException("unknown frame type");
    }

    public EMcFrameType getFrameType() {
        return this.frameType;
    }

    public int getSubHeader() {
        return this.subHeader;
    }

    public McAccessRoute getAccessRoute() {
        return this.accessRoute;
    }

    public int getMonitoringTimer() {
        return this.monitoringTimer;
    }

    public void setFrameType(EMcFrameType frameType) {
        this.frameType = frameType;
    }

    public void setSubHeader(int subHeader) {
        this.subHeader = subHeader;
    }

    public void setAccessRoute(McAccessRoute accessRoute) {
        this.accessRoute = accessRoute;
    }

    public void setMonitoringTimer(int monitoringTimer) {
        this.monitoringTimer = monitoringTimer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeaderReq)) {
            return false;
        }
        McHeaderReq other = (McHeaderReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSubHeader() != other.getSubHeader()) {
            return false;
        }
        if (this.getMonitoringTimer() != other.getMonitoringTimer()) {
            return false;
        }
        EMcFrameType this$frameType = this.getFrameType();
        EMcFrameType other$frameType = other.getFrameType();
        if (this$frameType == null ? other$frameType != null : !((Object)((Object)this$frameType)).equals((Object)other$frameType)) {
            return false;
        }
        McAccessRoute this$accessRoute = this.getAccessRoute();
        McAccessRoute other$accessRoute = other.getAccessRoute();
        return !(this$accessRoute == null ? other$accessRoute != null : !this$accessRoute.equals(other$accessRoute));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McHeaderReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSubHeader();
        result = result * 59 + this.getMonitoringTimer();
        EMcFrameType $frameType = this.getFrameType();
        result = result * 59 + ($frameType == null ? 43 : ((Object)((Object)$frameType)).hashCode());
        McAccessRoute $accessRoute = this.getAccessRoute();
        result = result * 59 + ($accessRoute == null ? 43 : $accessRoute.hashCode());
        return result;
    }

    public String toString() {
        return "McHeaderReq(frameType=" + (Object)((Object)this.getFrameType()) + ", subHeader=" + this.getSubHeader() + ", accessRoute=" + this.getAccessRoute() + ", monitoringTimer=" + this.getMonitoringTimer() + ")";
    }
}

