/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McAckData;
import com.github.xingshuangs.iot.protocol.melsec.model.McData;
import com.github.xingshuangs.iot.protocol.melsec.model.McError1EData;
import com.github.xingshuangs.iot.protocol.melsec.model.McError4E3EData;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader3EAck;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeaderAck;

public class McMessageAck
implements IObjectByteArray {
    private McHeaderAck header;
    private McData data;

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + this.data.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength(), true).putBytes(this.header.toByteArray()).putBytes(this.data.toByteArray()).getData();
    }

    public void selfCheck() {
        if (this.header.getFrameType() == EMcFrameType.FRAME_1E) {
            return;
        }
        McHeader3EAck header3EAck = (McHeader3EAck)this.header;
        header3EAck.dataLength = 2 + this.data.byteArrayLength();
    }

    public static McMessageAck fromBytes(byte[] data, EMcFrameType frameType) {
        return McMessageAck.fromBytes(data, 0, frameType);
    }

    public static McMessageAck fromBytes(byte[] data, int offset, EMcFrameType frameType) {
        McMessageAck res = new McMessageAck();
        res.header = McHeaderAck.fromBytes(data, offset, frameType);
        int off = offset + res.header.byteArrayLength();
        res.data = res.header.getEndCode() == 0 ? McAckData.fromBytes(data, off) : (frameType == EMcFrameType.FRAME_1E ? McError1EData.fromBytes(data, off) : McError4E3EData.fromBytes(data, off));
        return res;
    }

    public McHeaderAck getHeader() {
        return this.header;
    }

    public McData getData() {
        return this.data;
    }

    public void setHeader(McHeaderAck header) {
        this.header = header;
    }

    public void setData(McData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McMessageAck)) {
            return false;
        }
        McMessageAck other = (McMessageAck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        McHeaderAck this$header = this.getHeader();
        McHeaderAck other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        McData this$data = this.getData();
        McData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McMessageAck;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        McHeaderAck $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        McData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "McMessageAck(header=" + this.getHeader() + ", data=" + this.getData() + ")";
    }
}

