/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.McCommException;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcCommand;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceAddress;
import com.github.xingshuangs.iot.protocol.melsec.model.McReqData;
import java.util.ArrayList;
import java.util.List;

public class McReadDeviceRandomInWordReqData
extends McReqData {
    private List<McDeviceAddress> wordAddresses;
    private List<McDeviceAddress> dwordAddresses;

    public McReadDeviceRandomInWordReqData() {
        this(EMcSeries.Q_L, new ArrayList<McDeviceAddress>(), new ArrayList<McDeviceAddress>());
    }

    public McReadDeviceRandomInWordReqData(EMcSeries series) {
        this(series, new ArrayList<McDeviceAddress>(), new ArrayList<McDeviceAddress>());
    }

    public McReadDeviceRandomInWordReqData(EMcSeries series, List<McDeviceAddress> wordAddresses, List<McDeviceAddress> dwordAddresses) {
        if (series.getFrameType() == EMcFrameType.FRAME_1E) {
            throw new McCommException("Frame 1E not supported");
        }
        this.series = series;
        this.command = EMcCommand.DEVICE_ACCESS_RANDOM_READ_IN_UNITS;
        this.subcommand = series != EMcSeries.IQ_R ? 0 : 2;
        this.wordAddresses = wordAddresses;
        this.dwordAddresses = dwordAddresses;
    }

    @Override
    public int byteArrayLength() {
        return 6 + this.wordAddresses.stream().mapToInt(x -> x.byteArrayLengthWithoutPointsCount(this.series)).sum() + this.dwordAddresses.stream().mapToInt(x -> x.byteArrayLengthWithoutPointsCount(this.series)).sum();
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength(), true).putShort(this.command.getCode()).putShort(this.subcommand).putByte(this.wordAddresses.size()).putByte(this.dwordAddresses.size());
        this.wordAddresses.forEach(x -> buff.putBytes(x.toByteArrayWithoutPointsCount(this.series)));
        this.dwordAddresses.forEach(x -> buff.putBytes(x.toByteArrayWithoutPointsCount(this.series)));
        return buff.getData();
    }

    public List<McDeviceAddress> getWordAddresses() {
        return this.wordAddresses;
    }

    public List<McDeviceAddress> getDwordAddresses() {
        return this.dwordAddresses;
    }

    public void setWordAddresses(List<McDeviceAddress> wordAddresses) {
        this.wordAddresses = wordAddresses;
    }

    public void setDwordAddresses(List<McDeviceAddress> dwordAddresses) {
        this.dwordAddresses = dwordAddresses;
    }

    @Override
    public String toString() {
        return "McReadDeviceRandomInWordReqData(wordAddresses=" + this.getWordAddresses() + ", dwordAddresses=" + this.getDwordAddresses() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McReadDeviceRandomInWordReqData)) {
            return false;
        }
        McReadDeviceRandomInWordReqData other = (McReadDeviceRandomInWordReqData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<McDeviceAddress> this$wordAddresses = this.getWordAddresses();
        List<McDeviceAddress> other$wordAddresses = other.getWordAddresses();
        if (this$wordAddresses == null ? other$wordAddresses != null : !((Object)this$wordAddresses).equals(other$wordAddresses)) {
            return false;
        }
        List<McDeviceAddress> this$dwordAddresses = this.getDwordAddresses();
        List<McDeviceAddress> other$dwordAddresses = other.getDwordAddresses();
        return !(this$dwordAddresses == null ? other$dwordAddresses != null : !((Object)this$dwordAddresses).equals(other$dwordAddresses));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McReadDeviceRandomInWordReqData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<McDeviceAddress> $wordAddresses = this.getWordAddresses();
        result = result * 59 + ($wordAddresses == null ? 43 : ((Object)$wordAddresses).hashCode());
        List<McDeviceAddress> $dwordAddresses = this.getDwordAddresses();
        result = result * 59 + ($dwordAddresses == null ? 43 : ((Object)$dwordAddresses).hashCode());
        return result;
    }
}

