/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.protocol.melsec.enums.EMcCommand;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceAddress;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceContent;
import com.github.xingshuangs.iot.protocol.melsec.model.McFrame4E3EAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeaderReq;
import com.github.xingshuangs.iot.protocol.melsec.model.McMessageReq;
import com.github.xingshuangs.iot.protocol.melsec.model.McReadDeviceBatchInBitReqData;
import com.github.xingshuangs.iot.protocol.melsec.model.McReadDeviceBatchInWordReqData;
import com.github.xingshuangs.iot.protocol.melsec.model.McReadDeviceBatchMultiBlocksReqData;
import com.github.xingshuangs.iot.protocol.melsec.model.McReadDeviceRandomInWordReqData;
import com.github.xingshuangs.iot.protocol.melsec.model.McWriteDeviceBatchInBitReqData;
import com.github.xingshuangs.iot.protocol.melsec.model.McWriteDeviceBatchInWordReqData;
import com.github.xingshuangs.iot.protocol.melsec.model.McWriteDeviceBatchMultiBlocksReqData;
import com.github.xingshuangs.iot.protocol.melsec.model.McWriteDeviceRandomInBitReqData;
import com.github.xingshuangs.iot.protocol.melsec.model.McWriteDeviceRandomInWordReqData;
import java.util.List;

public class McReqBuilder {
    private static final int MONITORING_TIMER_DEFAULT = 3000;

    private McReqBuilder() {
    }

    public static McMessageReq createReadDeviceBatchInWordReq(McDeviceAddress deviceAddress) {
        McHeaderReq header = McHeaderReq.createByFrameType(EMcFrameType.FRAME_3E, McFrame4E3EAccessRoute.createDefault(), 3000);
        return McReqBuilder.createReadDeviceBatchInWordReq(EMcSeries.QnA, header, deviceAddress);
    }

    public static McMessageReq createReadDeviceBatchInWordReq(EMcSeries series, McHeaderReq header, McDeviceAddress deviceAddress) {
        if (series.getFrameType() == EMcFrameType.FRAME_1E) {
            header.setSubHeader(EMcCommand.DEVICE_ACCESS_BATCH_READ_IN_WORD.getCode());
        }
        McReadDeviceBatchInWordReqData data = new McReadDeviceBatchInWordReqData(series, deviceAddress);
        McMessageReq req = new McMessageReq(header, data);
        req.selfCheck();
        return req;
    }

    public static McMessageReq createReadDeviceBatchInBitReq(McDeviceAddress deviceAddress) {
        McHeaderReq header = McHeaderReq.createByFrameType(EMcFrameType.FRAME_3E, McFrame4E3EAccessRoute.createDefault(), 3000);
        return McReqBuilder.createReadDeviceBatchInBitReq(EMcSeries.QnA, header, deviceAddress);
    }

    public static McMessageReq createReadDeviceBatchInBitReq(EMcSeries series, McHeaderReq header, McDeviceAddress deviceAddress) {
        if (series.getFrameType() == EMcFrameType.FRAME_1E) {
            header.setSubHeader(EMcCommand.DEVICE_ACCESS_BATCH_READ_IN_BIT.getCode());
        }
        McReadDeviceBatchInBitReqData data = new McReadDeviceBatchInBitReqData(series, deviceAddress);
        McMessageReq req = new McMessageReq(header, data);
        req.selfCheck();
        return req;
    }

    public static McMessageReq createWriteDeviceBatchInWordReq(McDeviceContent deviceContent) {
        McHeaderReq header = McHeaderReq.createByFrameType(EMcFrameType.FRAME_3E, McFrame4E3EAccessRoute.createDefault(), 3000);
        return McReqBuilder.createWriteDeviceBatchInWordReq(EMcSeries.QnA, header, deviceContent);
    }

    public static McMessageReq createWriteDeviceBatchInWordReq(EMcSeries series, McHeaderReq header, McDeviceContent deviceContent) {
        if (series.getFrameType() == EMcFrameType.FRAME_1E) {
            header.setSubHeader(EMcCommand.DEVICE_ACCESS_BATCH_WRITE_IN_WORD.getCode());
        }
        McWriteDeviceBatchInWordReqData data = new McWriteDeviceBatchInWordReqData(series, deviceContent);
        McMessageReq req = new McMessageReq(header, data);
        req.selfCheck();
        return req;
    }

    public static McMessageReq createWriteDeviceBatchInBitReq(McDeviceContent deviceContent) {
        McHeaderReq header = McHeaderReq.createByFrameType(EMcFrameType.FRAME_3E, McFrame4E3EAccessRoute.createDefault(), 3000);
        return McReqBuilder.createWriteDeviceBatchInBitReq(EMcSeries.QnA, header, deviceContent);
    }

    public static McMessageReq createWriteDeviceBatchInBitReq(EMcSeries series, McHeaderReq header, McDeviceContent deviceContent) {
        if (series.getFrameType() == EMcFrameType.FRAME_1E) {
            header.setSubHeader(EMcCommand.DEVICE_ACCESS_BATCH_WRITE_IN_BIT.getCode());
        }
        McWriteDeviceBatchInBitReqData data = new McWriteDeviceBatchInBitReqData(series, deviceContent);
        McMessageReq req = new McMessageReq(header, data);
        req.selfCheck();
        return req;
    }

    public static McMessageReq createReadDeviceRandomInWordReq(List<McDeviceAddress> wordAddresses, List<McDeviceAddress> dwordAddresses) {
        McHeaderReq header = McHeaderReq.createByFrameType(EMcFrameType.FRAME_3E, McFrame4E3EAccessRoute.createDefault(), 3000);
        return McReqBuilder.createReadDeviceRandomInWordReq(EMcSeries.QnA, header, wordAddresses, dwordAddresses);
    }

    public static McMessageReq createReadDeviceRandomInWordReq(EMcSeries series, McHeaderReq header, List<McDeviceAddress> wordAddresses, List<McDeviceAddress> dwordAddresses) {
        if (series.getFrameType() == EMcFrameType.FRAME_1E) {
            header.setSubHeader(EMcCommand.DEVICE_ACCESS_RANDOM_WRITE_IN_WORD.getCode());
        }
        McReadDeviceRandomInWordReqData data = new McReadDeviceRandomInWordReqData(series, wordAddresses, dwordAddresses);
        McMessageReq req = new McMessageReq(header, data);
        req.selfCheck();
        return req;
    }

    public static McMessageReq createWriteDeviceRandomInWordReq(List<McDeviceContent> wordContents, List<McDeviceContent> dwordContents) {
        McHeaderReq header = McHeaderReq.createByFrameType(EMcFrameType.FRAME_3E, McFrame4E3EAccessRoute.createDefault(), 3000);
        return McReqBuilder.createWriteDeviceRandomInWordReq(EMcSeries.QnA, header, wordContents, dwordContents);
    }

    public static McMessageReq createWriteDeviceRandomInWordReq(EMcSeries series, McHeaderReq header, List<McDeviceContent> wordContents, List<McDeviceContent> dwordContents) {
        if (series.getFrameType() == EMcFrameType.FRAME_1E) {
            header.setSubHeader(EMcCommand.DEVICE_ACCESS_RANDOM_WRITE_IN_WORD.getCode());
        }
        McWriteDeviceRandomInWordReqData data = new McWriteDeviceRandomInWordReqData(series, wordContents, dwordContents);
        McMessageReq req = new McMessageReq(header, data);
        req.selfCheck();
        return req;
    }

    public static McMessageReq createWriteDeviceRandomInBitReq(List<McDeviceContent> bitContents) {
        McHeaderReq header = McHeaderReq.createByFrameType(EMcFrameType.FRAME_3E, McFrame4E3EAccessRoute.createDefault(), 3000);
        return McReqBuilder.createWriteDeviceRandomInBitReq(EMcSeries.QnA, header, bitContents);
    }

    public static McMessageReq createWriteDeviceRandomInBitReq(EMcSeries series, McHeaderReq header, List<McDeviceContent> bitContents) {
        if (series.getFrameType() == EMcFrameType.FRAME_1E) {
            header.setSubHeader(EMcCommand.DEVICE_ACCESS_RANDOM_WRITE_IN_BIT.getCode());
        }
        McWriteDeviceRandomInBitReqData data = new McWriteDeviceRandomInBitReqData(series, bitContents);
        McMessageReq req = new McMessageReq(header, data);
        req.selfCheck();
        return req;
    }

    public static McMessageReq createReadDeviceBatchMultiBlocksReq(List<McDeviceAddress> wordAddresses, List<McDeviceAddress> bitAddresses) {
        McHeaderReq header = McHeaderReq.createByFrameType(EMcFrameType.FRAME_3E, McFrame4E3EAccessRoute.createDefault(), 3000);
        return McReqBuilder.createReadDeviceBatchMultiBlocksReq(EMcSeries.QnA, header, wordAddresses, bitAddresses);
    }

    public static McMessageReq createReadDeviceBatchMultiBlocksReq(EMcSeries series, McHeaderReq header, List<McDeviceAddress> wordAddresses, List<McDeviceAddress> bitAddresses) {
        McReadDeviceBatchMultiBlocksReqData data = new McReadDeviceBatchMultiBlocksReqData(series, wordAddresses, bitAddresses);
        McMessageReq req = new McMessageReq(header, data);
        req.selfCheck();
        return req;
    }

    public static McMessageReq createWriteDeviceBatchMultiBlocksReq(List<McDeviceContent> wordContents, List<McDeviceContent> bitContents) {
        McHeaderReq header = McHeaderReq.createByFrameType(EMcFrameType.FRAME_3E, McFrame4E3EAccessRoute.createDefault(), 3000);
        return McReqBuilder.createWriteDeviceBatchMultiBlocksReq(EMcSeries.QnA, header, wordContents, bitContents);
    }

    public static McMessageReq createWriteDeviceBatchMultiBlocksReq(EMcSeries series, McHeaderReq header, List<McDeviceContent> wordContents, List<McDeviceContent> bitContents) {
        McWriteDeviceBatchMultiBlocksReqData data = new McWriteDeviceBatchMultiBlocksReqData(series, wordContents, bitContents);
        McMessageReq req = new McMessageReq(header, data);
        req.selfCheck();
        return req;
    }
}

