/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceContent;
import com.github.xingshuangs.iot.protocol.melsec.model.McReqData;

public class McWriteDeviceBatchReqData
extends McReqData {
    protected McDeviceContent deviceContent;

    @Override
    public int byteArrayLength() {
        return (this.series.getFrameType() == EMcFrameType.FRAME_1E ? 0 : 4) + this.deviceContent.byteArrayLengthWithPointsCount(this.series);
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength(), true);
        if (this.series.getFrameType() != EMcFrameType.FRAME_1E) {
            buff.putShort(this.command.getCode()).putShort(this.subcommand);
        }
        return buff.putBytes(this.deviceContent.toByteArrayWithPointsCount(this.series)).getData();
    }

    public McDeviceContent getDeviceContent() {
        return this.deviceContent;
    }

    public void setDeviceContent(McDeviceContent deviceContent) {
        this.deviceContent = deviceContent;
    }

    @Override
    public String toString() {
        return "McWriteDeviceBatchReqData(deviceContent=" + this.getDeviceContent() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McWriteDeviceBatchReqData)) {
            return false;
        }
        McWriteDeviceBatchReqData other = (McWriteDeviceBatchReqData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        McDeviceContent this$deviceContent = this.getDeviceContent();
        McDeviceContent other$deviceContent = other.getDeviceContent();
        return !(this$deviceContent == null ? other$deviceContent != null : !((Object)this$deviceContent).equals(other$deviceContent));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McWriteDeviceBatchReqData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        McDeviceContent $deviceContent = this.getDeviceContent();
        result = result * 59 + ($deviceContent == null ? 43 : ((Object)$deviceContent).hashCode());
        return result;
    }
}

