/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.McCommException;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcCommand;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceContent;
import com.github.xingshuangs.iot.protocol.melsec.model.McReqData;
import java.util.ArrayList;
import java.util.List;

public class McWriteDeviceRandomInWordReqData
extends McReqData {
    private List<McDeviceContent> wordContents;
    private List<McDeviceContent> dwordContents;

    public McWriteDeviceRandomInWordReqData() {
        this(EMcSeries.Q_L, new ArrayList<McDeviceContent>(), new ArrayList<McDeviceContent>());
    }

    public McWriteDeviceRandomInWordReqData(EMcSeries series) {
        this(series, new ArrayList<McDeviceContent>(), new ArrayList<McDeviceContent>());
    }

    public McWriteDeviceRandomInWordReqData(EMcSeries series, List<McDeviceContent> wordContents, List<McDeviceContent> dwordContents) {
        if (series.getFrameType() == EMcFrameType.FRAME_1E && !dwordContents.isEmpty()) {
            throw new McCommException("Frame 1E only supports word, not dword");
        }
        this.series = series;
        this.command = EMcCommand.DEVICE_ACCESS_RANDOM_WRITE_IN_UNITS;
        this.subcommand = series != EMcSeries.IQ_R ? 0 : 2;
        this.wordContents = wordContents;
        this.dwordContents = dwordContents;
    }

    @Override
    public int byteArrayLength() {
        return (this.series.getFrameType() == EMcFrameType.FRAME_1E ? 2 : 6) + this.wordContents.stream().mapToInt(x -> x.byteArrayLengthWithoutPointsCount(this.series)).sum() + this.dwordContents.stream().mapToInt(x -> x.byteArrayLengthWithoutPointsCount(this.series)).sum();
    }

    @Override
    public byte[] toByteArray() {
        ByteWriteBuff buff = ByteWriteBuff.newInstance(this.byteArrayLength(), true);
        if (this.series.getFrameType() == EMcFrameType.FRAME_1E) {
            buff.putShort(this.wordContents.size());
        } else {
            buff.putShort(this.command.getCode()).putShort(this.subcommand).putByte(this.wordContents.size()).putByte(this.dwordContents.size());
        }
        this.wordContents.forEach(x -> buff.putBytes(x.toByteArrayWithoutPointsCount(this.series)));
        this.dwordContents.forEach(x -> buff.putBytes(x.toByteArrayWithoutPointsCount(this.series)));
        return buff.getData();
    }

    public List<McDeviceContent> getWordContents() {
        return this.wordContents;
    }

    public List<McDeviceContent> getDwordContents() {
        return this.dwordContents;
    }

    public void setWordContents(List<McDeviceContent> wordContents) {
        this.wordContents = wordContents;
    }

    public void setDwordContents(List<McDeviceContent> dwordContents) {
        this.dwordContents = dwordContents;
    }

    @Override
    public String toString() {
        return "McWriteDeviceRandomInWordReqData(wordContents=" + this.getWordContents() + ", dwordContents=" + this.getDwordContents() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McWriteDeviceRandomInWordReqData)) {
            return false;
        }
        McWriteDeviceRandomInWordReqData other = (McWriteDeviceRandomInWordReqData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<McDeviceContent> this$wordContents = this.getWordContents();
        List<McDeviceContent> other$wordContents = other.getWordContents();
        if (this$wordContents == null ? other$wordContents != null : !((Object)this$wordContents).equals(other$wordContents)) {
            return false;
        }
        List<McDeviceContent> this$dwordContents = this.getDwordContents();
        List<McDeviceContent> other$dwordContents = other.getDwordContents();
        return !(this$dwordContents == null ? other$dwordContents != null : !((Object)this$dwordContents).equals(other$dwordContents));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McWriteDeviceRandomInWordReqData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<McDeviceContent> $wordContents = this.getWordContents();
        result = result * 59 + ($wordContents == null ? 43 : ((Object)$wordContents).hashCode());
        List<McDeviceContent> $dwordContents = this.getDwordContents();
        result = result * 59 + ($dwordContents == null ? 43 : ((Object)$dwordContents).hashCode());
        return result;
    }
}

