/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.service;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.common.buff.EByteBuffFormat;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceContent;
import java.util.ArrayList;
import java.util.List;

public class McMultiAddressWrite {
    private final List<McDeviceContent> words = new ArrayList<McDeviceContent>();
    private final List<McDeviceContent> dwords = new ArrayList<McDeviceContent>();

    public McMultiAddressWrite addUInt16(String address, int data) {
        byte[] bytes = ByteWriteBuff.newInstance(2, true).putShort(data).getData();
        this.words.add(McDeviceContent.createBy(address, bytes));
        return this;
    }

    public McMultiAddressWrite addInt16(String address, short data) {
        byte[] bytes = ByteWriteBuff.newInstance(2, true).putShort(data).getData();
        this.words.add(McDeviceContent.createBy(address, bytes));
        return this;
    }

    public McMultiAddressWrite addInt16(String address, int data) {
        byte[] bytes = ByteWriteBuff.newInstance(2, true).putShort(data).getData();
        this.words.add(McDeviceContent.createBy(address, bytes));
        return this;
    }

    public McMultiAddressWrite addUInt32(String address, long data) {
        byte[] bytes = ByteWriteBuff.newInstance(4, EByteBuffFormat.AB_CD).putInteger(data).getData();
        this.dwords.add(McDeviceContent.createBy(address, bytes));
        return this;
    }

    public McMultiAddressWrite addInt32(String address, int data) {
        byte[] bytes = ByteWriteBuff.newInstance(4, EByteBuffFormat.AB_CD).putInteger(data).getData();
        this.dwords.add(McDeviceContent.createBy(address, bytes));
        return this;
    }

    public McMultiAddressWrite addFloat32(String address, float data) {
        byte[] bytes = ByteWriteBuff.newInstance(4, EByteBuffFormat.AB_CD).putFloat(data).getData();
        this.dwords.add(McDeviceContent.createBy(address, bytes));
        return this;
    }

    public List<McDeviceContent> getWords() {
        return this.words;
    }

    public List<McDeviceContent> getDwords() {
        return this.dwords;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McMultiAddressWrite)) {
            return false;
        }
        McMultiAddressWrite other = (McMultiAddressWrite)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<McDeviceContent> this$words = this.getWords();
        List<McDeviceContent> other$words = other.getWords();
        if (this$words == null ? other$words != null : !((Object)this$words).equals(other$words)) {
            return false;
        }
        List<McDeviceContent> this$dwords = this.getDwords();
        List<McDeviceContent> other$dwords = other.getDwords();
        return !(this$dwords == null ? other$dwords != null : !((Object)this$dwords).equals(other$dwords));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McMultiAddressWrite;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<McDeviceContent> $words = this.getWords();
        result = result * 59 + ($words == null ? 43 : ((Object)$words).hashCode());
        List<McDeviceContent> $dwords = this.getDwords();
        result = result * 59 + ($dwords == null ? 43 : ((Object)$dwords).hashCode());
        return result;
    }

    public String toString() {
        return "McMultiAddressWrite(words=" + this.getWords() + ", dwords=" + this.getDwords() + ")";
    }
}

