/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.enums;

import java.util.HashMap;
import java.util.Map;

public enum EMbExceptionCode {
    ILLEGAL_FUNCTION(1, "illegal function"),
    ILLEGAL_DATA_ADDRESS(2, "illegal data address"),
    ILLEGAL_DATA_VALUE(3, "illegal data value"),
    SLAVE_DEVICE_FAILURE(4, "slave device failure"),
    ACKNOWLEDGE(5, "acknowledge"),
    SLAVE_DEVICE_BUSY(6, "slave device busy"),
    MEMORY_PARITY_ERROR(8, "memory parity error"),
    GATEWAY_PATH_UNAVAILABLE(10, "gateway path unavailable"),
    GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND(11, "gateway target device failed to respond");

    private final byte code;
    private final String description;

    public static EMbExceptionCode from(byte data) {
        return (EMbExceptionCode)((Object)Holder.INSTANCE.get(data));
    }

    private EMbExceptionCode(byte code, String description) {
        this.code = code;
        this.description = description;
    }

    public byte getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private static class Holder {
        private static final Map<Byte, EMbExceptionCode> INSTANCE = Holder.createMap();

        private Holder() {
        }

        private static Map<Byte, EMbExceptionCode> createMap() {
            HashMap<Byte, EMbExceptionCode> map = new HashMap<Byte, EMbExceptionCode>();
            for (EMbExceptionCode item : EMbExceptionCode.values()) {
                map.put(item.code, item);
            }
            return map;
        }
    }
}

