/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.enums;

import java.util.HashMap;
import java.util.Map;

public enum EMbFunctionCode {
    READ_COIL(1, "read coil"),
    READ_DISCRETE_INPUT(2, "read discrete input"),
    READ_HOLD_REGISTER(3, "read hold register"),
    READ_INPUT_REGISTER(4, "read input register"),
    WRITE_SINGLE_COIL(5, "write single coil"),
    WRITE_SINGLE_REGISTER(6, "write single register"),
    WRITE_MULTIPLE_COIL(15, "write multiple coil"),
    WRITE_MULTIPLE_REGISTER(16, "write multiple register"),
    READ_DOCUMENT_RECORD(20, "read document record"),
    SHIELD_WRITE_REGISTER(22, "shield write register"),
    READ_WRITE_MULTIPLE_REGISTER(23, "read write multiple register"),
    READ_DEVICE_IDENTIFICATION_CODE(43, "read device identification code"),
    ERROR_READ_COIL(-127, "error read coil"),
    ERROR_READ_DISCRETE_INPUT(-126, "error read discrete input"),
    ERROR_READ_HOLD_REGISTER(-125, "error read hold register"),
    ERROR_READ_INPUT_REGISTER(-124, "error read input register"),
    ERROR_WRITE_SINGLE_COIL(-123, "error write single coil"),
    ERROR_WRITE_SINGLE_REGISTER(-122, "error write single register"),
    ERROR_WRITE_MULTIPLE_COIL(-113, "error write multiple coil"),
    ERROR_WRITE_MULTIPLE_REGISTER(-112, "error write multiple register"),
    ERROR_READ_DOCUMENT_RECORD(-108, "error read document record"),
    ERROR_SHIELD_WRITE_REGISTER(-106, "error shield write register"),
    ERROR_READ_WRITE_MULTIPLE_REGISTER(-105, "error read write multiple register");

    private final byte code;
    private final String description;

    public static EMbFunctionCode from(byte data) {
        return (EMbFunctionCode)((Object)Holder.INSTANCE.get(data));
    }

    private EMbFunctionCode(byte code, String description) {
        this.code = code;
        this.description = description;
    }

    public byte getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    private static class Holder {
        private static final Map<Byte, EMbFunctionCode> INSTANCE = Holder.createMap();

        private Holder() {
        }

        private static Map<Byte, EMbFunctionCode> createMap() {
            HashMap<Byte, EMbFunctionCode> map = new HashMap<Byte, EMbFunctionCode>();
            for (EMbFunctionCode item : EMbFunctionCode.values()) {
                map.put(item.code, item);
            }
            return map;
        }
    }
}

