/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbExceptionCode;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;

public class MbErrorResponse
extends MbPdu {
    private EMbExceptionCode errorCode;

    public MbErrorResponse() {
    }

    public MbErrorResponse(EMbFunctionCode functionCode, EMbExceptionCode errorCode) {
        this.functionCode = functionCode;
        this.errorCode = errorCode;
    }

    @Override
    public int byteArrayLength() {
        return 2;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(2).putByte(this.functionCode.getCode()).putByte(this.errorCode.getCode()).getData();
    }

    public static MbErrorResponse fromBytes(byte[] data) {
        return MbErrorResponse.fromBytes(data, 0);
    }

    public static MbErrorResponse fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbErrorResponse res = new MbErrorResponse();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.errorCode = EMbExceptionCode.from(buff.getByte());
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbErrorResponse)) {
            return false;
        }
        MbErrorResponse other = (MbErrorResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EMbExceptionCode this$errorCode = this.getErrorCode();
        EMbExceptionCode other$errorCode = other.getErrorCode();
        return !(this$errorCode == null ? other$errorCode != null : !((Object)((Object)this$errorCode)).equals((Object)other$errorCode));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbErrorResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        EMbExceptionCode $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)((Object)$errorCode)).hashCode());
        return result;
    }

    public EMbExceptionCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(EMbExceptionCode errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public String toString() {
        return "MbErrorResponse(errorCode=" + (Object)((Object)this.getErrorCode()) + ")";
    }
}

